/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibabacloud.intellij.cosy.chat.model.ChatContextFeature;
import com.alibabacloud.intellij.cosy.common.CosyCacheKeys;
import com.alibabacloud.intellij.cosy.completion.trigger.CommentTriggerChecker;
import com.alibabacloud.intellij.cosy.core.Cosy;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.RewriteCodeAction;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.CompletionParams;
import com.alibabacloud.intellij.cosy.editor.action.InlineActionType;
import com.alibabacloud.intellij.cosy.editor.model.CosyEditorInlayItem;
import com.alibabacloud.intellij.cosy.editor.model.CosyEditorInlayList;
import com.alibabacloud.intellij.cosy.editor.model.DiffChangeModel;
import com.alibabacloud.intellij.cosy.editor.model.InlayDisposeEventEnum;
import com.alibabacloud.intellij.cosy.editor.model.InlineEditRequest;
import com.alibabacloud.intellij.cosy.search.asyn.Debouncer;
import com.alibabacloud.intellij.cosy.search.enums.CompletionTriggerModeEnum;
import com.alibabacloud.intellij.cosy.search.enums.InlineTriggerModeEnum;
import com.alibabacloud.intellij.cosy.search.enums.TrackEventTypeEnum;
import com.alibabacloud.intellij.cosy.service.ModeService;
import com.alibabacloud.intellij.cosy.service.TelemetryService;
import com.alibabacloud.intellij.cosy.service.TelemetryThread;
import com.alibabacloud.intellij.cosy.service.enums.SceneTypeEnum;
import com.alibabacloud.intellij.cosy.service.enums.TextChangeTypeEnum;
import com.alibabacloud.intellij.cosy.service.listener.CompletionEventListener;
import com.alibabacloud.intellij.cosy.service.model.AssistantTextChangeSourceMetric;
import com.alibabacloud.intellij.cosy.service.model.BaseMetric;
import com.alibabacloud.intellij.cosy.service.model.BaseTextChangeSourceMetric;
import com.alibabacloud.intellij.cosy.service.model.Features;
import com.alibabacloud.intellij.cosy.service.model.MethodHintMetricSummary;
import com.alibabacloud.intellij.cosy.service.model.MethodHintPerformanceStat;
import com.alibabacloud.intellij.cosy.service.model.TextChangeContext;
import com.alibabacloud.intellij.cosy.service.model.TextChangeDetailBO;
import com.alibabacloud.intellij.cosy.service.model.TextChangeReportStrategy;
import com.alibabacloud.intellij.cosy.service.model.TextChangeSourceChat;
import com.alibabacloud.intellij.cosy.service.model.TextChangeSourceChatDetail;
import com.alibabacloud.intellij.cosy.service.model.TextChangeSourceDetail;
import com.alibabacloud.intellij.cosy.service.model.TextChangeStat;
import com.alibabacloud.intellij.cosy.service.model.TextChangeSummaryBO;
import com.alibabacloud.intellij.cosy.service.model.TimestampEnum;
import com.alibabacloud.intellij.cosy.service.model.TypingStat;
import com.alibabacloud.intellij.cosy.ui.search.model.GenerateInput;
import com.alibabacloud.intellij.cosy.ui.search.model.tag.ChatAskTag;
import com.alibabacloud.intellij.cosy.util.ChatTaskUtil;
import com.alibabacloud.intellij.cosy.util.EditorUtil;
import com.alibabacloud.intellij.cosy.util.FileUtil;
import com.alibabacloud.intellij.cosy.util.LanguageUtil;
import com.alibabacloud.intellij.cosy.util.ProjectUtils;
import com.alibabacloud.intellij.cosy.util.PsiUtils;
import com.alibabacloud.intellij.cosy.util.TypingSpeeder;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class TelemetryServiceImpl
implements TelemetryService {
    static Logger logger = Logger.getInstance(TelemetryServiceImpl.class);
    static Set<String> ignoreCommands = new HashSet<String>(Arrays.asList("Async Render Tongyi Suggestion", "Chat Insert Code"));
    private TypingSpeeder typingSpeeder = new TypingSpeeder();
    private AtomicReference<String> lastCommand = new AtomicReference<Object>(null);
    private AtomicReference<String> currentCommand = new AtomicReference<Object>(null);
    private AtomicReference<String> latestDisposeType = new AtomicReference<Object>(null);
    private AtomicReference<String> latestDisposeCommandName = new AtomicReference<Object>(null);
    private AtomicReference<Boolean> lastAccepted = new AtomicReference<Object>(null);
    private AtomicReference<Long> lastAcceptTimeMs = new AtomicReference<Object>(null);
    private AtomicReference<Long> lastDisposeTimeMs = new AtomicReference<Object>(null);
    private AtomicLong lastAcceptTime = new AtomicLong(0L);
    private final Map<String, Timer> timerMap = new ConcurrentHashMap<String, Timer>();
    private Map<String, Debouncer> textChangeDebouncerMap = new ConcurrentHashMap<String, Debouncer>();
    private static List<CompletionEventListener> completionEventListener = List.of(new CommentTriggerChecker.CommentCompletionEventListener());
    private static final int CACHE_MINUTE_LIMIT = 10;
    private static final int CACHE_METHOD_HINT_PERFORMANCE_LIMIT = 5000;
    private final Cache<String, Boolean> disposeDuplicateCaches = Caffeine.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build();

    @Override
    public void initTelemetry(Project project) {
        String basePath = ProjectUtils.getProjectBaseDir(project);
        long delayTime = TimeUnit.SECONDS.toMillis(Features.REPORT_TEXT_CHANGE_FIXED_TIME.longValue());
        try {
            logger.info("start telemetry:" + project.getName());
            Timer timer = this.timerMap.computeIfAbsent(basePath, s -> new Timer());
            timer.scheduleAtFixedRate((TimerTask)new TelemetryThread(project), delayTime, delayTime);
        }
        catch (Exception e) {
            logger.warn("Failed to start telemetry thread. and retry", (Throwable)e);
            this.timerMap.remove(basePath);
            Timer timer = this.timerMap.computeIfAbsent(basePath, s -> new Timer());
            timer.scheduleAtFixedRate((TimerTask)new TelemetryThread(project), delayTime, delayTime);
        }
    }

    @Override
    public void destroyTelemetry(Project project) {
        Timer timer;
        String basePath = ProjectUtils.getProjectBaseDir(project);
        if (this.timerMap.containsKey(basePath) && (timer = this.timerMap.remove(basePath)) != null) {
            timer.cancel();
        }
    }

    @Override
    public void telemetry(Project project, TrackEventTypeEnum eventType, String requestId, Map<String, String> data) {
        try {
            if (!Cosy.INSTANCE.checkCosy(project, false)) {
                logger.warn("invalid cosy service, ignore telemetry");
                return;
            }
            logger.debug("send telemetry: " + eventType.getName() + " " + requestId + " " + data);
            Cosy.INSTANCE.getLanguageService(project).telemetry(eventType.getName(), requestId, data);
        }
        catch (Exception e) {
            logger.warn("telemetry error." + e.getMessage());
        }
    }

    @Override
    public void telemetryChatTask(Project project, TrackEventTypeEnum eventType, String requestId, String sessionId, String chatTask, final GenerateInput input, String sessionType) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("chatTask", chatTask);
        data.put("sessionId", sessionId);
        data.put("session_type", sessionType);
        data.put("mode", ModeService.getInstance().getModeForTelemetry(project));
        this.processTelemetryFields(input, data);
        if (null != input.getExtra() && null != input.getExtra().getCommand()) {
            data.put("command", JSON.toJSONString((Object)new HashMap<String, String>(){
                private static final long serialVersionUID = 7845858051705803101L;
                {
                    this.put("identifier", input.getExtra().getCommand().getIdentifier());
                    this.put("name", input.getExtra().getCommand().getName());
                }
            }));
        }
        if (StringUtils.isNotBlank((CharSequence)input.getTaskDefinitionType())) {
            data.put("taskDefinitionType", input.getTaskDefinitionType());
        }
        if (null != input.getChatAskInput() && CollectionUtils.isNotEmpty(input.getChatAskInput().getContextTags())) {
            data.put("contexts", JSON.toJSONString(input.getChatAskInput().getContextTags().stream().map(tag -> new HashMap<String, String>(){
                private static final long serialVersionUID = 7934535821536357860L;
                {
                    if (null == tag.getContextProvider()) {
                        this.put("identifier", tag.getId());
                        this.put("name", tag.getType());
                        this.put("sourceType", tag.getSourceType());
                    } else {
                        this.put("identifier", tag.getContextProvider().getId());
                        this.put("name", tag.getContextProvider().getContextName());
                        this.put("sourceType", tag.getContextProvider().getSourceType());
                    }
                }
            }).collect(Collectors.toList())));
        }
        this.telemetry(project, eventType, requestId, data);
    }

    private void processTelemetryFields(GenerateInput input, Map<String, String> data) {
        List<ChatAskTag> tagList;
        if (input.getChatContext() != null && input.getChatContext().getFileLanguage() != null) {
            data.put("language", input.getChatContext().getFileLanguage());
        }
        if (input.getChatAskInput() != null && CollectionUtils.isNotEmpty(tagList = input.getChatAskInput().getTags())) {
            List<ChatContextFeature> features = ChatTaskUtil.getFeatureFromTag(tagList);
            data.put("features", JSON.toJSONString(features));
        }
    }

    @Override
    public void telemetryChatCodeAccept(Project project, TrackEventTypeEnum eventType, String requestId, String sessionId, String chatTask, String content) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("sourceType", chatTask == null ? "" : chatTask);
        data.put("sourceRequestId", requestId == null ? "" : requestId);
        data.put("acceptCharLength", content == null ? "0" : String.valueOf(content.length()));
        data.put("acceptNewLineCount", content == null ? "0" : String.valueOf(content.split("\n").length));
        this.telemetry(project, eventType, requestId, data);
    }

    @Override
    public void telemetryChatCodeExpand(Project project, TrackEventTypeEnum eventType, String requestId, String sessionId, String chatTask, String content) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("sourceType", chatTask == null ? "" : chatTask);
        data.put("sourceRequestId", requestId == null ? "" : requestId);
        data.put("totalCharLength", content == null ? "0" : String.valueOf(content.length()));
        data.put("totalNewLineCount", content == null ? "0" : String.valueOf(content.split("\n").length));
        this.telemetry(project, eventType, requestId, data);
    }

    @Override
    public void telemetrySessionId(Project project, TrackEventTypeEnum eventType, String requestId, String sessionId) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("sessionId", sessionId);
        this.telemetry(project, eventType, requestId, data);
    }

    @Override
    public void telemetrySessionId(Project project, TrackEventTypeEnum eventType, String requestId, String sessionId, String sessionType) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("sessionId", sessionId);
        data.put("session_type", sessionType);
        this.telemetry(project, eventType, requestId, data);
    }

    @Override
    public void telemetrySessionId(Project project, TrackEventTypeEnum eventType, String requestId, String sessionId, String chatTask, String sessionType) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("sessionId", sessionId);
        data.put("session_type", sessionType);
        data.put("chatTask", chatTask);
        this.telemetry(project, eventType, requestId, data);
    }

    @Override
    public void triggerCompletion(CompletionTriggerModeEnum triggerMode, Editor editor, CompletionParams params) {
        String language;
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("triggerMode", triggerMode.getName());
        data.put("useLocalModel", String.valueOf(params.getUseLocalModel()));
        data.put("useRemoteModel", String.valueOf(params.getUseRemoteModel()));
        TypingStat stat = this.getTypeStat();
        data.put("avgTypingSpeed", String.valueOf(stat.getAvgTypingSpeed()));
        data.put("lastTypingSpeed", String.valueOf(stat.getLastTypingSpeed()));
        data.put("typingLength", String.valueOf(stat.getTypingLength()));
        data.put("lastTypedChars", stat.getLastTypedChars());
        data.put("currentTypedChars", stat.getCurrentTypedChars());
        data.put("typedCharRowDiff", stat.getTypedCharRowDiff() == null ? null : String.valueOf(stat.getTypedCharRowDiff()));
        if (params.getTextDocument() != null && StringUtils.isNotBlank((CharSequence)(language = LanguageUtil.getLanguageByFilePath(params.getTextDocument().getUri())))) {
            data.put("language", language.toLowerCase(Locale.ROOT));
        }
        this.buildMeasurements(editor, data, null);
        if (params.getCompletionContextParams() != null) {
            data.put("context", JSON.toJSONString((Object)params.getCompletionContextParams()));
        }
        this.telemetry(editor.getProject(), TrackEventTypeEnum.INLINE_COMPLETION_TRIGGER, params.getRequestId(), data);
    }

    @Override
    public void disposeCompletion(InlayDisposeEventEnum disposeAction, Editor editor, CosyEditorInlayList inlayList) {
        this.disposeCompletion(disposeAction, editor, inlayList, null);
    }

    @Override
    public void disposeCompletion(InlayDisposeEventEnum disposeAction, Editor editor, CosyEditorInlayList inlayList, String commandName) {
        if (InlayDisposeEventEnum.GENERATING.getName().equals(disposeAction.getName()) || InlayDisposeEventEnum.ACCEPTED.getName().equals(disposeAction.getName()) || inlayList == null || inlayList.getItems() == null || inlayList.getItems().isEmpty()) {
            return;
        }
        for (CosyEditorInlayItem item : inlayList.getItems()) {
            if (!item.isAccepted()) continue;
            return;
        }
        String filepath = EditorUtil.getEditorFilePath(editor);
        String language = null;
        if (filepath != null) {
            language = LanguageUtil.getLanguageByFilePath(filepath);
        }
        CosyEditorInlayItem headItem = inlayList.getItems().get(0);
        String batchId = headItem.getRequestId();
        for (int i = 0; i < inlayList.getItems().size(); ++i) {
            CosyEditorInlayItem item = inlayList.getItems().get(i);
            String duplicateKey = String.format("dispose_%s_%b", item.getRequestId(), item.isRendered());
            Boolean isDuplicate = (Boolean)this.disposeDuplicateCaches.getIfPresent((Object)duplicateKey);
            if (isDuplicate != null && isDuplicate.booleanValue()) {
                logger.debug("Duplicate request:" + item.getRequestId() + " dispose event:" + duplicateKey + " has been recorded");
                continue;
            }
            this.disposeDuplicateCaches.put((Object)duplicateKey, (Object)true);
            String disposeType = disposeAction.getName();
            if ("".equals(item.getContent())) {
                disposeType = InlayDisposeEventEnum.EMPTY_RESULT.getName();
            }
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("disposeType", disposeType);
            data.put("rendered", String.valueOf(item.isRendered()));
            data.put("totalLineCount", String.valueOf(item.getTotalLineCount()));
            data.put("totalChars", String.valueOf(item.getContent().length()));
            data.put("index", String.valueOf(i));
            if (i == inlayList.getSelectIndex() && InlayDisposeEventEnum.ACCEPTED.getName().equals(disposeAction.getName())) {
                data.put("accepted", "true");
            } else {
                data.put("accepted", "false");
            }
            if (StringUtils.isNotBlank((CharSequence)language)) {
                data.put("language", language.toLowerCase(Locale.ROOT));
            }
            if (commandName != null) {
                data.put("commandName", commandName);
            }
            if (StringUtils.isNotEmpty((CharSequence)item.getCacheId())) {
                data.put("cacheId", item.getCacheId());
            }
            if (StringUtils.isNotBlank((CharSequence)item.getBatchId())) {
                batchId = item.getBatchId();
            }
            data.put("batchId", batchId);
            data.put("useCache", String.valueOf(item.isUseCache()));
            this.buildMeasurements(editor, data, item);
            this.telemetry(editor.getProject(), TrackEventTypeEnum.INLINE_COMPLETION_DISPOSE, item.getRequestId(), data);
        }
        this.latestDisposeType.getAndSet(disposeAction.getName());
        this.latestDisposeCommandName.getAndSet(commandName);
        this.lastAccepted.getAndSet(false);
        this.lastDisposeTimeMs.getAndSet(System.currentTimeMillis());
        completionEventListener.forEach(listener -> listener.disposeCompletion(inlayList, disposeAction));
    }

    @Override
    public void applyCompletion(Editor editor, CosyEditorInlayItem inlayItem, Integer acceptLineCount, Integer acceptChars) {
        String filepath = EditorUtil.getEditorFilePath(editor);
        String language = null;
        if (filepath != null) {
            language = LanguageUtil.getLanguageByFilePath(filepath);
        }
        this.lastAcceptTime.getAndSet(System.currentTimeMillis());
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("acceptLineCount", String.valueOf(acceptLineCount));
        data.put("totalLineCount", String.valueOf(inlayItem.getTotalLineCount()));
        data.put("totalChars", String.valueOf(inlayItem.getContent().length()));
        data.put("acceptChars", String.valueOf(acceptChars));
        data.put("index", String.valueOf(inlayItem.getRankIndex()));
        if (StringUtils.isNotEmpty((CharSequence)inlayItem.getCacheId())) {
            data.put("cacheId", inlayItem.getCacheId());
        }
        if (StringUtils.isNotBlank((CharSequence)inlayItem.getBatchId())) {
            data.put("batchId", inlayItem.getBatchId());
        }
        if (StringUtils.isNotBlank((CharSequence)language)) {
            data.put("language", language.toLowerCase(Locale.ROOT));
        }
        data.put("useCache", String.valueOf(inlayItem.isUseCache()));
        this.buildMeasurements(editor, data, inlayItem);
        this.telemetry(editor.getProject(), TrackEventTypeEnum.INLINE_COMPLETION_ACCEPT, inlayItem.getRequestId(), data);
        this.lastAccepted.getAndSet(true);
        this.lastAcceptTimeMs.getAndSet(System.currentTimeMillis());
        completionEventListener.forEach(listener -> listener.acceptCompletion(editor, inlayItem));
    }

    @Override
    public void typeRecord(Editor editor, String addedText) {
        this.typingSpeeder.keyTyped(addedText);
        this.typingSpeeder.recordTyping(editor, addedText);
    }

    @Override
    public void telemetryCommand(@NotNull CommandEvent event) {
        if (event == null) {
            TelemetryServiceImpl.$$$reportNull$$$0(0);
        }
        if (ignoreCommands.contains(event.getCommandName())) {
            return;
        }
        String lastCmd = this.currentCommand.getAndSet(event.getCommandName());
        this.lastCommand.getAndSet(lastCmd);
    }

    @Override
    public void clearTypeCommandRecord() {
        this.lastCommand.set(null);
        this.currentCommand.set(null);
        this.typingSpeeder.clear();
    }

    @Override
    public TypingStat getTypeStat() {
        TypingStat stat = new TypingStat();
        stat.setAvgTypingSpeed(this.typingSpeeder.getAvgSpeed());
        stat.setLastTypingSpeed(this.typingSpeeder.getLastSpeed());
        stat.setTypingLength(this.typingSpeeder.getTypedLength());
        stat.setLastTypedChars(this.typingSpeeder.getLastTypedChars());
        stat.setCurrentTypedChars(this.typingSpeeder.getCurrentTypedChars());
        stat.setTypedCharRowDiff(this.typingSpeeder.getTypedCharRowDiff());
        return stat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void telemetryTextChange(TextChangeContext context) {
        long timestamp = System.currentTimeMillis();
        Project project = context.getProject();
        try {
            Key<List<TextChangeStat>> key = CosyCacheKeys.KEY_TEXT_CHANGE_STAT;
            synchronized (key) {
                ArrayList<TextChangeStat> changeStats = (ArrayList<TextChangeStat>)CosyCacheKeys.KEY_TEXT_CHANGE_STAT.get((UserDataHolder)project);
                if (changeStats == null) {
                    changeStats = new ArrayList<TextChangeStat>();
                }
                TextChangeStat changeStat = this.constructTextChangeStatWithSource(context, timestamp);
                logger.debug("text change stat:" + changeStat);
                changeStats.add(changeStat);
                CosyCacheKeys.KEY_TEXT_CHANGE_STAT.set((UserDataHolder)project, changeStats);
            }
            String basePath = ProjectUtils.getProjectBaseDir(project);
            if (TextChangeReportStrategy.DELAY.getValue().equals(Features.REPORT_TEXT_CHANGE_STRATEGY.stringValue())) {
                Debouncer textChangeDebouncer = this.textChangeDebouncerMap.computeIfAbsent(basePath, s -> new Debouncer());
                textChangeDebouncer.debounce(() -> this.flushTelemetryTextChange(project), Features.REPORT_TEXT_CHANGE_DELAY_TIME.longValue(), TimeUnit.SECONDS);
            }
            Map<String, Timer> map = this.timerMap;
            synchronized (map) {
                if (!this.timerMap.containsKey(basePath)) {
                    this.initTelemetry(project);
                }
            }
        }
        catch (Exception e) {
            logger.warn("telemetryTextChange error", (Throwable)e);
        }
    }

    private TextChangeStat constructTextChangeStatWithSource(TextChangeContext context, long timestamp) {
        if ("developer".equals(context.getSource())) {
            return TextChangeStat.builder().filePath(context.getFilePath()).changeCharChangeLength(context.getDeveloperAcceptedInfo().getAcceptCharLength()).changeNewLineCount(context.getDeveloperAcceptedInfo().getAcceptNewLineCount()).validNewLineCount(context.getDeveloperAcceptedInfo().getAcceptNewLineCount()).accepted(context.isAccepted()).language(context.getLanguage()).source(context.getSource()).timestamp(timestamp).sceneType(context.getSceneType()).changeType(context.getChangeType()).valid(true).nonLingmaPasted(context.isNonLingmaPasted()).chatTask(context.getChatTask()).build();
        }
        if ("assistant".equals(context.getSource())) {
            return TextChangeStat.builder().filePath(context.getFilePath()).changeCharChangeLength(context.getAssistantAcceptedInfo().getAcceptCharLength()).changeNewLineCount(context.getAssistantAcceptedInfo().getAcceptNewLineCount()).validNewLineCount(context.getAssistantAcceptedInfo().getAcceptNewLineCount()).accepted(context.isAccepted()).language(context.getLanguage()).source(context.getSource()).timestamp(timestamp).sceneType(context.getSceneType()).changeType(context.getChangeType()).valid(true).nonLingmaPasted(context.isNonLingmaPasted()).chatTask(context.getChatTask()).chatMode(context.getAssistantAcceptedInfo().getChatMode()).build();
        }
        if ("inline_edit".equals(context.getSource()) || "chat_ask_apply".equals(context.getSource())) {
            return TextChangeStat.builder().filePath(context.getFilePath()).changeCharChangeLength(context.getInlineEditAcceptedInfo().getAcceptCharLength()).changeNewLineCount(context.getInlineEditAcceptedInfo().getAcceptNewLineCount()).validNewLineCount(context.getInlineEditAcceptedInfo().getAcceptNewLineCount()).accepted(context.isAccepted()).language(context.getLanguage()).source(context.getSource()).timestamp(timestamp).sceneType(context.getSceneType()).changeType(context.getChangeType()).valid(true).nonLingmaPasted(context.isNonLingmaPasted()).chatTask(context.getChatTask()).build();
        }
        return this.constructTextChangeStat(context, timestamp);
    }

    private TextChangeStat constructTextChangeStat(TextChangeContext context, long timestamp) {
        String filePath;
        String addedText;
        TextChangeStat changeStat = new TextChangeStat();
        Integer startLineNumber = context.getStartLineNumber();
        if (startLineNumber == null) {
            startLineNumber = 0;
        }
        boolean valid = (addedText = context.getAddedText()) != null && (!addedText.trim().isEmpty() || addedText.length() <= 1);
        logger.debug("text change addedText:" + addedText.replace("\n", "\\n"));
        if (addedText.startsWith("\n")) {
            String clearText = StringUtils.stripStart((String)addedText, (String)"\n");
            startLineNumber = startLineNumber + (addedText.length() - clearText.length());
            addedText = StringUtils.stripEnd((String)clearText, (String)"\n");
        }
        changeStat.setFilePath((filePath = context.getFilePath()) == null ? UUID.randomUUID().toString() : filePath);
        changeStat.setStartLineNumber(startLineNumber);
        long validLineCount = com.alibabacloud.intellij.cosy.util.StringUtils.getNotEmptyLineCount(addedText);
        String[] addedLines = addedText.split("\n");
        changeStat.setChangeCharChangeLength(addedText.length());
        changeStat.setChangeNewLineCount(addedLines.length);
        changeStat.setValidNewLineCount(validLineCount);
        changeStat.setAccepted(context.isAccepted());
        changeStat.setTimestamp(timestamp);
        if (context.getSceneType() != null) {
            changeStat.setSceneType(context.getSceneType());
        } else if (StringUtils.isNotBlank((CharSequence)filePath)) {
            changeStat.setSceneType(FileUtil.detectSceneType(filePath).getKey());
        } else {
            changeStat.setSceneType(SceneTypeEnum.COMMON.getKey());
        }
        if (context.getLanguage() != null) {
            changeStat.setLanguage(context.getLanguage().toLowerCase(Locale.ROOT));
        }
        changeStat.setChangeType(context.getChangeType());
        changeStat.setSource(context.getSource());
        changeStat.setValid(valid);
        changeStat.setChangeLineNumbers(new HashSet<Integer>());
        int i = 0;
        while ((long)i < validLineCount) {
            changeStat.getChangeLineNumbers().add(startLineNumber + i);
            ++i;
        }
        changeStat.setNonLingmaPasted(context.isNonLingmaPasted());
        changeStat.setChatTask(context.getChatTask());
        return changeStat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushTelemetryTextChange(Project project) {
        logger.debug("flush telemetry text change");
        HashMap<String, String> data = new HashMap<String, String>();
        Key<List<TextChangeStat>> key = CosyCacheKeys.KEY_TEXT_CHANGE_STAT;
        synchronized (key) {
            List stats = (List)CosyCacheKeys.KEY_TEXT_CHANGE_STAT.get((UserDataHolder)project);
            if (stats != null && !stats.isEmpty()) {
                Map<String, List> statMap = stats.stream().collect(Collectors.groupingBy(e -> String.format("%s|%s|%s", e.getFilePath(), e.getLanguage(), e.getSceneType()), Collectors.collectingAndThen(Collectors.toList(), list -> {
                    list.sort(Comparator.comparing(TextChangeStat::getTimestamp));
                    return list;
                })));
                TextChangeSummaryBO report = new TextChangeSummaryBO();
                for (Map.Entry<String, List> entry : statMap.entrySet()) {
                    this.statTextChangeItem(report, entry.getValue());
                }
                report.fillReportData(data);
                CosyCacheKeys.KEY_TEXT_CHANGE_STAT.set((UserDataHolder)project, null);
            }
        }
        if (!data.isEmpty()) {
            this.telemetry(project, TrackEventTypeEnum.TEXT_CHANGE, UUID.randomUUID().toString(), data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushTelemetryMethodHintPerformance(Project project) {
        HashMap<String, String> data = new HashMap<String, String>();
        ArrayList<Long> checkPrevSiblingList = new ArrayList<Long>();
        ArrayList<Long> checkPsiElementTypeList = new ArrayList<Long>();
        ArrayList<Long> checkIsInvalidMethodList = new ArrayList<Long>();
        ArrayList<Long> addInlayPresentationList = new ArrayList<Long>();
        ArrayList<Long> totalList = new ArrayList<Long>();
        Key<List<MethodHintPerformanceStat>> key = CosyCacheKeys.KEY_METHOD_HINT_PERF_STAT;
        synchronized (key) {
            List stats = (List)CosyCacheKeys.KEY_METHOD_HINT_PERF_STAT.get((UserDataHolder)project);
            if (CollectionUtils.isNotEmpty((Collection)stats)) {
                Map<String, List<MethodHintPerformanceStat>> statMap = stats.stream().collect(Collectors.groupingBy(MethodHintPerformanceStat::getLanguage));
                statMap.forEach((language, statList) -> {
                    long total = 0L;
                    ArrayList<Long> languageCheckPrevSiblingList = new ArrayList<Long>();
                    ArrayList<Long> languageCheckPsiElementTypeList = new ArrayList<Long>();
                    ArrayList<Long> languageCheckIsInvalidMethodList = new ArrayList<Long>();
                    ArrayList<Long> languageAddInlayPresentationList = new ArrayList<Long>();
                    ArrayList<Long> languageTotalList = new ArrayList<Long>();
                    for (MethodHintPerformanceStat stat : statList) {
                        Long checkPrevSibling = stat.getData().get("checkPrevSibling");
                        Long checkPsiElementType = stat.getData().get("checkPsiElementType");
                        Long checkIsInvalidMethod = stat.getData().get("checkIsInvalidMethod");
                        Long addInlayPresentation = stat.getData().get("addInlayPresentation");
                        total += this.computeStepMetric(checkPrevSibling, checkPrevSiblingList, languageCheckPrevSiblingList);
                        total += this.computeStepMetric(checkPsiElementType, checkPsiElementTypeList, languageCheckPsiElementTypeList);
                        total += this.computeStepMetric(checkIsInvalidMethod, checkIsInvalidMethodList, languageCheckIsInvalidMethodList);
                        totalList.add(total += this.computeStepMetric(addInlayPresentation, addInlayPresentationList, languageAddInlayPresentationList));
                        languageTotalList.add(total);
                    }
                    BaseMetric languageTotal = this.getBaseMetric(languageTotalList);
                    BaseMetric languageSummary = ((MethodHintMetricSummary.MethodHintMetricSummaryBuilder)((MethodHintMetricSummary.MethodHintMetricSummaryBuilder)((MethodHintMetricSummary.MethodHintMetricSummaryBuilder)((MethodHintMetricSummary.MethodHintMetricSummaryBuilder)((MethodHintMetricSummary.MethodHintMetricSummaryBuilder)((MethodHintMetricSummary.MethodHintMetricSummaryBuilder)((MethodHintMetricSummary.MethodHintMetricSummaryBuilder)((MethodHintMetricSummary.MethodHintMetricSummaryBuilder)MethodHintMetricSummary.builder().size(languageTotal.getSize())).sum(languageTotal.getSum())).avg(languageTotal.getAvg())).p90(languageTotal.getP90())).checkPrevSibling(this.getBaseMetric(languageCheckPrevSiblingList))).checkPsiElementType(this.getBaseMetric(languageCheckPsiElementTypeList))).checkIsInvalidMethod(this.getBaseMetric(languageCheckIsInvalidMethodList))).addInlayPresentation(this.getBaseMetric(languageAddInlayPresentationList))).build();
                    data.put((String)language, JSON.toJSONString((Object)languageSummary));
                });
                if (!totalList.isEmpty()) {
                    BaseMetric total = this.getBaseMetric(totalList);
                    data.put("size", String.valueOf(total.getSize()));
                    data.put("sum", String.valueOf(total.getSum()));
                    data.put("avg", String.valueOf(total.getAvg()));
                    data.put("ninetyPercentile", String.valueOf(total.getP90()));
                    this.setMetric(checkPrevSiblingList, "checkPrevSibling", data);
                    this.setMetric(checkPsiElementTypeList, "checkPsiElementType", data);
                    this.setMetric(checkIsInvalidMethodList, "checkIsInvalidMethod", data);
                    this.setMetric(addInlayPresentationList, "addInlayPresentation", data);
                }
                CosyCacheKeys.KEY_METHOD_HINT_PERF_STAT.set((UserDataHolder)project, null);
            }
        }
        if (!data.isEmpty()) {
            this.telemetry(project, TrackEventTypeEnum.METHOD_HINT_PERFORMANCE, UUID.randomUUID().toString(), data);
        }
    }

    private long computeStepMetric(Long metric, List<Long> totalMetrics, List<Long> languageMetrics) {
        if (null != metric) {
            totalMetrics.add(metric);
            languageMetrics.add(metric);
            return metric;
        }
        return 0L;
    }

    private void setMetric(List<Long> metrics, String key, Map<String, String> data) {
        if (CollectionUtils.isNotEmpty(metrics)) {
            BaseMetric checkPrevSibling = this.getBaseMetric(metrics);
            data.put(key, JSON.toJSONString((Object)checkPrevSibling));
        }
    }

    private BaseMetric getBaseMetric(List<Long> list) {
        list.sort(Comparator.comparing(Long::intValue));
        long sum = list.stream().mapToLong(Long::longValue).sum();
        long size = list.size();
        return ((BaseMetric.BaseMetricBuilder)((BaseMetric.BaseMetricBuilder)((BaseMetric.BaseMetricBuilder)((BaseMetric.BaseMetricBuilder)BaseMetric.builder().size(size)).sum(sum)).avg(size == 0L ? 0.0 : (double)sum / (double)size)).p90(size == 0L ? 0L : list.get((int)Math.floor((double)size * 0.9)))).build();
    }

    private void statTextChangeItem(TextChangeSummaryBO report, List<TextChangeStat> statList) {
        TextChangeDetailBO item = new TextChangeDetailBO();
        for (TextChangeStat stat : statList) {
            boolean statLine;
            if (TextChangeTypeEnum.TYPING.getType().equals(stat.getChangeType())) {
                item.setEditorTypingCount(item.getEditorTypingCount() + 1L);
            }
            if (!stat.isValid()) continue;
            if (stat.isNonLingmaPasted()) {
                item.setNonLingmaPastedNewLineCount(item.getNonLingmaPastedNewLineCount() + stat.getValidNewLineCount());
                item.setNonLingmaPastedCharLength(item.getNonLingmaPastedCharLength() + stat.getChangeCharChangeLength());
                continue;
            }
            boolean bl = statLine = stat.getStartLineNumber() == null || !item.getLineNumber().equals(stat.getStartLineNumber()) || item.getCurValidLineCount() <= 0L;
            if (stat.getValidNewLineCount() == 1L) {
                if (statLine) {
                    if (stat.isAccepted()) {
                        item.setAcceptNewLineCount(item.getAcceptNewLineCount() + stat.getValidNewLineCount());
                    }
                    item.setTotalNewLineCount(item.getTotalNewLineCount() + stat.getValidNewLineCount());
                } else if (!item.getAcceptCurrentLine().booleanValue() && stat.isAccepted()) {
                    item.setAcceptCurrentLine(true);
                    item.setAcceptNewLineCount(item.getAcceptNewLineCount() + stat.getValidNewLineCount());
                }
            } else if (stat.getValidNewLineCount() > 1L) {
                if (statLine) {
                    if (stat.isAccepted()) {
                        item.setAcceptNewLineCount(item.getAcceptNewLineCount() + stat.getValidNewLineCount());
                    }
                    item.setTotalNewLineCount(item.getTotalNewLineCount() + stat.getValidNewLineCount());
                } else {
                    if (stat.isAccepted()) {
                        if (!item.getAcceptCurrentLine().booleanValue()) {
                            item.setAcceptNewLineCount(item.getAcceptNewLineCount() + stat.getValidNewLineCount());
                        } else {
                            item.setAcceptNewLineCount(item.getAcceptNewLineCount() + stat.getValidNewLineCount() - 1L);
                        }
                    }
                    item.setTotalNewLineCount(item.getTotalNewLineCount() + stat.getValidNewLineCount() - 1L);
                }
            }
            if (stat.isAccepted()) {
                item.setAcceptCharLength(item.getAcceptCharLength() + stat.getChangeCharChangeLength());
            }
            item.setTotalCharLength(item.getTotalCharLength() + stat.getChangeCharChangeLength());
            if (StringUtils.isNotBlank((CharSequence)stat.getLanguage())) {
                item.setLanguage(stat.getLanguage());
            }
            if (StringUtils.isNotBlank((CharSequence)stat.getSource())) {
                item.setSource(stat.getSource());
            }
            if (StringUtils.isNotBlank((CharSequence)stat.getSceneType())) {
                item.setSceneType(stat.getSceneType());
            }
            if (stat.getStartLineNumber() == null || stat.getChangeNewLineCount() > 1L) {
                item.setLineNumber(-1);
                item.setAcceptCurrentLine(false);
                item.setCurValidLineCount(0L);
            } else {
                if (!item.getLineNumber().equals(stat.getStartLineNumber())) {
                    item.setAcceptCurrentLine(false);
                    item.setCurValidLineCount(0L);
                }
                if (stat.isAccepted()) {
                    item.setAcceptCurrentLine(true);
                }
                item.setLineNumber(stat.getStartLineNumber());
                item.setCurValidLineCount(item.getCurValidLineCount() + stat.getValidNewLineCount());
            }
            if (item.getStartTimestamp() == 0L || item.getEndTimestamp() == 0L) {
                item.setStartTimestamp(stat.getTimestamp());
                item.setEndTimestamp(stat.getTimestamp());
            } else {
                item.setStartTimestamp(Math.min(item.getStartTimestamp(), stat.getTimestamp()));
                item.setEndTimestamp(Math.max(item.getEndTimestamp(), stat.getTimestamp()));
            }
            this.constructSourceDetails(stat, item);
        }
        if (item.getAcceptNewLineCount() > item.getTotalNewLineCount()) {
            item.setTotalNewLineCount(item.getAcceptNewLineCount());
        }
        HashMap<String, String> statData = new HashMap<String, String>();
        item.fillReportData(statData);
        report.update(item, statData);
    }

    @Override
    public void updateTimestamp(String type, long timestamp) {
        if (TimestampEnum.ACCEPT_TIMESTAMP_TYPE.getType().equals(type)) {
            this.lastAcceptTime.getAndSet(timestamp);
        }
    }

    @Override
    public long getTimestamp(String type) {
        if (TimestampEnum.ACCEPT_TIMESTAMP_TYPE.getType().equals(type)) {
            return this.lastAcceptTime.get();
        }
        return 0L;
    }

    @Override
    public void telemetryGenerateCommitMsg(Project project, TrackEventTypeEnum eventType, String requestId) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("request_id", requestId);
        data.put("agent_id", "commit_message");
        this.telemetry(project, eventType, requestId, data);
    }

    private void buildMeasurements(Editor editor, Map<String, String> data, CosyEditorInlayItem item) {
        data.put("measurementLastCommand", this.lastCommand.get());
        data.put("measurementCurrentCommand", this.currentCommand.get());
        data.put("measurementLatestDisposeType", this.latestDisposeType.get());
        data.put("measurementLatestDisposeCommand", this.latestDisposeCommandName.get());
        if (this.lastAccepted.get() != null) {
            data.put("measurementLastAccepted", String.valueOf(this.lastAccepted.get()));
        }
        if (this.lastAcceptTimeMs.get() != null && this.lastAcceptTimeMs.get() > 0L) {
            data.put("measurementLastAcceptTimeMs", String.valueOf(System.currentTimeMillis() - this.lastAcceptTimeMs.get()));
        }
        if (this.lastDisposeTimeMs.get() != null && this.lastDisposeTimeMs.get() > 0L) {
            data.put("measurementLastDisposeTimeMs", String.valueOf(System.currentTimeMillis() - this.lastDisposeTimeMs.get()));
        }
        if (editor != null) {
            ApplicationManager.getApplication().runReadAction(() -> {
                PsiElement element = PsiUtils.getCaratElement(editor);
                if (element != null) {
                    data.put("caretElement", element.getClass().getName());
                    if (element.getParent() != null) {
                        data.put("caretParentElement", element.getParent().getClass().getName());
                    }
                    if (element.getPrevSibling() != null) {
                        data.put("caretPrevSiblingElement", element.getPrevSibling().getClass().getName());
                    }
                    if (element.getNextSibling() != null) {
                        data.put("caretNextSiblingElement", element.getNextSibling().getClass().getName());
                    }
                }
            });
        }
        if (item == null) {
            return;
        }
        data.put("measurementFirstTimeSinceDisplayedMillis", String.valueOf(System.currentTimeMillis() - item.getFirstDisplayTimeMs()));
        data.put("measurementTimeSinceDisplayedMillis", String.valueOf(System.currentTimeMillis() - item.getDisplayTimeMs()));
    }

    @Override
    public void telemetryOpenBrowser(Project project, TrackEventTypeEnum eventType, String eventData) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("id", eventData);
        this.telemetry(project, eventType, UUID.randomUUID().toString(), data);
    }

    @Override
    public void telemetryChatPreviewAction(Project project, String requestId, String chatTask, String language, String action) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("chatTask", chatTask);
        data.put("request_id", requestId);
        data.put("language", language);
        data.put("action", action);
        this.telemetry(project, TrackEventTypeEnum.CHAT_PREVIEW_ACTION, requestId, data);
    }

    @Override
    public void telemetryChatPreviewResult(Project project, String requestId, String chatTask, String language, String result) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("chatTask", chatTask);
        data.put("request_id", requestId);
        data.put("language", language);
        data.put("result", result);
        this.telemetry(project, TrackEventTypeEnum.CHAT_PREVIEW_RESULT, requestId, data);
    }

    @Override
    public void telemetryChatDelete(Project project, String requestId, String sessionId, String chatTask, String sessionType) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("chatTask", chatTask);
        data.put("request_id", requestId);
        data.put("sessionId", sessionId);
        data.put("session_type", sessionType);
        this.telemetry(project, TrackEventTypeEnum.CHAT_DELETE, requestId, data);
    }

    @Override
    public void telemetryChatExport(Project project, String requestId, String sessionId, String chatTask, String exportType, String sessionType) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("chatTask", chatTask);
        data.put("request_id", requestId);
        data.put("export_type", exportType);
        data.put("sessionId", sessionId);
        data.put("session_type", sessionType);
        this.telemetry(project, TrackEventTypeEnum.CHAT_EXPORT, requestId, data);
    }

    @Override
    public void telemetryThrowable(Project project, String requestId, String stacktrace) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("stacktrace", stacktrace);
        this.telemetry(project, TrackEventTypeEnum.IDE_ERROR, requestId, data);
    }

    @Override
    public void telemetryChatModeSwitch(Project project, String requestId, String sessionId, String fromMode, String toMode, String sessionType) {
        Map<String, String> data = this.constructCommonSwitchData(requestId, sessionId, fromMode, toMode, sessionType);
        this.telemetry(project, TrackEventTypeEnum.CHAT_MODE_SWITCH, requestId, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void telemetryMethodHintPerformance(Project project, MethodHintPerformanceStat stat) {
        try {
            Key<List<MethodHintPerformanceStat>> key = CosyCacheKeys.KEY_METHOD_HINT_PERF_STAT;
            synchronized (key) {
                List changeStats = (List)CosyCacheKeys.KEY_METHOD_HINT_PERF_STAT.get((UserDataHolder)project, new ArrayList());
                if (changeStats.size() < 5000) {
                    changeStats.add(stat);
                    CosyCacheKeys.KEY_METHOD_HINT_PERF_STAT.set((UserDataHolder)project, (Object)changeStats);
                }
            }
        }
        catch (Exception e) {
            logger.warn("telemetryMethodHintPerformance error", (Throwable)e);
        }
    }

    private void constructSourceDetails(TextChangeStat stat, TextChangeDetailBO bo) {
        if (stat.isAccepted()) {
            TextChangeSourceDetail sourceDetail = bo.getSourceDetail();
            if ("completion".equals(stat.getSource())) {
                if (null == sourceDetail.getCompletion()) {
                    sourceDetail.setCompletion((BaseTextChangeSourceMetric)((BaseTextChangeSourceMetric.BaseTextChangeSourceMetricBuilder)((BaseTextChangeSourceMetric.BaseTextChangeSourceMetricBuilder)BaseTextChangeSourceMetric.builder().acceptCharLength(0L)).acceptNewLineCount(0L)).build());
                }
                BaseTextChangeSourceMetric completion = sourceDetail.getCompletion();
                completion.setAcceptCharLength(completion.getAcceptCharLength() + stat.getChangeCharChangeLength());
                completion.setAcceptNewLineCount(completion.getAcceptNewLineCount() + stat.getValidNewLineCount());
            } else if ("chat".equals(stat.getSource())) {
                if (null == sourceDetail.getChat()) {
                    sourceDetail.setChat((TextChangeSourceChat)((TextChangeSourceChat.TextChangeSourceChatBuilder)((TextChangeSourceChat.TextChangeSourceChatBuilder)((TextChangeSourceChat.TextChangeSourceChatBuilder)TextChangeSourceChat.builder().acceptCharLength(0L)).acceptNewLineCount(0L)).details(new ArrayList<TextChangeSourceChatDetail>())).build());
                }
                TextChangeSourceChat chat = sourceDetail.getChat();
                chat.setAcceptCharLength(chat.getAcceptCharLength() + stat.getChangeCharChangeLength());
                chat.setAcceptNewLineCount(chat.getAcceptNewLineCount() + stat.getValidNewLineCount());
                if (null != stat.getChatTask()) {
                    TextChangeSourceChatDetail chatDetail = this.getSourceChatDetail(stat, chat);
                    chatDetail.setAcceptCharLength(chatDetail.getAcceptCharLength() + stat.getChangeCharChangeLength());
                    chatDetail.setAcceptNewLineCount(chatDetail.getAcceptNewLineCount() + stat.getValidNewLineCount());
                }
            } else if ("developer".equals(stat.getSource())) {
                if (null == sourceDetail.getDeveloper()) {
                    sourceDetail.setDeveloper((BaseTextChangeSourceMetric)((BaseTextChangeSourceMetric.BaseTextChangeSourceMetricBuilder)((BaseTextChangeSourceMetric.BaseTextChangeSourceMetricBuilder)BaseTextChangeSourceMetric.builder().acceptCharLength(0L)).acceptNewLineCount(0L)).build());
                }
                BaseTextChangeSourceMetric developer = sourceDetail.getDeveloper();
                developer.setAcceptCharLength(developer.getAcceptCharLength() + stat.getChangeCharChangeLength());
                developer.setAcceptNewLineCount(developer.getAcceptNewLineCount() + stat.getValidNewLineCount());
            } else if ("assistant".equals(stat.getSource())) {
                if (null == sourceDetail.getAssistant()) {
                    sourceDetail.setAssistant((AssistantTextChangeSourceMetric)((AssistantTextChangeSourceMetric.AssistantTextChangeSourceMetricBuilder)((AssistantTextChangeSourceMetric.AssistantTextChangeSourceMetricBuilder)((AssistantTextChangeSourceMetric.AssistantTextChangeSourceMetricBuilder)AssistantTextChangeSourceMetric.builder().acceptCharLength(0L)).acceptNewLineCount(0L)).details(new HashMap<String, BaseTextChangeSourceMetric>())).build());
                }
                AssistantTextChangeSourceMetric assistant = sourceDetail.getAssistant();
                assistant.setAcceptCharLength(assistant.getAcceptCharLength() + stat.getChangeCharChangeLength());
                assistant.setAcceptNewLineCount(assistant.getAcceptNewLineCount() + stat.getValidNewLineCount());
                BaseTextChangeSourceMetric sourceMetric = assistant.getDetails().computeIfAbsent(stat.getChatMode(), key -> new BaseTextChangeSourceMetric(0L, 0L));
                sourceMetric.setAcceptCharLength(sourceMetric.getAcceptCharLength() + stat.getChangeCharChangeLength());
                sourceMetric.setAcceptNewLineCount(sourceMetric.getAcceptNewLineCount() + stat.getValidNewLineCount());
            } else if ("inline_edit".equals(stat.getSource()) || "chat_ask_apply".equals(stat.getSource())) {
                if (null == sourceDetail.getInlineEdit()) {
                    sourceDetail.setInlineEdit(((AssistantTextChangeSourceMetric.AssistantTextChangeSourceMetricBuilder)((AssistantTextChangeSourceMetric.AssistantTextChangeSourceMetricBuilder)((AssistantTextChangeSourceMetric.AssistantTextChangeSourceMetricBuilder)AssistantTextChangeSourceMetric.builder().acceptCharLength(0L)).acceptNewLineCount(0L)).details(new HashMap<String, BaseTextChangeSourceMetric>())).build());
                }
                BaseTextChangeSourceMetric inlineEdit = sourceDetail.getInlineEdit();
                inlineEdit.setAcceptCharLength(inlineEdit.getAcceptCharLength() + stat.getChangeCharChangeLength());
                inlineEdit.setAcceptNewLineCount(inlineEdit.getAcceptNewLineCount() + stat.getValidNewLineCount());
            } else if ("nes".equals(stat.getSource())) {
                if (null == sourceDetail.getNes()) {
                    sourceDetail.setNes((BaseTextChangeSourceMetric)((BaseTextChangeSourceMetric.BaseTextChangeSourceMetricBuilder)((BaseTextChangeSourceMetric.BaseTextChangeSourceMetricBuilder)BaseTextChangeSourceMetric.builder().acceptCharLength(0L)).acceptNewLineCount(0L)).build());
                }
                BaseTextChangeSourceMetric nes = sourceDetail.getNes();
                nes.setAcceptCharLength(nes.getAcceptCharLength() + stat.getChangeCharChangeLength());
                nes.setAcceptNewLineCount(nes.getAcceptNewLineCount() + stat.getValidNewLineCount());
            }
        }
    }

    @NotNull
    private TextChangeSourceChatDetail getSourceChatDetail(TextChangeStat stat, TextChangeSourceChat chat) {
        BaseTextChangeSourceMetric sourceChatDetail = null;
        for (TextChangeSourceChatDetail detail : chat.getDetails()) {
            if (!stat.getChatTask().equals(detail.getChatTask())) continue;
            sourceChatDetail = detail;
            break;
        }
        if (null == sourceChatDetail) {
            sourceChatDetail = ((TextChangeSourceChatDetail.TextChangeSourceChatDetailBuilder)((TextChangeSourceChatDetail.TextChangeSourceChatDetailBuilder)((TextChangeSourceChatDetail.TextChangeSourceChatDetailBuilder)TextChangeSourceChatDetail.builder().acceptCharLength(0L)).acceptNewLineCount(0L)).chatTask(stat.getChatTask())).build();
            chat.getDetails().add((TextChangeSourceChatDetail)sourceChatDetail);
        }
        TextChangeSourceChatDetail textChangeSourceChatDetail = sourceChatDetail;
        if (textChangeSourceChatDetail == null) {
            TelemetryServiceImpl.$$$reportNull$$$0(1);
        }
        return textChangeSourceChatDetail;
    }

    @Override
    public void triggerInlineEdit(InlineTriggerModeEnum triggerMode, Editor editor, InlineEditRequest request, InlineEditRequest prevRequest) {
        String language;
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("triggerMode", triggerMode.getName());
        TypingStat stat = this.getTypeStat();
        data.put("avgTypingSpeed", String.valueOf(stat.getAvgTypingSpeed()));
        data.put("lastTypingSpeed", String.valueOf(stat.getLastTypingSpeed()));
        data.put("typingLength", String.valueOf(stat.getTypingLength()));
        data.put("triggerDelay", String.valueOf(request.getTriggerDelayTime()));
        data.put("isComment", String.valueOf(request.isComment()));
        if (prevRequest != null) {
            data.put("prevRequestId", prevRequest.getRequestId());
        }
        if (request.getParams().getTextDocument() != null && StringUtils.isNotBlank((CharSequence)(language = LanguageUtil.getLanguageByFilePath(request.getParams().getTextDocument().getUri())))) {
            data.put("language", language.toLowerCase(Locale.ROOT));
        }
        this.buildMeasurements(editor, data, null);
        this.telemetry(editor.getProject(), TrackEventTypeEnum.INLINE_EDIT_TRIGGER, request.getRequestId(), data);
    }

    @Override
    public void acceptInlineEdit(Editor editor, InlineEditRequest request) {
        HashMap<String, String> data = new HashMap<String, String>();
        this.appendInlineEditResultInfo(data, request);
        this.telemetry(editor.getProject(), TrackEventTypeEnum.INLINE_EDIT_ACCEPT, request.getRequestId(), data);
    }

    @Override
    public void disposeInlineEdit(Editor editor, InlineEditRequest request, InlayDisposeEventEnum disposeType, String commandName) {
        HashMap<String, String> data = new HashMap<String, String>();
        this.appendInlineEditResultInfo(data, request);
        if (commandName != null) {
            data.put("commandName", commandName);
        }
        this.telemetry(editor.getProject(), TrackEventTypeEnum.INLINE_EDIT_DISPOSE, request.getRequestId(), data);
    }

    private void appendInlineEditResultInfo(Map<String, String> data, InlineEditRequest request) {
        String language;
        RewriteCodeAction item = (RewriteCodeAction)request.getActionResult(InlineActionType.NEXT_EDIT.getActionType());
        if (item == null || item.getEditRange() == null) {
            return;
        }
        data.put("actionIndex", String.valueOf(request.getDiffChangeModels().size() - 1));
        data.put("totalChars", String.valueOf(Optional.ofNullable(item.getContent()).map(String::length).orElse(0)));
        data.put("totalLineCount", String.valueOf(Optional.ofNullable(item.getContent()).map(s -> s.split("\n").length).orElse(0)));
        if (request.getRender().getDiffChangeModel() != null) {
            long diffInsertLines = 0L;
            long diffModifyInsertLines = 0L;
            long diffModifyDeleteLines = 0L;
            long diffDeleteLines = 0L;
            DiffChangeModel diffChangeModel = request.getRender().getDiffChangeModel();
            for (LineFragment change : diffChangeModel.getDiffResult()) {
                boolean insertedRangeIsEmpty;
                boolean deletedRangeIsEmpty = change.getEndLine1() - change.getStartLine1() == 0;
                boolean bl = insertedRangeIsEmpty = change.getEndLine2() - change.getStartLine2() == 0;
                if (!insertedRangeIsEmpty && !deletedRangeIsEmpty) {
                    diffModifyInsertLines += (long)(change.getEndLine2() - change.getStartLine2());
                    diffModifyDeleteLines += (long)(change.getEndLine1() - change.getStartLine1());
                    continue;
                }
                if (!insertedRangeIsEmpty) {
                    diffInsertLines += (long)(change.getEndLine2() - change.getStartLine2());
                    continue;
                }
                diffDeleteLines += (long)(change.getEndLine1() - change.getStartLine1());
            }
            data.put("diffInsertLines", String.valueOf(diffInsertLines));
            data.put("diffModifyInsertLines", String.valueOf(diffModifyInsertLines));
            data.put("diffModifyDeleteLines", String.valueOf(diffModifyDeleteLines));
            data.put("diffDeleteLines", String.valueOf(diffDeleteLines));
        }
        if (request.getParams().getTextDocument() != null && StringUtils.isNotBlank((CharSequence)(language = LanguageUtil.getLanguageByFilePath(request.getParams().getTextDocument().getUri())))) {
            data.put("language", language.toLowerCase(Locale.ROOT));
        }
        if (StringUtils.isNotBlank((CharSequence)request.getCacheRequestId())) {
            data.put("cacheId", String.valueOf(request.getCacheRequestId()));
        }
        if (request.getRender().getRenderEndTime() > 0L) {
            data.put("measurementTimeSinceDisplayedMillis", String.valueOf(System.currentTimeMillis() - request.getRender().getRenderEndTime()));
            data.put("rendered", "true");
        } else {
            data.put("rendered", "false");
        }
    }

    @Override
    public void telemetryChatAskApply(Project project, String requestId, String sessionId, String filePath) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("request_id", requestId);
        data.put("sessionId", sessionId);
        data.put("file_path", filePath);
        this.telemetry(project, TrackEventTypeEnum.CHAT_ASK_APPLY_OPERATION, requestId, data);
    }

    @Override
    public void telemetryChatModelClassSwitch(Project project, String requestId, String sessionId, String from, String to, String sessionType, String switchType) {
        Map<String, String> data = this.constructCommonSwitchData(requestId, sessionId, from, to, sessionType);
        data.put("switch_type", switchType);
        this.telemetry(project, TrackEventTypeEnum.CHAT_MODEL_CLASS_SWITCH, requestId, data);
    }

    private Map<String, String> constructCommonSwitchData(String requestId, String sessionId, String from, String to, String sessionType) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("request_id", requestId);
        data.put("sessionId", sessionId);
        data.put("session_type", sessionType);
        data.put("from", from);
        data.put("to", to);
        return data;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/alibabacloud/intellij/cosy/service/impl/TelemetryServiceImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/alibabacloud/intellij/cosy/service/impl/TelemetryServiceImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceChatDetail";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "telemetryCommand";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

