/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.service.impl;

import com.alibabacloud.intellij.cosy.service.MergeFileService;
import com.alibabacloud.intellij.cosy.service.handler.JavaMergeFileHandler;
import com.alibabacloud.intellij.cosy.service.handler.MergeFileHandler;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class MergeFileServiceImpl
implements MergeFileService {
    private static Logger log = Logger.getInstance(MergeFileServiceImpl.class);
    Map<String, MergeFileHandler> languageHandlerMap = new HashMap<String, MergeFileHandler>();

    protected MergeFileServiceImpl() {
        this.languageHandlerMap.put("java", new JavaMergeFileHandler());
    }

    @Override
    public String mergeFileContent(Project project, VirtualFile targetFile, String content) {
        if (project == null || targetFile == null || content == null) {
            log.error("project == null || targetFile == null || content == null when merging file content");
            return content;
        }
        PsiFile targetPsiFile = PsiManager.getInstance((Project)project).findFile(targetFile);
        if ("java".equals(targetFile.getExtension()) && targetPsiFile instanceof PsiJavaFile) {
            PsiJavaFile oldPsiJavaFile = (PsiJavaFile)targetPsiFile;
            PsiFile newPsiFile = PsiFileFactory.getInstance((Project)project).createFileFromText("temp_" + System.currentTimeMillis() + ".java", (FileType)JavaFileType.INSTANCE, (CharSequence)content);
            if (newPsiFile instanceof PsiJavaFile) {
                PsiJavaFile newPsiJavaFile = (PsiJavaFile)newPsiFile;
                try {
                    MergeFileHandler mergeFileHandler = this.languageHandlerMap.get(targetFile.getExtension());
                    String result = mergeFileHandler.mergeWithWriteCommand(project, (PsiFile)((PsiJavaFile)oldPsiJavaFile.copy()), (PsiFile)newPsiJavaFile);
                    return Objects.requireNonNullElse(result, content);
                }
                catch (Exception e) {
                    log.warn("Cannot merge psi java file when merging file content", (Throwable)e);
                    return content;
                }
            }
            log.warn("Cannot create psi java file from content when merging file content");
            return content;
        }
        log.info("Not java file, directly return content when merging file content");
        return content;
    }
}

