/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.service;

import com.alibabacloud.intellij.cosy.common.CosySetting;
import com.alibabacloud.intellij.cosy.core.Cosy;
import com.alibabacloud.intellij.cosy.core.lsp.LanguageWebSocketService;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.ChatModelItem;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.ModelSource;
import com.alibabacloud.intellij.cosy.ui.config.CosyPersistentSetting;
import com.alibabacloud.intellij.cosy.util.ModelUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class ModelService {
    private static final Logger LOGGER = Logger.getInstance(ModelService.class);
    private static final int CACHE_MODEL_LIST_TIME = 300000;
    private static final int REPEAT_FETCH_MODEL_LIST_TIME = 3000;
    private static final String PREFIX_ORG_MODEL = "(org)";
    private Map<String, LinkedHashMap<String, ChatModelItem>> modelMap = new ConcurrentHashMap<String, LinkedHashMap<String, ChatModelItem>>();
    private AtomicLong fetchModelTimestamp = new AtomicLong(0L);
    private long lastFetchModelTimestamp = 0L;
    private ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private static ModelService instance = new ModelService();

    private ModelService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedHashMap<String, ChatModelItem> getModelMap(Project project, String sessionType) {
        if (System.currentTimeMillis() - this.fetchModelTimestamp.get() > 300000L || !this.modelMap.containsKey(sessionType)) {
            this.fetchModel(project);
        }
        this.readWriteLock.readLock().lock();
        try {
            LinkedHashMap<String, ChatModelItem> linkedHashMap = this.modelMap.get(sessionType);
            return linkedHashMap;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ChatModelItem> getModelList(Project project, String sessionType) {
        if (System.currentTimeMillis() - this.fetchModelTimestamp.get() > 300000L || !this.modelMap.containsKey(sessionType)) {
            this.fetchModel(project);
        }
        this.readWriteLock.readLock().lock();
        try {
            if (this.modelMap.containsKey(sessionType)) {
                ArrayList<ChatModelItem> result = new ArrayList<ChatModelItem>();
                for (Map.Entry<String, ChatModelItem> entry : this.modelMap.get(sessionType).entrySet()) {
                    result.add(entry.getValue());
                }
                ArrayList<ChatModelItem> arrayList = result;
                return arrayList;
            }
            List<ChatModelItem> list = null;
            return list;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<ChatModelItem>> fetchModel(Project project) {
        this.readWriteLock.writeLock().lock();
        try {
            LOGGER.info("start to fetch model for project " + project.getName());
            if (!this.modelMap.isEmpty() && System.currentTimeMillis() - this.lastFetchModelTimestamp < 3000L) {
                LOGGER.warn("fetch model repeat, ignore");
                Map<String, List<ChatModelItem>> map = this.convertModelList();
                return map;
            }
            this.lastFetchModelTimestamp = System.currentTimeMillis();
            if (!Cosy.INSTANCE.checkCosy(project)) {
                Map<String, List<ChatModelItem>> map = null;
                return map;
            }
            LanguageWebSocketService service = Cosy.INSTANCE.getLanguageService(project);
            if (service == null) {
                Map<String, List<ChatModelItem>> map = null;
                return map;
            }
            Map<String, List<ChatModelItem>> modelList = service.queryModels(1500L);
            boolean updated = this.updateModelMap(modelList);
            Map<String, List<ChatModelItem>> map = updated ? modelList : null;
            return map;
        }
        catch (Exception e) {
            LOGGER.warn("fetch model error", (Throwable)e);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateModelMap(Map<String, List<ChatModelItem>> modelList) {
        this.readWriteLock.writeLock().lock();
        try {
            if (MapUtils.isEmpty(modelList)) {
                boolean bl = false;
                return bl;
            }
            this.modelMap.clear();
            for (Map.Entry<String, List<ChatModelItem>> entry : modelList.entrySet()) {
                LOGGER.info("query model:" + entry.getKey() + " " + entry.getValue().stream().map(ChatModelItem::getKey).collect(Collectors.toList()));
                LinkedHashMap<String, ChatModelItem> itemMap = new LinkedHashMap<String, ChatModelItem>();
                for (ChatModelItem modelItem : entry.getValue()) {
                    if (ModelSource.ORGANIZATION.getSource().equals(modelItem.getSource()) && !modelItem.getDisplayName().startsWith(PREFIX_ORG_MODEL)) {
                        modelItem.setDisplayName(PREFIX_ORG_MODEL + modelItem.getDisplayName());
                    }
                    itemMap.put(modelItem.getKey(), modelItem);
                }
                this.modelMap.put(entry.getKey(), itemMap);
            }
            this.fetchModelTimestamp.getAndSet(System.currentTimeMillis());
        }
        catch (Exception e) {
            LOGGER.warn("update model map error", (Throwable)e);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
        return true;
    }

    private Map<String, List<ChatModelItem>> convertModelList() {
        HashMap<String, List<ChatModelItem>> modelList = new HashMap<String, List<ChatModelItem>>();
        for (Map.Entry<String, LinkedHashMap<String, ChatModelItem>> entry : this.modelMap.entrySet()) {
            ArrayList<ChatModelItem> chatModelItems = new ArrayList<ChatModelItem>();
            for (Map.Entry<String, ChatModelItem> itemEntry : entry.getValue().entrySet()) {
                chatModelItems.add(itemEntry.getValue());
            }
            modelList.put(entry.getKey(), chatModelItems);
        }
        return modelList;
    }

    public void clearCache() {
        this.readWriteLock.writeLock().lock();
        try {
            this.modelMap.clear();
            this.fetchModelTimestamp.getAndSet(0L);
            this.lastFetchModelTimestamp = 0L;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshModel(Map<String, List<ChatModelItem>> modelList) {
        this.readWriteLock.writeLock().lock();
        try {
            this.modelMap.clear();
            for (Map.Entry<String, List<ChatModelItem>> entry : modelList.entrySet()) {
                LOGGER.info("refresh model:" + entry.getKey() + " " + entry.getValue().stream().map(ChatModelItem::getKey).collect(Collectors.toList()));
                LinkedHashMap<String, ChatModelItem> itemMap = new LinkedHashMap<String, ChatModelItem>();
                for (ChatModelItem modelItem : entry.getValue()) {
                    itemMap.put(modelItem.getKey(), modelItem);
                }
                this.modelMap.put(entry.getKey(), itemMap);
            }
            this.fetchModelTimestamp.getAndSet(System.currentTimeMillis());
        }
        catch (Exception e) {
            LOGGER.warn("refresh model error", (Throwable)e);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public ChatModelItem getSelectionModelItem(Project project, String sessionType) {
        LinkedHashMap<String, ChatModelItem> modelMap = this.getModelMap(project, sessionType = ModelUtil.convertSessionType(project, sessionType));
        LOGGER.info("get model list: " + (modelMap != null ? modelMap.keySet() : "null") + " for sessionType:" + sessionType);
        if (MapUtils.isEmpty(modelMap)) {
            modelMap = new LinkedHashMap();
            modelMap.put("default", (ChatModelItem)((ChatModelItem.ChatModelItemBuilder)((ChatModelItem.ChatModelItemBuilder)((ChatModelItem.ChatModelItemBuilder)((ChatModelItem.ChatModelItemBuilder)((ChatModelItem.ChatModelItemBuilder)((ChatModelItem.ChatModelItemBuilder)((ChatModelItem.ChatModelItemBuilder)ChatModelItem.builder().key("auto")).displayName("Auto")).format("openai")).isVl(true)).isReasoning(false)).source("system")).baseUrl("")).build());
        }
        ChatModelItem selectModel = null;
        CosySetting cosySetting = CosyPersistentSetting.getInstance().getState();
        if (cosySetting != null && cosySetting.getChatModelSelected() != null) {
            String configModelKey = cosySetting.getChatModelSelected().get(ModelService.buildModelKey(project, sessionType));
            LOGGER.info("get config model key for " + sessionType + " is " + configModelKey);
            if (StringUtils.isNotBlank((CharSequence)configModelKey) && modelMap.containsKey(configModelKey)) {
                selectModel = modelMap.get(configModelKey);
            }
        }
        if (selectModel == null && !modelMap.isEmpty()) {
            LOGGER.info("get first model for sessionType:" + sessionType);
            Map.Entry<String, ChatModelItem> firstEntry = modelMap.entrySet().iterator().next();
            selectModel = firstEntry.getValue();
        }
        return selectModel;
    }

    public static String buildModelKey(Project project, String sessionType) {
        return (null == project ? "null" : project.getPresentableUrl()) + "-" + sessionType;
    }

    @Generated
    public static ModelService getInstance() {
        return instance;
    }
}

