/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.service;

import com.alibabacloud.intellij.cosy.core.Cosy;
import com.alibabacloud.intellij.cosy.core.lsp.LanguageWebSocketService;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.WillChangeTextDocumentParams;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

@Service(value={Service.Level.PROJECT})
public final class FileChangeService
implements Disposable {
    private static final Logger LOGGER = Logger.getInstance(FileChangeService.class);
    BlockingQueue<WillChangeTextDocumentParams> fileChangeQueue = new LinkedBlockingQueue<WillChangeTextDocumentParams>();
    Thread thread;
    Project project;

    public FileChangeService(Project project) {
        this.project = project;
        this.thread = new Thread(() -> {
            try {
                LOGGER.info("File change service start: " + project.getName());
                while (!Thread.currentThread().isInterrupted()) {
                    LanguageWebSocketService service;
                    WillChangeTextDocumentParams params = this.fileChangeQueue.poll(60L, TimeUnit.SECONDS);
                    if (params == null || !Cosy.INSTANCE.checkCosy(project, false) || (service = Cosy.INSTANCE.getLanguageService(project)) == null || service.getServer() == null) continue;
                    try {
                        LOGGER.debug(project.getName() + " File change service consume:" + params.getEvents());
                        service.getServer().getTextDocumentService().willChange(params);
                    }
                    catch (Exception e) {
                        LOGGER.warn(project.getName() + " File change service consume error", (Throwable)e);
                    }
                }
            }
            catch (InterruptedException e) {
                LOGGER.warn(project.getName() + " File change service thread interrupted");
            }
            catch (Exception e) {
                LOGGER.warn(project.getName() + " File change service thread error", (Throwable)e);
            }
        });
        this.thread.start();
    }

    public void addFileChangeEvent(WillChangeTextDocumentParams event) {
        if (!Cosy.INSTANCE.checkCosy(this.project, false)) {
            return;
        }
        if (!this.fileChangeQueue.offer(event)) {
            LOGGER.warn("File change event queue is full, event dropped");
        }
    }

    public void dispose() {
        LOGGER.info("File change service dispose, remaining events:" + this.fileChangeQueue.size() + " project:" + this.project.getName());
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }
}

