/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.search.action;

import com.alibabacloud.intellij.cosy.search.enums.SearchActionTypeEnum;
import com.alibabacloud.intellij.cosy.search.enums.SearchValueTypeEnum;
import com.alibabacloud.intellij.cosy.search.result.SearchContext;
import com.alibabacloud.intellij.cosy.search.result.SearchValue;
import com.alibabacloud.intellij.cosy.search.util.PsiElementParser;
import com.alibabacloud.intellij.cosy.ui.search.Constants;
import com.alibabacloud.intellij.cosy.ui.search.I18NConstant;
import com.alibabacloud.intellij.cosy.ui.search.SearchToolWindowFactory;
import com.alibabacloud.intellij.cosy.ui.search.enums.OperationEnum;
import com.alibabacloud.intellij.cosy.ui.search.topic.AnySearchNotifier;
import com.intellij.codeInsight.javadoc.JavaDocInfoGenerator;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.javadoc.PsiDocTokenImpl;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocToken;
import com.intellij.util.text.CharArrayUtil;
import icons.CommonIcons;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class CodeSearchAction
extends AnAction {
    private static Logger logger = Logger.getInstance(CodeSearchAction.class);
    private static final char ARRAY_FLAG = '[';
    private static final char GENERICS_FLAG = '<';
    private static final String TAB_SPACE = " \t";
    protected static final Pattern HTML_MATCH = Pattern.compile("<[^>]+>", 32);
    protected static final Pattern CRLF_MATCH = Pattern.compile("\\n[\\s]*\\n");
    private static final String JD_STAR = "/**";
    private static final String JD_MIDDLE = "*";
    private static final String COMMENT_PREFIX = "//";
    private static final String TODO = "TODO";
    private static final String ONE_OR_MORE_SPACE = "\\s+";
    private static final String PERIOD = "\\.|\u3002";

    public CodeSearchAction() {
        super(I18NConstant.SEARCH_ACTION_NAME, I18NConstant.SEARCH_ACTION_NAME, CommonIcons.AI);
    }

    private static boolean isValidPsiElement(@NotNull DataContext paramDataContext) {
        Project project;
        if (paramDataContext == null) {
            CodeSearchAction.$$$reportNull$$$0(0);
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(paramDataContext)) == null) {
            return false;
        }
        if (DumbService.getInstance((Project)project).isDumb()) {
            return false;
        }
        PsiElement psiElement = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(paramDataContext);
        if (psiElement == null) {
            return false;
        }
        return psiElement instanceof PsiClass || psiElement instanceof PsiMethod || psiElement instanceof PsiVariable;
    }

    private static boolean isJavaFile(@NotNull DataContext paramDataContext) {
        PsiFile psiFile;
        if (paramDataContext == null) {
            CodeSearchAction.$$$reportNull$$$0(1);
        }
        return (psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(paramDataContext)) != null && psiFile.getFileType() == JavaFileType.INSTANCE;
    }

    private String removeRedundantSuffix(String item) {
        int location = item.indexOf(91);
        if (location != -1) {
            item = item.substring(0, location);
        }
        if ((location = item.indexOf(60)) != -1) {
            item = item.substring(0, location);
        }
        return item;
    }

    public String getJavaDoc(AnActionEvent e) {
        Editor editor = (Editor)e.getData(PlatformDataKeys.EDITOR);
        if (editor == null) {
            return "";
        }
        Caret caret = (Caret)e.getData(PlatformDataKeys.CARET);
        Project project = editor.getProject();
        if (project != null && EditorSettingsExternalizable.getInstance().isSmartHome()) {
            Document document = editor.getDocument();
            CharSequence text = document.getImmutableCharSequence();
            if (caret != null) {
                PsiElement startElement;
                PsiDocumentManager psiDocumentManager;
                PsiFile file;
                int lineStartOffset = document.getLineStartOffset(caret.getLogicalPosition().line);
                int nonWsStartOffset = CharArrayUtil.shiftForward((CharSequence)text, (int)lineStartOffset, (String)TAB_SPACE);
                if ((CharArrayUtil.regionMatches((CharSequence)text, (int)nonWsStartOffset, (CharSequence)JD_STAR) || CharArrayUtil.regionMatches((CharSequence)text, (int)nonWsStartOffset, (CharSequence)JD_MIDDLE)) && (file = (psiDocumentManager = PsiDocumentManager.getInstance((Project)project)).getPsiFile(document)) instanceof PsiJavaFile && (startElement = file.findElementAt(nonWsStartOffset)) instanceof PsiDocToken) {
                    PsiDocComment psiDocComment = (PsiDocComment)((PsiDocTokenImpl)startElement).getTreeParent();
                    JavaDocInfoGenerator javaDocInfoGenerator = new JavaDocInfoGenerator(project, (PsiElement)psiDocComment);
                    StringBuilder stringBuilder = new StringBuilder();
                    javaDocInfoGenerator.generateCommonSection(stringBuilder, psiDocComment);
                    Matcher htmlMatch = HTML_MATCH.matcher(stringBuilder.toString());
                    String contentHasTag = stringBuilder.toString();
                    while (htmlMatch.find()) {
                        contentHasTag = contentHasTag.replace(htmlMatch.group(), "");
                    }
                    Matcher feedMatch = CRLF_MATCH.matcher(contentHasTag);
                    if (feedMatch.find()) {
                        contentHasTag = contentHasTag.substring(0, feedMatch.start());
                    }
                    String content = contentHasTag.replaceAll(ONE_OR_MORE_SPACE, " ");
                    content = content.split(PERIOD, 2)[0];
                    return content;
                }
                if (CharArrayUtil.regionMatches((CharSequence)text, (int)nonWsStartOffset, (CharSequence)COMMENT_PREFIX) && (file = (psiDocumentManager = PsiDocumentManager.getInstance((Project)project)).getPsiFile(document)) instanceof PsiJavaFile && (startElement = file.findElementAt(nonWsStartOffset)) instanceof PsiComment) {
                    PsiComment psiComment = (PsiComment)startElement;
                    String contentHasTag = psiComment.getText();
                    return contentHasTag.replaceFirst(COMMENT_PREFIX, "").replaceAll(TODO, "").strip();
                }
            }
        }
        return "";
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            CodeSearchAction.$$$reportNull$$$0(2);
        }
        try {
            PsiElement psiElement;
            Project project = e.getProject();
            if (project == null) {
                return;
            }
            ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(Constants.PLUGIN_NAME);
            if (toolWindow == null) {
                return;
            }
            boolean isShowing = false;
            if (!toolWindow.isVisible()) {
                SearchToolWindowFactory.showToolWindow(project);
                isShowing = true;
            }
            if ((psiElement = (PsiElement)e.getData(PlatformDataKeys.PSI_ELEMENT)) == null) {
                Editor editor = (Editor)e.getData(PlatformDataKeys.EDITOR);
                if (null == editor) {
                    return;
                }
                SelectionModel selectionModel = editor.getSelectionModel();
                String nlpString = selectionModel.getSelectedText();
                if (StringUtils.isBlank((CharSequence)nlpString)) {
                    String javaDoc = this.getJavaDoc(e);
                    if (StringUtils.isBlank((CharSequence)javaDoc)) {
                        if (!isShowing) {
                            SearchToolWindowFactory.hideToolWindow(project);
                        } else {
                            ((AnySearchNotifier)project.getMessageBus().syncPublisher(AnySearchNotifier.ANY_SEARCH_NOTIFICATION)).anySearch(null, null);
                        }
                        return;
                    }
                    nlpString = javaDoc;
                }
                SearchValue searchValue = new SearchValue("", nlpString, SearchValueTypeEnum.NLP.getType());
                SearchContext context = new SearchContext(OperationEnum.CLEAR_AND_ADD.text, SearchActionTypeEnum.RIGHT_CLICK_TRIGGER.getType());
                ((AnySearchNotifier)project.getMessageBus().syncPublisher(AnySearchNotifier.ANY_SEARCH_NOTIFICATION)).anySearch(context, searchValue);
                return;
            }
            SearchValue searchValue = this.parseElement(e, psiElement);
            SearchContext context = new SearchContext(OperationEnum.CLEAR_AND_ADD.text, SearchActionTypeEnum.RIGHT_CLICK_TRIGGER.getType());
            if (searchValue != null) {
                ((AnySearchNotifier)project.getMessageBus().syncPublisher(AnySearchNotifier.ANY_SEARCH_NOTIFICATION)).anySearch(context, searchValue);
            }
        }
        catch (Exception exception) {
            logger.info("CodeSearchAction error : " + exception.getMessage());
        }
    }

    private SearchValue parseElement(AnActionEvent e, PsiElement psiElement) {
        SearchValue searchValue;
        PsiElementParser psiElementParser = new PsiElementParser();
        String itemClass = psiElementParser.resolveClass(psiElement);
        logger.info("The class of psiElement " + psiElement.toString() + " is " + itemClass + ".");
        if (!CodeSearchAction.isValidPsiElement(e.getDataContext())) {
            return null;
        }
        String text = psiElement.toString().split(":")[1];
        if (psiElement instanceof PsiVariable) {
            text = ((PsiVariable)psiElement).getType().getPresentableText();
        }
        if (psiElement instanceof PsiClass) {
            searchValue = new SearchValue(itemClass, text, SearchValueTypeEnum.CLASS.getType());
        } else if (psiElement instanceof PsiMethod) {
            PsiFile psiFile = (PsiFile)e.getData(PlatformDataKeys.PSI_FILE);
            PsiFile containingFile = psiElement.getContainingFile();
            if (psiFile != null && psiFile.equals(containingFile)) {
                searchValue = new SearchValue("", text, SearchValueTypeEnum.NLP.getType());
            } else if (itemClass != null) {
                if (((PsiMethod)psiElement).isConstructor()) {
                    searchValue = new SearchValue(itemClass, text, SearchValueTypeEnum.METHOD.getType());
                } else {
                    String[] itemClassList = itemClass.split("\\.");
                    searchValue = new SearchValue(itemClass + "." + text, itemClassList[itemClassList.length - 1] + "." + text, SearchValueTypeEnum.METHOD.getType());
                }
            } else {
                searchValue = new SearchValue("", text, SearchValueTypeEnum.METHOD.getType());
            }
        } else if (psiElement instanceof PsiVariable) {
            text = this.removeRedundantSuffix(text);
            itemClass = this.removeRedundantSuffix(itemClass);
            searchValue = new SearchValue(itemClass, text, SearchValueTypeEnum.CLASS.getType());
        } else {
            searchValue = new SearchValue("", text, SearchValueTypeEnum.NLP.getType());
        }
        return searchValue;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramDataContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/alibabacloud/intellij/cosy/search/action/CodeSearchAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidPsiElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isJavaFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

