/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.problem.action;

import com.alibaba.fastjson.JSON;
import com.alibabacloud.intellij.cosy.common.BuildFeature;
import com.alibabacloud.intellij.cosy.common.CosyConfig;
import com.alibabacloud.intellij.cosy.problem.action.BaseCosyCodeProblemsAction;
import com.alibabacloud.intellij.cosy.problem.model.ErrorMessageWithCodeLine;
import com.alibabacloud.intellij.cosy.search.enums.TrackEventTypeEnum;
import com.alibabacloud.intellij.cosy.ui.notifications.NotificationFactory;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.util.ReflectUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.UpdateInBackground;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.treeStructure.Tree;
import java.util.ArrayList;
import javax.swing.tree.TreePath;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class CosyCodeProblemsTreePopupAction
extends DumbAwareAction
implements BaseCosyCodeProblemsAction,
UpdateInBackground {
    private static final Logger log = Logger.getInstance(CosyCodeProblemsTreePopupAction.class);

    public void update(AnActionEvent anActionEvent) {
        Object tree = anActionEvent.getData(PlatformDataKeys.CONTEXT_COMPONENT);
        if (tree == null) {
            anActionEvent.getPresentation().setVisible(false);
            return;
        }
        if (!(tree instanceof Tree)) {
            log.warn("tree is " + tree.getClass());
            anActionEvent.getPresentation().setVisible(false);
            return;
        }
        TreePath selectionPath = ((Tree)tree).getSelectionPath();
        if (null == selectionPath) {
            log.warn("selectionPath is null when update");
            return;
        }
        Object problemNode = selectionPath.getLastPathComponent();
        if (problemNode == null) {
            anActionEvent.getPresentation().setVisible(false);
            return;
        }
        String errorMsg = this.getErrorMessage(problemNode);
        if (StringUtils.isBlank((CharSequence)errorMsg)) {
            anActionEvent.getPresentation().setVisible(false);
            return;
        }
        anActionEvent.getPresentation().setVisible(true);
        anActionEvent.getPresentation().setText(CosyBundle.message("action.TriggerCosyCodeProblemsTreePopupAction.text", new Object[0]));
    }

    public void actionPerformed(@NotNull AnActionEvent anActionEvent) {
        Object tree;
        if (anActionEvent == null) {
            CosyCodeProblemsTreePopupAction.$$$reportNull$$$0(0);
        }
        if ((tree = anActionEvent.getData(PlatformDataKeys.CONTEXT_COMPONENT)) == null) {
            NotificationFactory.showWarnNotification(anActionEvent.getProject(), CosyBundle.message("timeout.tips", new Object[0]));
            return;
        }
        TreePath selectionPath = ((Tree)tree).getSelectionPath();
        if (null == selectionPath) {
            log.warn("selectionPath is null when actionPerformed");
            return;
        }
        Object problemNode = selectionPath.getLastPathComponent();
        if (problemNode == null) {
            NotificationFactory.showWarnNotification(anActionEvent.getProject(), CosyBundle.message("timeout.tips", new Object[0]));
            return;
        }
        String errorMsg = this.getErrorMessage(problemNode);
        ErrorMessageWithCodeLine errorMessageWithCodeLine = this.getCode(anActionEvent, problemNode);
        Project project = anActionEvent.getProject();
        PsiFile psiFile = (PsiFile)anActionEvent.getData(CommonDataKeys.PSI_FILE);
        ArrayList<String> errorMessages = new ArrayList<String>();
        errorMessages.add(errorMsg);
        errorMessageWithCodeLine.setErrorMessage(errorMsg);
        this.solveProblems(project, psiFile, errorMessages, errorMessageWithCodeLine, TrackEventTypeEnum.CODE_PROBLEMS_PANEL);
    }

    private String getErrorMessage(Object problemNode) {
        String errorMsg = "";
        try {
            errorMsg = (String)ReflectUtil.getField(problemNode, "description");
        }
        catch (NoSuchFieldException e) {
            log.warn("getErrorMessage NoSuchFieldException:" + e.getMessage());
        }
        catch (IllegalAccessException e) {
            log.warn("getErrorMessage IllegalAccessException:" + e.getMessage());
        }
        if (StringUtils.isBlank((CharSequence)errorMsg)) {
            try {
                errorMsg = (String)ReflectUtil.getField(problemNode, "text");
            }
            catch (NoSuchFieldException e) {
                log.warn("getErrorMessage NoSuchFieldException:" + e.getMessage());
            }
            catch (IllegalAccessException e) {
                log.warn("getErrorMessage IllegalAccessException:" + e.getMessage());
            }
        }
        return errorMsg;
    }

    private ErrorMessageWithCodeLine getCode(AnActionEvent anActionEvent, Object problemNode) {
        ErrorMessageWithCodeLine errorMessageWithCodeLine = new ErrorMessageWithCodeLine();
        try {
            int line = (Integer)ReflectUtil.getField(problemNode, "line");
            Document document = PsiDocumentManager.getInstance((Project)anActionEvent.getProject()).getDocument((PsiFile)anActionEvent.getData(CommonDataKeys.PSI_FILE));
            int lineStartOffset = document.getLineStartOffset(line);
            int lineEndOffset = document.getLineEndOffset(line);
            String code = document.getText().substring(lineStartOffset, lineEndOffset);
            errorMessageWithCodeLine.setLineNumber(line + 1);
            errorMessageWithCodeLine.setCode(code);
            return errorMessageWithCodeLine;
        }
        catch (NoSuchFieldException e) {
            log.warn("getCode NoSuchFieldException:" + e.getMessage());
        }
        catch (IllegalAccessException e) {
            log.warn("getCode IllegalAccessException:" + e.getMessage());
        }
        catch (Exception e) {
            log.warn("getCode Exception: " + e.getMessage() + ". ProblemNode: " + JSON.toJSONString((Object)problemNode));
        }
        return null;
    }

    @Override
    public boolean needClearContext() {
        return CosyConfig.getFeature(BuildFeature.VPC_ENABLED.getKey(), false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anActionEvent", "com/alibabacloud/intellij/cosy/problem/action/CosyCodeProblemsTreePopupAction", "actionPerformed"));
    }
}

