/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.problem.action;

import com.alibabacloud.intellij.cosy.common.BuildFeature;
import com.alibabacloud.intellij.cosy.common.CosyConfig;
import com.alibabacloud.intellij.cosy.problem.action.BaseCosyCodeProblemsAction;
import com.alibabacloud.intellij.cosy.problem.model.ErrorMessageWithCodeLine;
import com.alibabacloud.intellij.cosy.search.enums.TrackEventTypeEnum;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import icons.LingmaIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class CosyCodeProblemsIntentionAction
extends BaseIntentionAction
implements BaseCosyCodeProblemsAction,
Iconable {
    private static Logger log = Logger.getInstance(CosyCodeProblemsIntentionAction.class);

    @NotNull
    public String getText() {
        String string = CosyBundle.message("action.TriggerCosyCodeProblemsTreePopupAction.text", new Object[0]);
        if (string == null) {
            CosyCodeProblemsIntentionAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    @IntentionFamilyName
    public String getFamilyName() {
        return "CodeProblemsIntentionAction";
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        if (project == null) {
            CosyCodeProblemsIntentionAction.$$$reportNull$$$0(1);
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement elementAtCaret = psiFile.findElementAt(offset);
        return this.hasErrorAt(project, elementAtCaret, editor);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
        if (project == null) {
            CosyCodeProblemsIntentionAction.$$$reportNull$$$0(2);
        }
        TextRange rang = this.getCodeRange(editor);
        List<String> errorMessageList = this.listErrorMessages(project, editor, rang);
        String code = editor.getDocument().getText(rang);
        int lineNumber = editor.getDocument().getLineNumber(rang.getStartOffset());
        ErrorMessageWithCodeLine errorMessageWithCodeLine = new ErrorMessageWithCodeLine();
        errorMessageWithCodeLine.setCode(code);
        errorMessageWithCodeLine.setLineNumber(lineNumber + 1);
        errorMessageWithCodeLine.setErrorMessage(StringUtils.join((Object[])errorMessageList.toArray(), (String)"\n"));
        this.solveProblems(project, psiFile, errorMessageList, errorMessageWithCodeLine, TrackEventTypeEnum.CODE_PROBLEMS_INLAY);
    }

    private boolean hasErrorAt(Project project, PsiElement element, Editor editor) {
        TextRange range = this.getCodeRange(editor);
        List highlightInfos = DaemonCodeAnalyzerImpl.getHighlights((Document)editor.getDocument(), (HighlightSeverity)HighlightSeverity.WEAK_WARNING, (Project)project);
        if (CollectionUtils.isEmpty((Collection)highlightInfos)) {
            return false;
        }
        for (HighlightInfo info : highlightInfos) {
            int infoEndOffset;
            int infoStartOffset = info.getStartOffset();
            if (!range.intersectsStrict(infoStartOffset, infoEndOffset = info.getEndOffset())) continue;
            return true;
        }
        return false;
    }

    private List<String> listErrorMessages(Project project, Editor editor, TextRange range) {
        List highlightInfos = DaemonCodeAnalyzerImpl.getHighlights((Document)editor.getDocument(), (HighlightSeverity)HighlightSeverity.WEAK_WARNING, (Project)project);
        ArrayList<String> errorMessageList = new ArrayList<String>();
        for (HighlightInfo info : highlightInfos) {
            int infoEndOffset;
            int infoStartOffset = info.getStartOffset();
            if (!range.intersectsStrict(infoStartOffset, infoEndOffset = info.getEndOffset()) || !StringUtils.isNotBlank((CharSequence)info.getDescription())) continue;
            errorMessageList.add(info.getDescription());
        }
        return errorMessageList;
    }

    private TextRange getCodeRange(Editor editor) {
        int endOffset;
        SelectionModel selectionModel = editor.getSelectionModel();
        int startOffset = selectionModel.getSelectionStart();
        if (startOffset == (endOffset = selectionModel.getSelectionEnd())) {
            LogicalPosition logicalPosition = editor.getCaretModel().getLogicalPosition();
            startOffset = editor.getDocument().getLineStartOffset(logicalPosition.line);
            endOffset = editor.getDocument().getLineEndOffset(logicalPosition.line);
        }
        TextRange range = new TextRange(startOffset, endOffset);
        return range;
    }

    public Icon getIcon(int i) {
        return LingmaIcons.StatusBarCloudIcon;
    }

    @Override
    public boolean needClearContext() {
        return CosyConfig.getFeature(BuildFeature.VPC_ENABLED.getKey(), false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/alibabacloud/intellij/cosy/problem/action/CosyCodeProblemsIntentionAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/alibabacloud/intellij/cosy/problem/action/CosyCodeProblemsIntentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

