/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.problem.action;

import com.alibabacloud.intellij.cosy.chat.enums.ChatTaskEnum;
import com.alibabacloud.intellij.cosy.chat.model.ChatContext;
import com.alibabacloud.intellij.cosy.problem.model.CodeProblemSolveChatContext;
import com.alibabacloud.intellij.cosy.problem.model.ErrorMessageWithCodeLine;
import com.alibabacloud.intellij.cosy.search.enums.SearchActionTypeEnum;
import com.alibabacloud.intellij.cosy.search.enums.TrackEventTypeEnum;
import com.alibabacloud.intellij.cosy.search.result.SearchContext;
import com.alibabacloud.intellij.cosy.service.TelemetryService;
import com.alibabacloud.intellij.cosy.ui.search.Constants;
import com.alibabacloud.intellij.cosy.ui.search.I18NConstant;
import com.alibabacloud.intellij.cosy.ui.search.SearchToolWindowFactory;
import com.alibabacloud.intellij.cosy.ui.search.enums.OperationEnum;
import com.alibabacloud.intellij.cosy.ui.search.enums.SessionTypeEnum;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.ui.search.model.GenerateInput;
import com.alibabacloud.intellij.cosy.ui.search.topic.AnyGenerateNotifier;
import com.alibabacloud.intellij.cosy.util.FileUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.RegisterToolWindowTask;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import icons.CommonIcons;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import javax.swing.Icon;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public interface BaseCosyCodeProblemsAction {
    default public void solveProblems(Project project, PsiFile psiFile, List<String> errorMessages, ErrorMessageWithCodeLine errorMessageWithCodeLine, TrackEventTypeEnum trackEventTypeEnum) {
        if (CollectionUtils.isEmpty(errorMessages)) {
            return;
        }
        String code = errorMessageWithCodeLine.getCode();
        if (StringUtils.isBlank((CharSequence)code)) {
            return;
        }
        String requestId = UUID.randomUUID().toString();
        CodeProblemSolveChatContext chatContext = this.buildChatContext(project, psiFile, code, errorMessages, errorMessageWithCodeLine);
        SearchContext context = new SearchContext(OperationEnum.CLEAR_AND_ADD.text, SearchActionTypeEnum.CONSOLE_PROBLEMS_TRIGGER.getType());
        StringBuilder questionText = new StringBuilder();
        questionText.append(CosyBundle.message("code.problems.solve.text", new Object[0]));
        questionText.append("\n");
        for (int index = 0; index < errorMessages.size(); ++index) {
            StringBuilder errorMessage = new StringBuilder();
            errorMessage.append(index + 1);
            errorMessage.append(". ");
            errorMessage.append(errorMessages.get(index));
            errorMessage.append("\n");
            questionText.append((CharSequence)errorMessage);
        }
        GenerateInput genInput = new GenerateInput(questionText.toString(), ChatTaskEnum.CODE_PROBLEM_SOLVE.getName(), chatContext);
        TelemetryService.getInstance().telemetryChatTask(project, trackEventTypeEnum, requestId, chatContext.getSessionId(), ChatTaskEnum.CODE_PROBLEM_SOLVE.getName(), genInput, "AiDeveloper".equals(genInput.getSessionTab()) ? SessionTypeEnum.DEVELOPER.getTelemetryType() : SessionTypeEnum.CHAT.getTelemetryType());
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(Constants.PLUGIN_NAME);
        if (toolWindow == null) {
            ToolWindowManager.getInstance((Project)project).registerToolWindow(RegisterToolWindowTask.closable((String)Constants.PLUGIN_NAME, (Icon)CommonIcons.AI, (ToolWindowAnchor)ToolWindowAnchor.RIGHT));
            toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(Constants.PLUGIN_NAME);
        }
        ToolWindow finalToolWindow = toolWindow;
        ApplicationManager.getApplication().invokeLater(() -> {
            if (finalToolWindow != null) {
                if (finalToolWindow.getContentManager().findContent(I18NConstant.MAIN_CONTENT_NAME) == null) {
                    SearchToolWindowFactory.createSearchMainPanelAndGenerateContentForm(project, finalToolWindow, (Consumer<Project>)((Consumer)project1 -> ((AnyGenerateNotifier)project1.getMessageBus().syncPublisher(AnyGenerateNotifier.ANY_GENERATE_NOTIFICATION)).anyGenerate(context, genInput, requestId, this.needClearContext())));
                } else {
                    SearchToolWindowFactory.showToolWindow(project);
                    ((AnyGenerateNotifier)project.getMessageBus().syncPublisher(AnyGenerateNotifier.ANY_GENERATE_NOTIFICATION)).anyGenerate(context, genInput, requestId, this.needClearContext());
                }
            }
        });
    }

    default public CodeProblemSolveChatContext buildChatContext(Project project, PsiFile psiFile, String code, List<String> errorMessages, ErrorMessageWithCodeLine errorMessageWithCodeLine) {
        return ((CodeProblemSolveChatContext.CodeProblemSolveChatContextBuilder)((CodeProblemSolveChatContext.CodeProblemSolveChatContextBuilder)((ChatContext.ChatContextBuilder)((CodeProblemSolveChatContext.CodeProblemSolveChatContextBuilder)((CodeProblemSolveChatContext.CodeProblemSolveChatContextBuilder)((CodeProblemSolveChatContext.CodeProblemSolveChatContextBuilder)((CodeProblemSolveChatContext.CodeProblemSolveChatContextBuilder)((CodeProblemSolveChatContext.CodeProblemSolveChatContextBuilder)CodeProblemSolveChatContext.builder().fileLanguage(FileUtil.getLanguageFileType(project))).filePath(psiFile == null || psiFile.getVirtualFile() == null ? null : psiFile.getVirtualFile().getPath())).sessionId(null)).sourceCode(code)).localeLanguage(Locale.getDefault().getLanguage())).errorMessages(errorMessages)).fileCode(psiFile == null ? null : psiFile.getText())).errorMessageWithCodeLines(Collections.singletonList(errorMessageWithCodeLine))).build();
    }

    default public boolean needClearContext() {
        return true;
    }
}

