/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.listener.inline;

import com.alibabacloud.intellij.cosy.common.CosyCacheKeys;
import com.alibabacloud.intellij.cosy.listener.model.CommandEditorState;
import com.alibabacloud.intellij.cosy.service.TelemetryService;
import com.alibabacloud.intellij.cosy.service.enums.TextChangeTypeEnum;
import com.alibabacloud.intellij.cosy.service.model.TextChangeContext;
import com.alibabacloud.intellij.cosy.ui.search.model.ChatCopyContext;
import com.alibabacloud.intellij.cosy.util.EditorUtil;
import com.alibabacloud.intellij.cosy.util.LanguageUtil;
import com.alibabacloud.intellij.cosy.util.StringUtils;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class TypingChangeWatcher {
    private static final Logger LOG = Logger.getInstance(TypingChangeWatcher.class);
    private static final Set<String> LEFT_BRACKET_CHARS = Set.of("{", "(");
    private static final Set<String> RIGHT_BRACKET_CHARS = Set.of("}", ")");
    private static Map<String, String> changeTypeMapping = new HashMap<String, String>(){
        {
            this.put("Typing", TextChangeTypeEnum.TYPING.getType());
            this.put("\u8f93\u5165", TextChangeTypeEnum.TYPING.getType());
            this.put("Backspace", TextChangeTypeEnum.DELETE.getType());
            this.put("\u9000\u683c", TextChangeTypeEnum.DELETE.getType());
        }
    };
    private static final Set<String> TEXT_CHANGE_COMMANDS = Set.of("Paste", "\u7c98\u8d34", "\u91cd\u505a\u7c98\u8d34", "Typing", "\u8f93\u5165", "Choose Lookup Item", "\u9009\u62e9\u67e5\u8be2\u6761\u76ee", "\u9009\u62e9\u67e5\u8be2\u9879");
    private static final Set<String> PASTE_COMMANDS = Set.of("Paste", "\u7c98\u8d34", "\u91cd\u505a\u7c98\u8d34");
    private static final Set<String> SELECT_LOOKUP_COMMANDS = Set.of("Choose Lookup Item", "\u9009\u62e9\u67e5\u8be2\u6761\u76ee", "\u9009\u62e9\u67e5\u8be2\u9879");

    public static void recordType(Editor editor, CommandEvent event, CommandEditorState first, CommandEditorState second) {
        int previousOffset = first.getOffset();
        int newOffset = second.getOffset();
        if (newOffset < 0 || previousOffset > newOffset) {
            return;
        }
        String addedText = editor.getDocument().getText(new TextRange(previousOffset, newOffset));
        TelemetryService.getInstance().typeRecord(editor, addedText);
        TelemetryService.getInstance().telemetryCommand(event);
    }

    public static void recordTextChange(Editor editor, CommandEvent event, CommandEditorState first, CommandEditorState second) {
        Project project = event.getProject();
        if (project == null) {
            return;
        }
        String commandName = event.getCommandName();
        if (!TEXT_CHANGE_COMMANDS.contains(commandName)) {
            return;
        }
        int previousOffset = first.getOffset();
        int newOffset = second.getOffset();
        if (newOffset < 0 || previousOffset > newOffset) {
            return;
        }
        Object addedText = editor.getDocument().getText(new TextRange(previousOffset, newOffset));
        int lineNumber = editor.getDocument().getLineNumber(previousOffset);
        String changeType = TextChangeTypeEnum.INSERT.getType();
        if (changeTypeMapping.containsKey(commandName)) {
            changeType = changeTypeMapping.get(commandName);
        }
        boolean accept = false;
        boolean nonLingmaPasted = false;
        String source = null;
        String chatTask = null;
        if (PASTE_COMMANDS.contains(commandName)) {
            ChatCopyContext copyContext;
            String clipText = EditorUtil.getCopyPasteText();
            if (clipText != null) {
                addedText = clipText;
            }
            if (null != (copyContext = (ChatCopyContext)CosyCacheKeys.KEY_COPY_PASTE.get((UserDataHolder)ApplicationManager.getApplication())) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)copyContext.getText()) && StringUtils.matchCopyContent((String)addedText, copyContext.getText())) {
                accept = true;
                source = "chat";
                chatTask = copyContext.getChatTask();
            } else {
                nonLingmaPasted = true;
            }
        } else if (SELECT_LOOKUP_COMMANDS.contains(commandName)) {
            String selectItem = (String)CosyCacheKeys.KEY_SELECT_LOOKUP_ITEM.get((UserDataHolder)editor);
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)selectItem) && selectItem.contains(((String)addedText).trim())) {
                CosyCacheKeys.KEY_SELECT_LOOKUP_ITEM.set((UserDataHolder)editor, null);
                return;
            }
        } else if (previousOffset > 1 && ((String)addedText).startsWith("\n") && ((String)addedText).trim().isEmpty()) {
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)first.getCaretPrevChar()) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)first.getCaretNextChar()) && LEFT_BRACKET_CHARS.contains(first.getCaretPrevChar()) && RIGHT_BRACKET_CHARS.contains(first.getCaretNextChar())) {
                addedText = (String)addedText + "\n}";
            }
        } else {
            TemplateManager templateManager = TemplateManager.getInstance((Project)project);
            Template template = templateManager.getActiveTemplate(editor);
            if (template == null || org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)template.getKey())) {
                // empty if block
            }
        }
        LOG.debug("recordTextChange commandName:" + commandName + " accept:" + accept + " addedText:" + (String)addedText);
        String filePath = EditorUtil.getEditorFilePath(editor);
        TelemetryService.getInstance().telemetryTextChange(TextChangeContext.builder().project(editor.getProject()).filePath(filePath).addedText((String)addedText).startLineNumber(lineNumber).accepted(accept).language(LanguageUtil.getLanguageByFilePath(filePath)).source(source).changeType(changeType).nonLingmaPasted(nonLingmaPasted).chatTask(chatTask).build());
    }
}

