/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.listener;

import com.alibabacloud.intellij.cosy.core.Cosy;
import com.alibabacloud.intellij.cosy.util.FileUtil;
import com.alibabacloud.intellij.cosy.util.ThreadUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import java.io.File;
import java.util.Collections;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.FileRename;
import org.eclipse.lsp4j.RenameFilesParams;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.jetbrains.annotations.NotNull;

public class CosyVirtualFileListener
extends VirtualFileAdapter {
    private static final Logger log = Logger.getInstance(CosyVirtualFileListener.class);

    public void contentsChanged(@NotNull VirtualFileEvent event) {
        if (event == null) {
            CosyVirtualFileListener.$$$reportNull$$$0(0);
        }
        VirtualFile file = event.getFile();
        log.debug("contentsChanged: " + file.getPath());
        if (!file.getFileType().isBinary() && file.isWritable() && file.isValid()) {
            ThreadUtil.executeIndex(() -> {
                log.debug("File saved: " + file.getPath());
                this.triggerSaveEvent(file);
            });
        }
    }

    public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
        if (event == null) {
            CosyVirtualFileListener.$$$reportNull$$$0(1);
        }
        if ("name".equals(event.getPropertyName()) && event.getOldValue() instanceof String) {
            ThreadUtil.executeIndex(() -> {
                try {
                    Project project = ProjectLocator.getInstance().guessProjectForFile(event.getFile());
                    if (project == null || !Cosy.INSTANCE.checkCosy(project)) {
                        return;
                    }
                    if (FileUtil.isIgnoreIndexFile(project, event.getFile())) {
                        log.debug("ignore rename index file:" + event.getFile().getPath());
                        return;
                    }
                    RenameFilesParams params = new RenameFilesParams();
                    FileRename fileRename = new FileRename();
                    File fileDir = new File(event.getFile().getPresentableUrl()).getParentFile();
                    fileRename.setOldUri(new File(fileDir, (String)event.getOldValue()).getAbsolutePath());
                    fileRename.setNewUri(event.getFile().getPresentableUrl());
                    params.setFiles(Collections.singletonList(fileRename));
                    if (fileRename.getNewUri() == null || fileRename.getNewUri().equals(fileRename.getOldUri())) {
                        return;
                    }
                    log.debug("File renamed from: " + event.getOldValue() + " to: " + event.getFile().getPresentableUrl());
                    Cosy.INSTANCE.getLanguageService(project).getServer().getWorkspaceService().didRenameFiles(params);
                }
                catch (Throwable e) {
                    log.warn("Encountered error when move file:" + event, e);
                }
            });
        }
    }

    private void triggerSaveEvent(VirtualFile file) {
        try {
            Project project = ProjectLocator.getInstance().guessProjectForFile(file);
            if (project == null) {
                log.warn("ignore save event:" + file.getPath() + ", project not ready.");
                return;
            }
            if (FileUtil.isIgnoreIndexFile(project, file)) {
                log.debug("ignore save index file:" + file.getPath());
                return;
            }
            if (Cosy.INSTANCE.checkCosy(project, false)) {
                DidSaveTextDocumentParams params = new DidSaveTextDocumentParams();
                TextDocumentIdentifier textDocument = new TextDocumentIdentifier(file.getPresentableUrl());
                params.setTextDocument(textDocument);
                Cosy.INSTANCE.getLanguageService(project).getServer().getTextDocumentService().didSave(params);
            }
        }
        catch (Throwable e) {
            log.warn("Encountered error when save file:" + file, e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "event";
        objectArray2[1] = "com/alibabacloud/intellij/cosy/listener/CosyVirtualFileListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "contentsChanged";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "propertyChanged";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

