/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.listener;

import com.alibabacloud.intellij.cosy.common.CosySetting;
import com.alibabacloud.intellij.cosy.completion.trigger.SymbolNameChangeTriggerChecker;
import com.alibabacloud.intellij.cosy.completion.trigger.TriggerCheckContext;
import com.alibabacloud.intellij.cosy.editor.CosyInlayManager;
import com.alibabacloud.intellij.cosy.editor.CosyInlineEditManager;
import com.alibabacloud.intellij.cosy.editor.inline.InlineEditUtil;
import com.alibabacloud.intellij.cosy.editor.model.CompletionTriggerConfig;
import com.alibabacloud.intellij.cosy.editor.model.InlayDisposeEventEnum;
import com.alibabacloud.intellij.cosy.editor.model.InlayTriggerEventEnum;
import com.alibabacloud.intellij.cosy.search.enums.CompletionGenerateLengthLevelEnum;
import com.alibabacloud.intellij.cosy.search.enums.CompletionTriggerModeEnum;
import com.alibabacloud.intellij.cosy.search.enums.InlineTriggerModeEnum;
import com.alibabacloud.intellij.cosy.service.TelemetryService;
import com.alibabacloud.intellij.cosy.service.model.TimestampEnum;
import com.alibabacloud.intellij.cosy.ui.config.CosyPersistentSetting;
import com.alibabacloud.intellij.cosy.util.EditorUtil;
import com.alibabacloud.intellij.cosy.util.PsiUtils;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupManagerListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class CosyLookupManagerListener
implements LookupManagerListener {
    private static final Logger LOGGER = Logger.getInstance(CosyLookupManagerListener.class);
    private static final long LAST_ACCEPTED_TIME = 200L;
    private static final String IGNORE_TRIGGER_TYPE = "ignore";
    private static final String ALLOW_TRIGGER_TYPE = "trigger";
    private static final String CONTINUE_TRIGGER_TYPE = "continue";

    public void activeLookupChanged(@Nullable Lookup oldLookup, @Nullable Lookup newLookup) {
        boolean isShowInline;
        PsiFile psiFile = this.getFile(oldLookup, newLookup);
        CosySetting settings = CosyPersistentSetting.getInstance().getState();
        boolean bl = isShowInline = settings != null && settings.getParameter() != null && settings.getParameter().getCloud().isShowInlineWhenIDECompletion();
        if (isShowInline) {
            return;
        }
        if (psiFile != null && !CosyPersistentSetting.getInstance().isEnableCloudCompletion(settings, CompletionTriggerModeEnum.AUTO)) {
            return;
        }
        Editor lookupEditor = null;
        if (newLookup != null) {
            lookupEditor = newLookup.getEditor();
        } else if (oldLookup != null) {
            lookupEditor = oldLookup.getEditor();
        }
        if (lookupEditor != null && this.isAfterChineseInput(lookupEditor)) {
            LOGGER.debug("input after chinese, ignore lookup trigger");
            return;
        }
        if (oldLookup != null && newLookup == null) {
            Editor editor;
            LOGGER.debug("active lookup changed, lookup closed");
            PsiFile file = oldLookup.getPsiFile();
            if (file != null && EditorUtil.isSelectedEditor(editor = oldLookup.getEditor()) && CosyInlayManager.getInstance().isAvailable(editor) && EditorUtil.isAvailableLanguage(editor) && System.currentTimeMillis() - TelemetryService.getInstance().getTimestamp(TimestampEnum.ACCEPT_TIMESTAMP_TYPE.getType()) > 200L && !CosyInlayManager.getInstance().hasCompletionInlays(editor)) {
                if (CosyInlayManager.getInstance().hasCompletionInlays(editor)) {
                    InlineEditUtil.disposeAllInline(editor, InlayDisposeEventEnum.POPUP_COMPLETION_FINISHED);
                }
                SwingUtilities.invokeLater(() -> {
                    if (this.isValidEditTriggerPosition(editor)) {
                        CosyInlineEditManager.getInstance().inlineEdit(editor, InlineTriggerModeEnum.LOOKUP);
                    } else if (this.isValidCompletionTriggerPosition(editor) && !oldLookup.getItems().isEmpty()) {
                        CosyInlayManager.getInstance().editorChanged(CompletionTriggerConfig.customConfig(this.configGenerateLength(editor), InlayTriggerEventEnum.LOOKUP_FINISHED), editor, CompletionTriggerModeEnum.AUTO);
                    }
                });
            }
        } else if (newLookup != null && oldLookup == null) {
            LOGGER.debug("active lookup changed, lookup open");
            Editor editor = newLookup.getEditor();
            if (CosyInlayManager.getInstance().isAvailable(editor)) {
                CosyInlayManager.getInstance().cancelCompletion(editor);
            }
        }
    }

    private PsiFile getFile(@Nullable Lookup oldLookup, @Nullable Lookup newLookup) {
        Lookup validLookup = newLookup != null ? newLookup : oldLookup;
        return validLookup != null ? validLookup.getPsiFile() : null;
    }

    private boolean isAfterChineseInput(Editor editor) {
        return (Boolean)ApplicationManager.getApplication().runReadAction(() -> {
            int cursorOffset = editor.getCaretModel().getOffset();
            Document document = editor.getDocument();
            if (document.getTextLength() <= cursorOffset || cursorOffset <= 0) {
                return false;
            }
            String text = document.getText();
            if (StringUtils.isEmpty((CharSequence)text) || cursorOffset >= text.length()) {
                return false;
            }
            char c = text.charAt(cursorOffset - 1);
            return c >= '\u4e00' && c <= '\u9fa5';
        });
    }

    private CompletionGenerateLengthLevelEnum configGenerateLength(Editor editor) {
        return (CompletionGenerateLengthLevelEnum)((Object)ApplicationManager.getApplication().runReadAction(() -> {
            Document document = editor.getDocument();
            int offset = editor.getCaretModel().getOffset();
            String lineSuffixCode = document.getText(TextRange.create((int)offset, (int)document.getLineEndOffset(document.getLineNumber(offset))));
            CompletionGenerateLengthLevelEnum generateLength = null;
            if (StringUtils.isNotBlank((CharSequence)lineSuffixCode)) {
                generateLength = CompletionGenerateLengthLevelEnum.LINE_LEVEL;
            }
            return generateLength;
        }));
    }

    private boolean isValidCompletionTriggerPosition(Editor editor) {
        return (Boolean)ApplicationManager.getApplication().runReadAction(() -> {
            TemplateManager templateManager;
            if (editor == null || editor.getDocument().isInBulkUpdate() || editor.getCaretModel().getCaretCount() > 1) {
                return false;
            }
            if (!PsiUtils.checkCaretAround(editor, false)) {
                LOGGER.debug("invalid caret around, ignore trigger");
                return false;
            }
            if (editor.getProject() != null && (templateManager = TemplateManager.getInstance((Project)editor.getProject())) != null && templateManager.getActiveTemplate(editor) != null) {
                LOGGER.debug("Skipping template completion. There is an active template");
                return false;
            }
            PsiElement element = PsiUtils.getCaratElement(editor);
            if (element != null) {
                LOGGER.debug("close popup caret element class:" + element.getClass() + " parent:" + element.getParent().getClass());
            } else {
                LOGGER.debug("close popup caret element is null");
            }
            if (PsiUtils.isImportElement(element, editor)) {
                LOGGER.debug("ignore trigger import statement");
                return false;
            }
            if (PsiUtils.isLiteralElement(editor, element)) {
                LOGGER.debug("ignore trigger literal statement");
                return false;
            }
            if (this.isBetweenInvalidCompletionChars(editor)) {
                LOGGER.debug("invalid bracket char around caret, ignore completion trigger");
                return false;
            }
            return true;
        });
    }

    private boolean isValidEditTriggerPosition(Editor editor) {
        if (!InlineEditUtil.isEnableNES()) {
            return false;
        }
        return (Boolean)ApplicationManager.getApplication().runReadAction(() -> {
            if (editor == null || editor.getDocument().isInBulkUpdate() || editor.getCaretModel().getCaretCount() > 1) {
                return false;
            }
            PsiElement element = PsiUtils.getCaratElement(editor);
            if (element != null) {
                LOGGER.debug("close popup caret element class:" + element.getClass() + " parent:" + element.getParent().getClass());
            } else {
                LOGGER.debug("close popup caret element is null");
            }
            if (PsiUtils.isImportElement(element, editor)) {
                LOGGER.debug("ignore inline edit trigger import statement");
                return false;
            }
            if (PsiUtils.isLiteralElement(editor, element)) {
                LOGGER.debug("ignore inline edit trigger literal statement");
                return false;
            }
            if (PsiUtils.isCommentElement(element, editor)) {
                LOGGER.debug("ignore inline edit trigger comment statement");
                return false;
            }
            String triggerType = this.checkEditBetweenCharsTrigger(editor);
            if (ALLOW_TRIGGER_TYPE.equals(triggerType)) {
                LOGGER.debug("valid between bracket, trigger inline edit");
                return true;
            }
            if (IGNORE_TRIGGER_TYPE.equals(triggerType)) {
                LOGGER.debug("invalid between bracket, ignore inline edit");
                return false;
            }
            if (!PsiUtils.checkCaretAround(editor, true)) {
                LOGGER.debug("valid caret around for inline edit");
                return true;
            }
            SymbolNameChangeTriggerChecker changeTriggerChecker = new SymbolNameChangeTriggerChecker();
            TriggerCheckContext context = new TriggerCheckContext(editor, 0, 0, element, "");
            return changeTriggerChecker.check(context);
        });
    }

    private boolean isBetweenInvalidCompletionChars(Editor editor) {
        char prefixChar;
        int caretOffset = editor.getCaretModel().getOffset();
        Document document = editor.getDocument();
        int lineIndex = document.getLineNumber(caretOffset);
        TextRange lineSuffixRange = TextRange.create((int)caretOffset, (int)document.getLineEndOffset(lineIndex));
        String lineSuffix = document.getText(lineSuffixRange).trim();
        TextRange linePrefixRange = TextRange.create((int)document.getLineStartOffset(lineIndex), (int)caretOffset);
        String linePrefix = document.getText(linePrefixRange).trim();
        return StringUtils.isNotBlank((CharSequence)lineSuffix) && StringUtils.isNotBlank((CharSequence)linePrefix) && (lineSuffix.charAt(0) == ')' || lineSuffix.charAt(0) == ']' || lineSuffix.charAt(0) == '=') && ((prefixChar = linePrefix.charAt(linePrefix.length() - 1)) >= 'a' && prefixChar <= 'z' || prefixChar >= 'A' && prefixChar <= 'Z' || prefixChar >= '0' && prefixChar <= '9' || prefixChar == '_' || prefixChar == ')');
    }

    private String checkEditBetweenCharsTrigger(Editor editor) {
        int caretOffset = editor.getCaretModel().getOffset();
        Document document = editor.getDocument();
        int lineIndex = document.getLineNumber(caretOffset);
        TextRange lineSuffixRange = TextRange.create((int)caretOffset, (int)document.getLineEndOffset(lineIndex));
        String lineSuffix = document.getText(lineSuffixRange).trim();
        TextRange linePrefixRange = TextRange.create((int)document.getLineStartOffset(lineIndex), (int)caretOffset);
        String linePrefix = document.getText(linePrefixRange).trim();
        if (StringUtils.isNotBlank((CharSequence)lineSuffix) && StringUtils.isNotBlank((CharSequence)linePrefix) && (lineSuffix.charAt(0) == ')' || lineSuffix.charAt(0) == ']' || lineSuffix.charAt(0) == '=')) {
            char prefixChar = linePrefix.charAt(linePrefix.length() - 1);
            if (prefixChar >= 'a' && prefixChar <= 'z' || prefixChar >= 'A' && prefixChar <= 'Z' || prefixChar >= '0' && prefixChar <= '9' || prefixChar == '_' || prefixChar == ')') {
                return ALLOW_TRIGGER_TYPE;
            }
            return IGNORE_TRIGGER_TYPE;
        }
        return CONTINUE_TRIGGER_TYPE;
    }
}

