/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.listener;

import com.alibabacloud.intellij.cosy.shared.cache.CacheManager;
import com.alibabacloud.intellij.cosy.util.Md5Util;
import com.intellij.codeInsight.daemon.impl.EditorTrackerListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CosyEditorTrackerListener
implements EditorTrackerListener {
    private static final Logger log = Logger.getInstance(CosyEditorTrackerListener.class);

    public void activeEditorsChanged(@NotNull List<Editor> list) {
        if (list == null) {
            CosyEditorTrackerListener.$$$reportNull$$$0(0);
        }
        for (Editor editor : list) {
            if (editor == null || editor.getProject() == null) continue;
            if (DumbService.isDumb((Project)editor.getProject())) {
                return;
            }
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)editor.getProject()).getPsiFile(editor.getDocument());
            if (psiFile == null || !(psiFile instanceof PsiJavaFile)) continue;
            String text = editor.getDocument().getText();
            if (psiFile.getVirtualFile() == null) {
                log.warn("psiFile.getVirtualFile() == null");
                continue;
            }
            String filePath = psiFile.getVirtualFile().getPath();
            String md5 = Md5Util.encode(text.getBytes(StandardCharsets.UTF_8));
            if (CacheManager.getVariableClassCache().isMd5Exist(md5)) continue;
            CacheManager.getVariableClassCache().updateMd5(filePath, md5);
            ApplicationManager.getApplication().invokeLater(() -> {
                try {
                    final HashMap<String, PsiType> variableClassMap = new HashMap<String, PsiType>();
                    psiFile.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

                        public void visitDeclarationStatement(PsiDeclarationStatement psiDeclarationStatement) {
                            for (PsiElement psiElement : psiDeclarationStatement.getDeclaredElements()) {
                                if (!(psiElement instanceof PsiVariable)) continue;
                                PsiVariable psiVariable = (PsiVariable)psiElement;
                                String variableName = psiVariable.getNameIdentifier().getText();
                                PsiType psiType = psiVariable.getType();
                                variableClassMap.put(variableName, psiType);
                            }
                        }

                        public void visitParameter(PsiParameter parameter) {
                            String variableName = parameter.getName();
                            PsiType psiType = parameter.getType();
                            variableClassMap.put(variableName, psiType);
                        }
                    });
                    CacheManager.getVariableClassCache().set(filePath, variableClassMap);
                }
                catch (Exception e) {
                    log.warn("Load variable cache error", (Throwable)e);
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/alibabacloud/intellij/cosy/listener/CosyEditorTrackerListener", "activeEditorsChanged"));
    }
}

