/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.listener;

import com.alibabacloud.intellij.cosy.core.Cosy;
import com.alibabacloud.intellij.cosy.util.FileUtil;
import com.alibabacloud.intellij.cosy.util.ThreadUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.lsp4j.DeleteFilesParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.FileDelete;
import org.eclipse.lsp4j.FileRename;
import org.eclipse.lsp4j.RenameFilesParams;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.jetbrains.annotations.NotNull;

public class CosyBulkFileListener
implements BulkFileListener {
    private static final Logger log = Logger.getInstance(CosyBulkFileListener.class);
    private final Project project;

    public CosyBulkFileListener(Project project) {
        this.project = project;
    }

    public void before(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            CosyBulkFileListener.$$$reportNull$$$0(0);
        }
        for (VFileEvent vFileEvent : events) {
            if (!(vFileEvent instanceof VFileDeleteEvent)) continue;
            this.doDeleteFile((VFileDeleteEvent)vFileEvent);
        }
    }

    public void after(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            CosyBulkFileListener.$$$reportNull$$$0(1);
        }
        for (VFileEvent vFileEvent : events) {
            if (vFileEvent instanceof VFileMoveEvent) {
                this.doMoveFile((VFileMoveEvent)vFileEvent);
                continue;
            }
            if (!(vFileEvent instanceof VFileCreateEvent)) continue;
            this.didCreateFile((VFileCreateEvent)vFileEvent);
        }
    }

    private void didCreateFile(VFileCreateEvent event) {
        try {
            Project project = this.getProject(event.getFile());
            if (project == null) {
                return;
            }
            VirtualFile file = event.getFile();
            if (FileUtil.isIgnoreIndexFile(project, file)) {
                log.debug("ignore save index file:" + file);
                return;
            }
            ThreadUtil.executeIndex(() -> {
                log.info("Create file:" + event);
                DidSaveTextDocumentParams params = new DidSaveTextDocumentParams();
                TextDocumentIdentifier textDocument = new TextDocumentIdentifier(file.getPresentableUrl());
                params.setTextDocument(textDocument);
                Cosy.INSTANCE.getLanguageService(project).getServer().getTextDocumentService().didSave(params);
            });
        }
        catch (Throwable e) {
            log.warn("Encountered error when save file:" + event, e);
        }
    }

    private void doDeleteFile(VFileDeleteEvent event) {
        try {
            Project project = this.getProject(event.getFile());
            if (project == null) {
                return;
            }
            if (FileUtil.isIgnoreIndexFile(project, event.getFile())) {
                log.debug("ignore delete index file:" + event.getFile().getPresentableUrl());
                return;
            }
            ThreadUtil.executeIndex(() -> {
                log.info("Delete file:" + event);
                DeleteFilesParams params = new DeleteFilesParams();
                params.setFiles(Collections.singletonList(new FileDelete(event.getFile().getPresentableUrl())));
                Cosy.INSTANCE.getLanguageService(project).getServer().getWorkspaceService().didDeleteFiles(params);
            });
        }
        catch (Throwable e) {
            log.warn("Encountered error when delete file:" + event, e);
        }
    }

    private void doMoveFile(VFileMoveEvent event) {
        try {
            Project project = this.getProject(event.getFile());
            if (project == null) {
                return;
            }
            if (event.getOldParent().getPresentableUrl().equals(event.getNewParent().getPresentableUrl())) {
                return;
            }
            String fileName = event.getFile().getName();
            VirtualFile newFile = event.getNewParent().findFileByRelativePath(fileName);
            if (FileUtil.isIgnoreIndexFile(project, newFile)) {
                log.debug("ignore move index file:" + event.getOldParent().getPresentableUrl() + " to:" + event.getNewParent().getPresentableUrl());
                return;
            }
            ThreadUtil.executeIndex(() -> {
                log.info("Move file:" + event);
                RenameFilesParams params = new RenameFilesParams();
                FileRename fileRename = new FileRename();
                fileRename.setOldUri(new File(event.getOldParent().getPresentableUrl(), fileName).getAbsolutePath());
                fileRename.setNewUri(new File(event.getNewParent().getPresentableUrl(), fileName).getAbsolutePath());
                params.setFiles(Collections.singletonList(fileRename));
                Cosy.INSTANCE.getLanguageService(project).getServer().getWorkspaceService().didRenameFiles(params);
            });
        }
        catch (Throwable e) {
            log.warn("Encountered error when move file:" + event, e);
        }
    }

    private Project getProject(VirtualFile file) {
        try {
            Project project = ProjectLocator.getInstance().guessProjectForFile(file);
            if (project == null || !Objects.equals(project.getProjectFilePath(), this.project.getProjectFilePath())) {
                log.debug("ignore event, project not ready.");
                return null;
            }
            if (!Cosy.INSTANCE.checkCosy(project, false)) {
                return null;
            }
            return project;
        }
        catch (Exception e) {
            log.warn("Encountered error when get project for file:" + file, (Throwable)e);
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "events";
        objectArray2[1] = "com/alibabacloud/intellij/cosy/listener/CosyBulkFileListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "before";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "after";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

