/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.linguist.util;

import com.alibabacloud.intellij.cosy.linguist.enums.PsiDirection;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.List;

public class LinguistPsiTreeUtils {
    private static final Logger log = Logger.getInstance(LinguistPsiTreeUtils.class);

    public static PsiElement findLowestCommonAncestor(PsiElement root, PsiElement left, PsiElement right) {
        if (root == null || root.equals(left) || root.equals(left)) {
            return root;
        }
        ArrayList<PsiElement> parentA = LinguistPsiTreeUtils.getParents(left);
        ArrayList<PsiElement> parentB = LinguistPsiTreeUtils.getParents(right);
        int leftSize = parentA.size() - 1;
        PsiElement result = root;
        for (int rightSize = parentB.size() - 1; leftSize >= 0 && rightSize >= 0 && parentA.get(leftSize).equals(parentB.get(rightSize)); --leftSize, --rightSize) {
            result = parentA.get(leftSize);
        }
        return result;
    }

    private static ArrayList<PsiElement> getParents(PsiElement node) {
        ArrayList<PsiElement> list = new ArrayList<PsiElement>();
        while (node != null) {
            list.add(node);
            node = node.getParent();
        }
        return list;
    }

    public static PsiElement findClosestNonWhitespaceElement(PsiElement psiElement, PsiDirection psiDirection, List<TextRange> validRange) {
        if (PsiDirection.LEFT.equals((Object)psiDirection)) {
            while (psiElement != null && LinguistPsiTreeUtils.needSkip(psiElement)) {
                psiElement = psiElement.getPrevSibling();
            }
            if (!LinguistPsiTreeUtils.isInsideValidRange(psiElement, validRange)) {
                psiElement = PsiTreeUtil.getDeepestLast((PsiElement)psiElement);
            }
        } else if (PsiDirection.RIGHT.equals((Object)psiDirection)) {
            while (psiElement != null && LinguistPsiTreeUtils.needSkip(psiElement)) {
                psiElement = psiElement.getNextSibling();
            }
            if (!LinguistPsiTreeUtils.isInsideValidRange(psiElement, validRange)) {
                psiElement = PsiTreeUtil.getDeepestFirst((PsiElement)psiElement);
            }
        }
        return psiElement;
    }

    private static boolean needSkip(PsiElement psiElement) {
        return psiElement instanceof PsiWhiteSpace || psiElement instanceof PsiErrorElement;
    }

    private static boolean isInsideValidRange(PsiElement psiElement, List<TextRange> validRange) {
        TextRange range = psiElement.getTextRange();
        boolean isStartValid = LinguistPsiTreeUtils.rangesContain(validRange, range.getStartOffset());
        boolean isEndValid = LinguistPsiTreeUtils.rangesContain(validRange, range.getEndOffset());
        return isStartValid && isEndValid;
    }

    public static boolean rangesContain(List<? extends TextRange> rangeList, int offset) {
        return LinguistPsiTreeUtils.rangesContain(rangeList, 0, rangeList.size() - 1, offset);
    }

    static boolean rangesContain(List<? extends TextRange> ranges, int startIndex, int endIndex, int offset) {
        if (endIndex >= startIndex && ranges.size() > startIndex && ranges.size() > endIndex) {
            int startOffset = ranges.get(startIndex).getStartOffset();
            int endOffset = ranges.get(endIndex).getEndOffset();
            if (offset >= startOffset && offset <= endOffset) {
                if (startIndex == endIndex) {
                    return true;
                }
                int midIndex = (endIndex + startIndex) / 2;
                return LinguistPsiTreeUtils.rangesContain(ranges, startIndex, midIndex, offset) || LinguistPsiTreeUtils.rangesContain(ranges, midIndex + 1, endIndex, offset);
            }
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void prettyPrintPsiTree(PsiElement root) {
        Project project = root.getProject();
        synchronized (project) {
            LinguistPsiTreeUtils.printHelper(root, "\t");
        }
    }

    private static void printHelper(PsiElement root, String start) {
        if (root == null) {
            return;
        }
        String mid = start.substring(0, start.lastIndexOf("\t")) + "\u2514---";
        log.debug(mid + root.getClass() + "(" + root.getText() + ")");
        if (root.getChildren() == null) {
            return;
        }
        for (PsiElement node : root.getChildren()) {
            LinguistPsiTreeUtils.printHelper(node, start + "\t");
        }
    }
}

