/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.linguist.util;

import com.alibabacloud.intellij.cosy.linguist.model.ClassItem;
import com.alibabacloud.intellij.cosy.linguist.model.FieldItem;
import com.alibabacloud.intellij.cosy.linguist.model.ItemBase;
import com.alibabacloud.intellij.cosy.linguist.model.MethodItem;
import com.alibabacloud.intellij.cosy.util.PsiUtils;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class AvailableListUtils {
    public static void addPsiClassToAvailableList(List<ItemBase> availableList, PsiClass psiClass, PsiElement context, boolean onlyStatic, String origin, Integer priority) {
        if (psiClass != null) {
            origin = origin == null ? "DEFAULT" : origin;
            priority = priority == null ? 999 : priority;
            PsiClass contextClass = PsiUtils.getContainingClass(context);
            Predicate<PsiModifierListOwner> predicator = PsiUtils.generateVisibilityPredicator(psiClass, contextClass);
            PsiMethod[] methods = PsiUtils.getMethodsFromPsiClass(psiClass, onlyStatic, "", predicator);
            PsiField[] fields = PsiUtils.getFieldsFromPsiClass(psiClass, onlyStatic, "", predicator);
            for (PsiMethod psiMethod : methods) {
                String methodName = psiMethod.getName();
                List<String> paramTypes = Arrays.stream(psiMethod.getParameterList().getParameters()).map(p -> PsiUtils.parsePsiType(p.getType())).collect(Collectors.toList());
                String returnType = PsiUtils.parsePsiType(psiMethod.getReturnType());
                MethodItem methodItem = new MethodItem(methodName, paramTypes, returnType, origin, priority);
                availableList.add(methodItem);
            }
            for (PsiMethod psiMethod : fields) {
                String fieldName = psiMethod.getName();
                String fieldType = PsiUtils.parsePsiType(psiMethod.getType());
                FieldItem fieldItem = new FieldItem(fieldName, fieldType, origin, priority);
                availableList.add(fieldItem);
            }
        }
    }

    public static ClassItem convertPsiTypeToClassItem(PsiType psiType, String origin, Integer priority) {
        if (psiType == null) {
            return null;
        }
        origin = origin == null ? "DEFAULT" : origin;
        priority = priority == null ? 999 : priority;
        return new ClassItem(psiType.getPresentableText(), psiType.getCanonicalText(), origin, priority);
    }
}

