/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.linguist.reference;

import com.alibabacloud.intellij.cosy.core.lsp.model.model.CodeReferenceResult;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.QueryReferenceParams;
import com.alibabacloud.intellij.cosy.linguist.reference.inheritance.InheritanceUtil;
import com.alibabacloud.intellij.cosy.linguist.reference.signature.SignatureUtil;
import com.alibabacloud.intellij.cosy.service.model.Features;
import com.alibabacloud.intellij.cosy.util.ReflectUtil;
import com.alibabacloud.intellij.cosy.util.StopWatch;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.daemon.GutterMark;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.NavigateAction;
import com.intellij.codeInsight.navigation.GotoTargetHandler;
import com.intellij.codeInsight.navigation.ImplementationSearcher;
import com.intellij.codeInsight.navigation.actions.GotoDeclarationAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReferenceResolver {
    private static final Logger logger = Logger.getInstance(ReferenceResolver.class);
    private static final Cache<String, CodeReferenceResult> REFERENCE_CACHE = Caffeine.newBuilder().expireAfterWrite(24L, TimeUnit.HOURS).maximumSize(1000L).build();

    public static CodeReferenceResult resolveImplement(Editor editor, QueryReferenceParams params) {
        CodeReferenceResult cacheResult;
        CodeReferenceResult result = new CodeReferenceResult();
        result.setItems(new ArrayList<CodeReferenceResult.CodeReferenceItem>());
        result.setSuccess(false);
        if (editor == null || editor.getProject() == null) {
            return result;
        }
        LogicalPosition logicalPosition = new LogicalPosition(params.getTargetRow(), params.getTargetColumn());
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        VirtualFile virtualFile = fileDocumentManager.getFile(editor.getDocument());
        if (virtualFile == null) {
            return result;
        }
        String cacheKey = String.format("implement:%s:%s:%d:%d", editor.getProject().getBasePath(), virtualFile.getPresentableUrl(), params.getTargetRow(), params.getTargetColumn());
        if (StringUtils.isNotBlank((CharSequence)params.getKey())) {
            cacheKey = String.format("implement:%s:%s", editor.getProject().getBasePath(), params.getKey());
        }
        if ((cacheResult = (CodeReferenceResult)REFERENCE_CACHE.getIfPresent((Object)cacheKey)) != null) {
            logger.debug("Using reference cache: " + (cacheResult.getItems() == null ? 0 : cacheResult.getItems().size()));
            return cacheResult;
        }
        logger.debug("query reference cache " + cacheKey);
        GotoTargetHandler.GotoData data = ReferenceResolver.getSourceAndTargetElements(editor, virtualFile, logicalPosition);
        try {
            if (data == null) {
                logger.debug("No source and target elements found");
                return result;
            }
            PsiElement[] targets = (PsiElement[])ReflectUtil.getField(data, "targets");
            if (targets != null && targets.length > 0) {
                ApplicationManager.getApplication().runReadAction(() -> {
                    for (int i = 0; i < targets.length; ++i) {
                        CodeReferenceResult.CodeReferenceItem item = ReferenceResolver.parseElement(targets[i]);
                        if (item == null || virtualFile.getPresentableUrl().equals(item.getFilePath())) continue;
                        result.getItems().add(item);
                    }
                });
            } else {
                logger.debug("No targets found");
            }
            result.setSuccess(true);
            REFERENCE_CACHE.put((Object)cacheKey, (Object)result);
        }
        catch (IndexNotReadyException e) {
            result.setSuccess(false);
            logger.warn("Index not ready");
        }
        catch (Exception e) {
            result.setSuccess(true);
            REFERENCE_CACHE.put((Object)cacheKey, (Object)result);
            logger.warn("Error getting source and target elements", (Throwable)e);
        }
        return result;
    }

    public static CodeReferenceResult resolveDeclaration(Editor editor, QueryReferenceParams params) {
        CodeReferenceResult cacheResult;
        CodeReferenceResult result = new CodeReferenceResult();
        result.setItems(new ArrayList<CodeReferenceResult.CodeReferenceItem>());
        result.setSuccess(false);
        if (editor == null || editor.getProject() == null) {
            return result;
        }
        LogicalPosition logicalPosition = new LogicalPosition(params.getTargetRow(), params.getTargetColumn());
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        VirtualFile virtualFile = fileDocumentManager.getFile(editor.getDocument());
        if (virtualFile == null) {
            return result;
        }
        String cacheKey = String.format("decl:%s:%s:%d:%d", editor.getProject().getBasePath(), virtualFile.getPresentableUrl(), params.getTargetRow(), params.getTargetColumn());
        if (StringUtils.isNotBlank((CharSequence)params.getKey())) {
            cacheKey = String.format("decl:%s:%s", editor.getProject().getBasePath(), params.getKey());
        }
        if ((cacheResult = (CodeReferenceResult)REFERENCE_CACHE.getIfPresent((Object)cacheKey)) != null) {
            logger.debug("Using reference cache: " + (cacheResult.getItems() == null ? 0 : cacheResult.getItems().size()) + " for " + cacheKey);
            return cacheResult;
        }
        logger.debug("query reference cache " + cacheKey);
        ReferenceResolver.findDeclarations(editor.getProject(), editor, logicalPosition, result);
        if (result.isSuccess()) {
            REFERENCE_CACHE.put((Object)cacheKey, (Object)result);
        }
        return result;
    }

    public static void findDeclarations(@NotNull Project project, @NotNull Editor editor, LogicalPosition logicalPosition, CodeReferenceResult result) {
        if (project == null) {
            ReferenceResolver.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            ReferenceResolver.$$$reportNull$$$0(1);
        }
        DumbService.getInstance((Project)project).runWithAlternativeResolveEnabled(() -> ApplicationManager.getApplication().runReadAction(() -> {
            try {
                int offset = editor.logicalPositionToOffset(logicalPosition);
                StopWatch sw = new StopWatch();
                sw.start("doSelectCandidate");
                Pair<PsiElement[], PsiElement> pair = ReferenceResolver.doSelectCandidate(project, editor, offset);
                long doSelectCandidateCost = sw.stop();
                PsiElement[] elements = (PsiElement[])pair.first;
                PsiElement usage = (PsiElement)pair.second;
                if (elements.length == 0) {
                    logger.debug(String.format("no elements found, time cost(ms): doSelectCandidate[%d]", doSelectCandidateCost));
                    return;
                }
                HashSet elementSet = new HashSet();
                Collections.addAll(elementSet, elements);
                sw.start("getSupers");
                PsiElement[] supers = InheritanceUtil.getSupers(elements);
                long getSupersCost = sw.stop();
                supers = (PsiElement[])Arrays.stream(supers).limit(Features.QUERY_REF_FROM_IDE_INHERIT_MAX_COUNT.intValue().intValue()).toArray(PsiElement[]::new);
                Collections.addAll(elementSet, supers);
                ArrayList<Long> parseElementCostList = new ArrayList<Long>();
                int elementIdx = 0;
                for (PsiElement element : elementSet) {
                    CodeReferenceResult.CodeReferenceItem item;
                    sw.start(String.format("element-%d", ++elementIdx));
                    if (element instanceof PsiDirectory) {
                        PsiDirectory dir = (PsiDirectory)element;
                        String dirPath = dir.getVirtualFile().getPresentableUrl();
                        logger.debug(String.format(String.format("find directory element, path: %s", dirPath), new Object[0]));
                        item = new CodeReferenceResult.CodeReferenceItem();
                        item.setFilePath(dirPath);
                    } else {
                        item = ReferenceResolver.parseElement(element);
                    }
                    parseElementCostList.add(sw.stop());
                    if (item == null) continue;
                    result.getItems().add(item);
                }
                result.setSuccess(true);
                logger.debug(String.format("find %d elements and %d supers, time cost(ms): doSelectCandidate[%d], getSupers[%d], parseElements[%s]", elements.length, supers.length, doSelectCandidateCost, getSupersCost, parseElementCostList));
            }
            catch (IndexNotReadyException e) {
                result.setSuccess(false);
                logger.warn("Index not ready");
            }
        }));
    }

    @NotNull
    private static Pair<PsiElement[], PsiElement> doSelectCandidate(@NotNull Project project, @NotNull Editor editor, int offset) {
        if (project == null) {
            ReferenceResolver.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            ReferenceResolver.$$$reportNull$$$0(3);
        }
        PsiElement[] elements = GotoDeclarationAction.findAllTargetElements((Project)project, (Editor)editor, (int)offset);
        logger.debug(String.format("find %d target elements at offset[%d] in project[%s]", elements.length, offset, project.getBasePath()));
        if (elements.length == 0) {
            PsiElement usage = ReferenceResolver.suggestCandidates(TargetElementUtil.findReference((Editor)editor, (int)offset)).isEmpty() ? GotoDeclarationAction.findElementToShowUsagesOf((Editor)editor, (int)offset) : null;
            return new Pair((Object)elements, (Object)usage);
        }
        return elements.length == 1 ? new Pair((Object)elements, (Object)GotoDeclarationAction.findElementToShowUsagesOf((Editor)editor, (int)offset)) : new Pair((Object)elements, null);
    }

    @NotNull
    private static Collection<PsiElement> suggestCandidates(@Nullable PsiReference reference) {
        if (reference == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                ReferenceResolver.$$$reportNull$$$0(4);
            }
            return list;
        }
        Collection collection = TargetElementUtil.getInstance().getTargetCandidates(reference);
        if (collection == null) {
            ReferenceResolver.$$$reportNull$$$0(5);
        }
        return collection;
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable GotoTargetHandler.GotoData getSourceAndTargetElements(@NotNull Editor editor, VirtualFile file, LogicalPosition logicalPosition) {
        SourceElement sourceElement;
        if (editor == null) {
            ReferenceResolver.$$$reportNull$$$0(6);
        }
        if ((sourceElement = (SourceElement)ApplicationManager.getApplication().runReadAction(() -> {
            SourceElement source = new SourceElement();
            source.offset = editor.logicalPositionToOffset(logicalPosition);
            source.source = TargetElementUtil.getInstance().findTargetElement(editor, ImplementationSearcher.getFlags(), source.offset);
            if (source == null) {
                source.offset = ReferenceResolver.tryGetNavigationSourceOffsetFromGutterIcon(editor, "GotoImplementation", logicalPosition);
                if (source.offset >= 0) {
                    source.source = TargetElementUtil.getInstance().findTargetElement(editor, ImplementationSearcher.getFlags(), source.offset);
                }
            }
            return source;
        })) == null || sourceElement.source == null) {
            return null;
        }
        return ReferenceResolver.createDataForSource(editor, sourceElement.offset, sourceElement.source);
    }

    public static int tryGetNavigationSourceOffsetFromGutterIcon(@NotNull Editor editor, String actionId, LogicalPosition logicalPosition) {
        if (editor == null) {
            ReferenceResolver.$$$reportNull$$$0(7);
        }
        int line = editor.logicalToVisualPosition((LogicalPosition)logicalPosition).line;
        List renderers = ((EditorGutterComponentEx)editor.getGutter()).getGutterRenderers(line);
        ArrayList elementCandidates = new ArrayList();
        for (GutterMark renderer : renderers) {
            LineMarkerInfo.LineMarkerGutterIconRenderer lineMarkerRenderer;
            AnAction clickAction;
            if (!(renderer instanceof LineMarkerInfo.LineMarkerGutterIconRenderer) || !((clickAction = (lineMarkerRenderer = (LineMarkerInfo.LineMarkerGutterIconRenderer)renderer).getClickAction()) instanceof NavigateAction) || !actionId.equals(((NavigateAction)clickAction).getOriginalActionId())) continue;
            ContainerUtil.addIfNotNull(elementCandidates, (Object)lineMarkerRenderer.getLineMarkerInfo().getElement());
        }
        if (elementCandidates.size() == 1) {
            return ((PsiElement)elementCandidates.get(0)).getTextRange().getStartOffset();
        }
        return -1;
    }

    @NotNull
    protected static GotoTargetHandler.GotoData createDataForSource(@NotNull Editor editor, int offset, PsiElement source) {
        PsiElement[] targets;
        if (editor == null) {
            ReferenceResolver.$$$reportNull$$$0(8);
        }
        if ((targets = ReferenceResolver.findTargets(editor, offset, source)) == null) {
            GotoTargetHandler.GotoData data = new GotoTargetHandler.GotoData(source, PsiElement.EMPTY_ARRAY, Collections.emptyList());
            data.isCanceled = true;
            GotoTargetHandler.GotoData gotoData = data;
            if (gotoData == null) {
                ReferenceResolver.$$$reportNull$$$0(9);
            }
            return gotoData;
        }
        return new GotoTargetHandler.GotoData(source, targets, Collections.emptyList());
    }

    protected static PsiElement @Nullable [] findTargets(@NotNull Editor editor, int offset, @NotNull PsiElement source) {
        if (editor == null) {
            ReferenceResolver.$$$reportNull$$$0(10);
        }
        if (source == null) {
            ReferenceResolver.$$$reportNull$$$0(11);
        }
        final PsiReference reference = (PsiReference)ApplicationManager.getApplication().runReadAction(() -> TargetElementUtil.findReference((Editor)editor, (int)offset));
        final TargetElementUtil instance = TargetElementUtil.getInstance();
        return new ImplementationSearcher.FirstImplementationsSearcher(){

            protected boolean accept(PsiElement element) {
                if (reference != null && !reference.getElement().isValid()) {
                    return false;
                }
                return instance.acceptImplementationForReference(reference, element);
            }

            protected boolean canShowPopupWithOneItem(PsiElement element) {
                return false;
            }
        }.searchImplementations(editor, source, offset);
    }

    public static CodeReferenceResult.CodeReferenceItem parseElement(PsiElement el) {
        StopWatch sw = new StopWatch();
        sw.start("getContainingFile");
        PsiFile psiFile = el.getContainingFile();
        long getContainingFileCost = sw.stop();
        if (psiFile == null) {
            return null;
        }
        sw.start("getVirtualFile");
        VirtualFile virtualFile = psiFile.getVirtualFile();
        long getVirtualFileCost = sw.stop();
        if (virtualFile == null) {
            return null;
        }
        sw.start("generateSignature");
        String content = SignatureUtil.generateSignature((PsiElement)psiFile);
        long generateSignatureCost = sw.stop();
        CodeReferenceResult.CodeReferenceItem item = new CodeReferenceResult.CodeReferenceItem();
        item.setContent(content);
        item.setFilePath(virtualFile.getPresentableUrl());
        logger.debug(String.format("parse element in file[%s], time cost(ms): getContainingFile[%d], getVirtualFile[%d], generateSignature[%d]", virtualFile.getPresentableUrl(), getContainingFileCost, getVirtualFileCost, generateSignatureCost));
        return item;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/alibabacloud/intellij/cosy/linguist/reference/ReferenceResolver";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/alibabacloud/intellij/cosy/linguist/reference/ReferenceResolver";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestCandidates";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createDataForSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findDeclarations";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doSelectCandidate";
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSourceAndTargetElements";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "tryGetNavigationSourceOffsetFromGutterIcon";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createDataForSource";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findTargets";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class SourceElement {
        PsiElement source;
        int offset;

        @Generated
        public SourceElement() {
        }

        @Generated
        public PsiElement getSource() {
            return this.source;
        }

        @Generated
        public int getOffset() {
            return this.offset;
        }

        @Generated
        public void setSource(PsiElement source) {
            this.source = source;
        }

        @Generated
        public void setOffset(int offset) {
            this.offset = offset;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SourceElement)) {
                return false;
            }
            SourceElement other = (SourceElement)o;
            if (!other.canEqual(this)) {
                return false;
            }
            PsiElement this$source = this.getSource();
            PsiElement other$source = other.getSource();
            if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
                return false;
            }
            return this.getOffset() == other.getOffset();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SourceElement;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            PsiElement $source = this.getSource();
            result = result * 59 + ($source == null ? 43 : $source.hashCode());
            result = result * 59 + this.getOffset();
            return result;
        }

        @Generated
        public String toString() {
            return "ReferenceResolver.SourceElement(source=" + this.getSource() + ", offset=" + this.getOffset() + ")";
        }
    }
}

