/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.linguist.provider;

import com.alibabacloud.intellij.cosy.linguist.model.ClassItem;
import com.alibabacloud.intellij.cosy.linguist.model.DefaultItem;
import com.alibabacloud.intellij.cosy.linguist.model.ItemBase;
import com.alibabacloud.intellij.cosy.linguist.provider.ProviderBase;
import com.alibabacloud.intellij.cosy.util.ProjectUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class AfterThrowNewProvider
implements ProviderBase {
    private static final Logger log = Logger.getInstance(AfterThrowNewProvider.class);
    static final ElementPattern<PsiElement> AFTER_THROW_NEW = PlatformPatterns.psiElement().afterLeaf((ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withText("new")).afterLeaf(new String[]{"throw"}));
    static final String ORIGIN = "AFTER_THROW_NEW";
    static final int PRIORITY = 2;

    @Override
    public boolean isApplicable(PsiElement psiElement) {
        return AFTER_THROW_NEW.accepts((Object)psiElement);
    }

    @Override
    public List<ItemBase> provide(Project project, final PsiElement psiElement) {
        long st = System.currentTimeMillis();
        List<String> potentialClasseNames = ProjectUtils.loadAllClassNames(project, psiElement.getText(), new Predicate<String>(){

            @Override
            public boolean test(String s) {
                return s.startsWith(psiElement.getText()) && s.endsWith("Exception");
            }
        });
        List<ItemBase> classList = potentialClasseNames.stream().map(n -> new ClassItem((String)n, null, ORIGIN, 2)).collect(Collectors.toList());
        if (classList.isEmpty()) {
            classList.add(new DefaultItem());
        }
        log.debug(String.format("AfterThrowNewProvider consumed %d ms", System.currentTimeMillis() - st));
        return classList;
    }

    @Override
    public String getOrigin() {
        return ORIGIN;
    }

    @Override
    public int getPriority() {
        return 2;
    }
}

