/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.linguist.processor;

import com.alibabacloud.intellij.cosy.linguist.processor.TextDocumentProcessorBase;
import com.alibabacloud.intellij.cosy.linguist.psi.model.resolved.CosyPsiVariable;
import com.alibabacloud.intellij.cosy.linguist.util.CosyPsiUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.Position;

public class ListVariablesProcessor
extends TextDocumentProcessorBase {
    private static final Logger log = Logger.getInstance(ListVariablesProcessor.class);

    public ListVariablesProcessor(String uri, Position position) {
        super(uri, position);
    }

    public List<CosyPsiVariable> list() {
        ArrayList<CosyPsiVariable> empty = new ArrayList<CosyPsiVariable>();
        ReadAction.run(this::initPsi);
        if (this.uri == null || this.project == null || this.psiFile == null || this.project.isDisposed()) {
            log.warn("uri == null || project == null || psiFile == null || project.isDisposed(), skip candidate analyze processor");
            return empty;
        }
        if (DumbService.isDumb((Project)this.project)) {
            log.warn("project is dumb, skip is inherits processor");
            return empty;
        }
        long st = System.currentTimeMillis();
        FutureTask<List> task = new FutureTask<List>(() -> {
            Editor editor = ((FileEditorManagerImpl)FileEditorManager.getInstance((Project)this.project)).getSelectedTextEditor(true);
            if (editor == null) {
                return empty;
            }
            int currentOffset = editor.getDocument().getLineEndOffset(this.row - 1) + this.col;
            PsiElement currentElement = PsiUtilCore.getElementAtOffset((PsiFile)this.psiFile, (int)currentOffset);
            if (currentElement == null) {
                return empty;
            }
            long varSt = System.currentTimeMillis();
            PsiVariable[] cosyPsiVariables = CosyPsiUtils.getVariablesWithTimeout(currentElement, false, 200L);
            if (cosyPsiVariables == null || cosyPsiVariables.length == 0) {
                return new ArrayList();
            }
            List result = Arrays.stream(cosyPsiVariables).limit(100L).map(v -> CosyPsiUtils.convertPsiVariable(v)).collect(Collectors.toList());
            return result;
        });
        ApplicationManager.getApplication().runReadAction(task);
        log.debug(String.format("List variables consumed %d ms", System.currentTimeMillis() - st));
        try {
            return (List)task.get();
        }
        catch (InterruptedException | ExecutionException e) {
            log.warn("List variables failed", (Throwable)e);
            return new ArrayList<CosyPsiVariable>();
        }
    }
}

