/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.linguist.processor;

import com.alibaba.fastjson.JSON;
import com.alibabacloud.intellij.cosy.linguist.enums.PsiDirection;
import com.alibabacloud.intellij.cosy.linguist.model.CandidateWithPsi;
import com.alibabacloud.intellij.cosy.linguist.processor.TextDocumentProcessorBase;
import com.alibabacloud.intellij.cosy.linguist.psi.core.CosyPsiManager;
import com.alibabacloud.intellij.cosy.linguist.psi.model.CosyPsiElement;
import com.alibabacloud.intellij.cosy.linguist.util.FileUtils;
import com.alibabacloud.intellij.cosy.linguist.util.LinguistPsiTreeUtils;
import com.alibabacloud.intellij.cosy.shared.cache.CacheManager;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

public class CandidateAnalyzeProcessor
extends TextDocumentProcessorBase {
    private static final Logger log = Logger.getInstance(CandidateAnalyzeProcessor.class);
    public static final int MAX_PSI_ROOT_LINE_COUNT = 3;
    List<TextEdit> candidates;

    public CandidateAnalyzeProcessor(List<TextEdit> candidates, String uri, Position position) {
        super(uri, position);
        this.candidates = candidates;
    }

    public List<CandidateWithPsi> analyze() {
        ArrayList<CandidateWithPsi> empty = new ArrayList<CandidateWithPsi>();
        ReadAction.run(this::initPsi);
        if (this.candidates == null || this.project == null || this.project.isDisposed()) {
            log.warn("candidates == null || project == null || project.isDisposed(), skip candidate analyze processor");
            return empty;
        }
        if (DumbService.isDumb((Project)this.project)) {
            log.warn("project is dumb, skip candidate analyze processor");
            return empty;
        }
        long finalSt = System.currentTimeMillis();
        FutureTask<List<CandidateWithPsi>> task = new FutureTask<List<CandidateWithPsi>>(new Callable<List<CandidateWithPsi>>(){

            @Override
            public List<CandidateWithPsi> call() {
                long st = System.currentTimeMillis();
                Editor editor = ((FileEditorManagerImpl)FileEditorManager.getInstance((Project)CandidateAnalyzeProcessor.this.project)).getSelectedTextEditor(true);
                Document document = editor.getDocument();
                ArrayList<ImmutablePair> newDocumentList = new ArrayList<ImmutablePair>();
                for (TextEdit candidate : CandidateAnalyzeProcessor.this.candidates) {
                    Range range = candidate.getRange();
                    String newText = candidate.getNewText();
                    int start = document.getLineStartOffset(range.getStart().getLine()) + range.getStart().getCharacter();
                    int end = document.getLineStartOffset(range.getEnd().getLine()) + range.getEnd().getCharacter();
                    newDocumentList.add(new ImmutablePair((Object)candidate, (Object)this.generateNewDocumentText(document, start, end, newText)));
                }
                CacheManager.getVariableClassCache().setCurrentFilePath(CandidateAnalyzeProcessor.this.uri);
                List<CandidateWithPsi> result = newDocumentList.parallelStream().map(pair -> {
                    TextEdit textEdit = (TextEdit)pair.getLeft();
                    String newDocumentText = (String)pair.getRight();
                    Range range = textEdit.getRange();
                    String newText = textEdit.getNewText();
                    int leftOffset = document.getLineStartOffset(CandidateAnalyzeProcessor.this.row);
                    int start = leftOffset + range.getStart().getCharacter();
                    int rightOffset = start + newText.length();
                    String cacheKey = String.format("%s:%d:%s", CandidateAnalyzeProcessor.this.uri, CandidateAnalyzeProcessor.this.row, newText);
                    Optional optionalCosyRoot = CacheManager.getCosyPsiTreeCache().get(cacheKey);
                    if (optionalCosyRoot.isPresent()) {
                        log.info("cosy root cache hit for " + cacheKey);
                        return new CandidateWithPsi(newText, (CosyPsiElement)optionalCosyRoot.get());
                    }
                    CosyPsiElement cosyRoot = (CosyPsiElement)ApplicationManager.getApplication().runReadAction((Computable)new CosyRootComputer(CandidateAnalyzeProcessor.this.project, leftOffset, rightOffset, newText, newDocumentText, cacheKey));
                    if (cosyRoot == null) {
                        return null;
                    }
                    return new CandidateWithPsi(newText, cosyRoot);
                }).filter(Objects::nonNull).collect(Collectors.toList());
                return result;
            }

            private String generateNewDocumentText(Document document, int start, int end, String newText) {
                return document.getText(new TextRange(0, start)) + newText + document.getText(new TextRange(end, document.getTextLength()));
            }
        });
        ApplicationManager.getApplication().invokeLater(task);
        try {
            return (List)task.get();
        }
        catch (InterruptedException | ExecutionException e) {
            log.info("Get candidate analyze failed", (Throwable)e);
            return new ArrayList<CandidateWithPsi>();
        }
    }

    public static class CosyRootComputer
    implements Computable<CosyPsiElement> {
        Project project;
        int leftOffset;
        int rightOffset;
        String newText;
        String newDocumentText;
        String cacheKey;

        public CosyRootComputer(Project project, int leftOffset, int rightOffset, String newText, String newDocumentText, String cacheKey) {
            this.project = project;
            this.leftOffset = leftOffset;
            this.rightOffset = rightOffset;
            this.newText = newText;
            this.newDocumentText = newDocumentText;
            this.cacheKey = cacheKey;
        }

        public CosyPsiElement compute() {
            long currentCandidateSt = System.currentTimeMillis();
            PsiFile dummyFile = PsiFileFactory.getInstance((Project)this.project).createFileFromText(FileUtils.generateDummyFileName(), (FileType)JavaFileType.INSTANCE, (CharSequence)this.newDocumentText);
            ArrayList<TextRange> validRange = new ArrayList<TextRange>();
            validRange.add(new TextRange(this.leftOffset, this.rightOffset));
            PsiElement startElement = LinguistPsiTreeUtils.findClosestNonWhitespaceElement(PsiUtilCore.getElementAtOffset((PsiFile)dummyFile, (int)this.leftOffset), PsiDirection.RIGHT, validRange);
            PsiElement endElement = LinguistPsiTreeUtils.findClosestNonWhitespaceElement(PsiUtilCore.getElementAtOffset((PsiFile)dummyFile, (int)this.rightOffset), PsiDirection.LEFT, validRange);
            PsiElement lcaRoot = LinguistPsiTreeUtils.findLowestCommonAncestor(dummyFile.getNode().getPsi(), startElement, endElement);
            if (StringUtils.countMatches((CharSequence)lcaRoot.getText(), (CharSequence)"\n") > 3) {
                return null;
            }
            CosyPsiElement cosyRoot = this.convertCosyTreeWithTimeout(lcaRoot, this.cacheKey);
            if (log.isDebugEnabled()) {
                log.debug("########TREE########");
                log.debug(lcaRoot.getText());
                log.debug(this.newText);
                LinguistPsiTreeUtils.prettyPrintPsiTree(lcaRoot);
                log.debug(JSON.toJSONString((Object)cosyRoot));
                log.debug(String.format("Item %s consumed:%dms", lcaRoot.getText(), System.currentTimeMillis() - currentCandidateSt));
                log.debug("########ENDTREE########");
            }
            return cosyRoot;
        }

        public CosyPsiElement convertCosyTreeWithTimeout(PsiElement lcaRoot, String cacheKey) {
            Callable<CosyPsiElement> convertTask = () -> (CosyPsiElement)ApplicationManager.getApplication().runReadAction(() -> CosyPsiManager.convertToCosyPsiElement(lcaRoot, cacheKey));
            Future convertFuture = ApplicationManager.getApplication().executeOnPooledThread(convertTask);
            CosyPsiElement result = null;
            try {
                result = (CosyPsiElement)convertFuture.get(100L, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException timeoutException) {
                log.warn("Convert candidate timeout");
            }
            catch (Exception e) {
                log.warn("Convert candidate failed", (Throwable)e);
            }
            return result;
        }

        public CosyPsiElement get() {
            return (CosyPsiElement)super.get();
        }
    }
}

