/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.layout;

import com.alibabacloud.intellij.cosy.layout.WrappedFlowLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class ChatContextTagLayout
extends WrappedFlowLayout {
    private int minRowHeight = 0;

    public ChatContextTagLayout(int hGap, int vGap) {
        super(hGap, vGap);
    }

    public ChatContextTagLayout(int hGap, int vGap, int minRowHeight) {
        super(hGap, vGap);
        this.minRowHeight = minRowHeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension getDimension(Container target, int maxWidth) {
        Insets insets = target.getInsets();
        int height = insets.top + insets.bottom;
        int width = insets.left + insets.right;
        int rowHeight = 0;
        int rowWidth = insets.left + insets.right;
        boolean isVisible = false;
        boolean start = true;
        boolean first = true;
        Object object = target.getTreeLock();
        synchronized (object) {
            for (int i = 0; i < target.getComponentCount(); ++i) {
                Component component = target.getComponent(i);
                if (!component.isVisible()) continue;
                isVisible = true;
                Dimension size = component.getPreferredSize();
                if (!first) {
                    rowWidth += this.getHgap();
                } else {
                    first = false;
                }
                int newWidth = size.width;
                if (component instanceof JTextArea && ((JTextArea)component).getLineCount() > 1) {
                    newWidth = maxWidth - rowWidth;
                }
                if (rowWidth + newWidth >= maxWidth && !start) {
                    height += this.getVgap() + rowHeight;
                    width = Math.max(width, rowWidth);
                    rowWidth = insets.left + insets.right;
                    rowHeight = 0;
                    first = true;
                }
                rowHeight = Math.max(rowHeight, size.height);
                rowHeight = Math.max(rowHeight, this.minRowHeight);
                rowWidth += newWidth;
                start = false;
            }
            width = Math.max(width, rowWidth);
            Dimension dim = null;
            dim = new Dimension(width, height += rowHeight);
            return dim;
        }
    }

    @Override
    public Dimension getWrappedSize(Container target) {
        Container parent = SwingUtilities.getUnwrappedParent(target);
        int maxWidth = parent.getWidth() - (parent.getInsets().left + parent.getInsets().right);
        return this.getDimension(target, maxWidth);
    }

    private int moveComponents(Container target, int x, int y, int width, int height, int rowStart, int rowEnd, boolean ltr, boolean useBaseline, int[] ascent, int[] descent) {
        switch (this.getAlignment()) {
            case 0: {
                x += ltr ? 0 : width;
                break;
            }
            case 1: {
                x += width / 2;
                break;
            }
            case 2: {
                x += ltr ? width : 0;
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                x += width;
            }
        }
        int maxAscent = 0;
        int nonbaselineHeight = 0;
        int baselineOffset = 0;
        if (useBaseline) {
            int maxDescent = 0;
            for (int i = rowStart; i < rowEnd; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                if (ascent[i] >= 0) {
                    maxAscent = Math.max(maxAscent, ascent[i]);
                    maxDescent = Math.max(maxDescent, descent[i]);
                    continue;
                }
                nonbaselineHeight = Math.max(m.getHeight(), nonbaselineHeight);
            }
            height = Math.max(maxAscent + maxDescent, nonbaselineHeight);
            baselineOffset = (height - maxAscent - maxDescent) / 2;
        }
        for (int i = rowStart; i < rowEnd; ++i) {
            Component m = target.getComponent(i);
            if (!m.isVisible()) continue;
            int cy = useBaseline && ascent[i] >= 0 ? y + baselineOffset + maxAscent - ascent[i] : y + (height - m.getHeight()) / 2;
            if (ltr) {
                m.setLocation(x, cy);
            } else {
                m.setLocation(target.getWidth() - x - m.getWidth(), cy);
            }
            x += m.getWidth() + this.getHgap();
        }
        return height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Insets insets = target.getInsets();
            int maxwidth = target.getWidth() - (insets.left + insets.right);
            int nmembers = target.getComponentCount();
            int x = 0;
            int y = insets.top;
            int rowh = 0;
            int start = 0;
            boolean ltr = target.getComponentOrientation().isLeftToRight();
            boolean useBaseline = this.getAlignOnBaseline();
            int[] ascent = null;
            int[] descent = null;
            if (useBaseline) {
                ascent = new int[nmembers];
                descent = new int[nmembers];
            }
            for (int i = 0; i < nmembers; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                Dimension d = m.getPreferredSize();
                int originWidth = d.width;
                if (d.width >= maxwidth - x - this.getHgap()) {
                    originWidth = d.width = Math.min(maxwidth, d.width);
                }
                m.setSize(d.width, d.height);
                if (useBaseline) {
                    int baseline = m.getBaseline(d.width, d.height);
                    if (baseline >= 0) {
                        ascent[i] = baseline;
                        descent[i] = d.height - baseline;
                    } else {
                        ascent[i] = -1;
                    }
                }
                if (x > 0) {
                    x += this.getHgap();
                }
                if (x == 0 || x + originWidth <= maxwidth) {
                    x += d.width;
                    rowh = Math.max(rowh, d.height);
                    rowh = Math.max(rowh, this.minRowHeight);
                    continue;
                }
                rowh = this.moveComponents(target, insets.left, y, maxwidth - x, rowh, start, i, ltr, useBaseline, ascent, descent);
                x = d.width;
                y += this.getVgap() + rowh;
                rowh = d.height;
                rowh = Math.max(rowh, this.minRowHeight);
                start = i;
            }
            this.moveComponents(target, insets.left, y, maxwidth - x, rowh, start, nmembers, ltr, useBaseline, ascent, descent);
        }
    }
}

