/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.handle;

import com.alibabacloud.intellij.cosy.handle.ResourceHandlerState;
import java.io.IOException;
import java.io.InputStream;
import org.cef.callback.CefCallback;
import org.cef.misc.IntRef;
import org.cef.misc.StringRef;
import org.cef.network.CefRequest;
import org.cef.network.CefResponse;

public class OpenedConnection
implements ResourceHandlerState {
    private CefRequest.ResourceType resourceType;
    private String path;
    private InputStream inputStream;

    public OpenedConnection(String path, CefRequest.ResourceType resourceType) throws IOException {
        this.path = path;
        this.inputStream = this.getClass().getClassLoader().getResourceAsStream(path);
        this.resourceType = resourceType;
    }

    @Override
    public void getResponseHeaders(CefResponse paramCefResponse, IntRef paramIntRef, StringRef paramStringRef) {
        if (this.inputStream == null) {
            paramCefResponse.setStatus(404);
            return;
        }
        paramCefResponse.setStatus(200);
        paramCefResponse.setMimeType(this.getMimeType());
        try {
            paramIntRef.set(this.inputStream.available());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Boolean readResponse(byte[] arrayOfByte, int paramInt, IntRef intRef, CefCallback callback) throws IOException {
        int availableSize = this.inputStream.available();
        if (availableSize > 0) {
            int maxBytesToRead = Math.min(availableSize, paramInt);
            int realNumberOfReadBytes = this.inputStream.read(arrayOfByte, 0, maxBytesToRead);
            intRef.set(realNumberOfReadBytes);
            return true;
        }
        this.inputStream.close();
        return false;
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    private String getMimeType() {
        switch (this.resourceType) {
            case RT_MAIN_FRAME: {
                return "text/html";
            }
            case RT_SCRIPT: {
                return "text/javascript";
            }
            case RT_STYLESHEET: {
                return "text/css";
            }
            case RT_IMAGE: {
                if (this.path.endsWith("svg")) {
                    return "image/svg+xml";
                }
                return "image/png";
            }
        }
        return "text/plain";
    }
}

