/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.handle;

import com.alibabacloud.intellij.cosy.handle.ClosedConnection;
import com.alibabacloud.intellij.cosy.handle.OpenedConnection;
import com.alibabacloud.intellij.cosy.handle.ResourceHandlerState;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import org.cef.callback.CefCallback;
import org.cef.handler.CefResourceHandler;
import org.cef.misc.IntRef;
import org.cef.misc.StringRef;
import org.cef.network.CefRequest;
import org.cef.network.CefResponse;

public class CustomResourceHandler
implements CefResourceHandler {
    private static final Logger LOGGER = Logger.getInstance(CustomResourceHandler.class);
    private ResourceHandlerState state = new ClosedConnection();
    private String path;

    public CustomResourceHandler(String path) {
        this.path = path;
    }

    public boolean processRequest(CefRequest cefRequest, CefCallback cefCallback) {
        try {
            CefRequest.ResourceType resourceType = cefRequest.getResourceType();
            this.state = new OpenedConnection(this.path, resourceType);
            cefCallback.Continue();
            return true;
        }
        catch (IOException e) {
            LOGGER.warn("processRequest error ", (Throwable)e);
            return false;
        }
    }

    public void getResponseHeaders(CefResponse cefResponse, IntRef intRef, StringRef stringRef) {
        this.state.getResponseHeaders(cefResponse, intRef, stringRef);
    }

    public boolean readResponse(byte[] bytes, int i, IntRef intRef, CefCallback cefCallback) {
        try {
            return this.state.readResponse(bytes, i, intRef, cefCallback);
        }
        catch (IOException e) {
            LOGGER.warn("readResponse error ", (Throwable)e);
            return false;
        }
    }

    public void cancel() {
        try {
            this.state.close();
            this.state = new ClosedConnection();
        }
        catch (IOException e) {
            LOGGER.warn("cancel error ", (Throwable)e);
        }
    }
}

