/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.handle;

import com.alibaba.fastjson.JSONObject;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.ChatModeItem;
import com.alibabacloud.intellij.cosy.ui.config.CosyConfigurable;
import com.alibabacloud.intellij.cosy.ui.search.LingmaToolWindowPanel;
import com.alibabacloud.intellij.cosy.ui.search.enums.ChatMode;
import com.alibabacloud.intellij.cosy.ui.search.generate.AskInputPanel;
import com.alibabacloud.intellij.cosy.ui.search.generate.input.ChatInputOperationPanel;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.util.FileUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.callback.CefQueryCallback;
import org.cef.handler.CefMessageRouterHandlerAdapter;

public class CefMessageRouterHandler
extends CefMessageRouterHandlerAdapter {
    private static final Logger log = Logger.getInstance(CefMessageRouterHandler.class);
    private static final String MSG_TYPE_BACK_TO_CHAT = "MSG_BACK_TO_CHAT";
    private static final String MSG_TYPE_OPEN_MCP_CONFIG = "MSG_TYPE_OPEN_MCP_CONFIG";
    private static final String MSG_TYPE_FIX_MCP_ERROR = "MSG_TYPE_FIX_MCP_ERROR";
    private static final String MSG_TYPE_EXPERIENCE_MCP_CASE = "MSG_TYPE_EXPERIENCE_MCP_CASE";
    private static final String MSG_TYPE_BACK_TO_SETTING = "MSG_BACK_TO_SETTING";
    private static final String MSG_TYPE_OPERATE_RULE_FILE = "MSG_TYPE_OPERATE_RULE_FILE";
    private static final String MSG_TYPE_OPEN_INDEX_IGNORE_CONFIG = "MSG_TYPE_OPEN_INDEX_IGNORE_CONFIG";
    private Project project;
    private LingmaToolWindowPanel toolWindowPanel;

    public CefMessageRouterHandler(Project project, LingmaToolWindowPanel toolWindowPanel) {
        this.project = project;
        this.toolWindowPanel = toolWindowPanel;
    }

    public boolean onQuery(CefBrowser cefBrowser, CefFrame cefFrame, long queryId, String request, boolean persistent, CefQueryCallback callback) {
        JSONObject requestObject = JSONObject.parseObject((String)request);
        if (requestObject == null) {
            return false;
        }
        String type = requestObject.getString("type");
        if (StringUtils.isBlank((CharSequence)type)) {
            return false;
        }
        log.info("CefMessageRouterHandler onQuery,requestObject=" + JSONObject.toJSONString((Object)requestObject) + ". project: " + this.project.getName() + ", disposed: " + this.project.isDisposed());
        switch (type) {
            case "MSG_BACK_TO_CHAT": {
                this.handleBackToChat();
                return true;
            }
            case "MSG_TYPE_OPEN_MCP_CONFIG": {
                return this.handleOpenFile(requestObject);
            }
            case "MSG_TYPE_OPERATE_RULE_FILE": {
                return this.handleOperateRuleFile(requestObject);
            }
            case "MSG_TYPE_FIX_MCP_ERROR": {
                SwingUtilities.invokeLater(() -> this.handleMcpQuickFix(requestObject));
                return true;
            }
            case "MSG_TYPE_EXPERIENCE_MCP_CASE": {
                this.handleMcpQuickExperience(requestObject);
                return true;
            }
            case "MSG_BACK_TO_SETTING": {
                SwingUtilities.invokeLater(() -> ShowSettingsUtil.getInstance().showSettingsDialog(this.project, CosyConfigurable.class));
                return true;
            }
            case "MSG_TYPE_OPEN_INDEX_IGNORE_CONFIG": {
                return this.handleOperateIndexIgnoreFile(requestObject);
            }
        }
        return false;
    }

    private void handleBackToChat() {
        SwingUtilities.invokeLater(() -> {
            this.toolWindowPanel.clearBrowserContent();
            this.toolWindowPanel.switchChatPanel(this.toolWindowPanel.getCurrentChatPanel());
        });
    }

    private boolean handleOperateIndexIgnoreFile(JSONObject requestObject) {
        if (null == this.project || StringUtils.isEmpty((CharSequence)this.project.getBasePath())) {
            log.warn("no project opened or invalid project base path");
            return false;
        }
        String separator = FileUtil.getFileSeparator(this.project.getBasePath());
        String dirPath = this.project.getBasePath();
        VirtualFile dirFile = FileUtil.getDirectoryVirtualFileByPath(dirPath);
        if (null != dirFile) {
            JSONObject message = requestObject.getJSONObject("message");
            if (message == null) {
                return false;
            }
            String filePath = message.getString("filePath");
            if (StringUtils.isBlank((CharSequence)filePath)) {
                log.warn("handleOperateIndexIgnoreFile filePath is empty or null");
                return false;
            }
            return (Boolean)WriteCommandAction.runWriteCommandAction((Project)this.project, () -> {
                Object[] fileEditors;
                String filepath = dirPath + separator + filePath;
                VirtualFile file = LocalFileSystem.getInstance().findFileByPath(filepath);
                if (null == file) {
                    try {
                        file = dirFile.createChildData((Object)dirFile, filePath);
                        Document document = FileDocumentManager.getInstance().getDocument(file);
                        if (document != null) {
                            document.setText((CharSequence)CosyBundle.message("settings.index.ignore.file.tips", new Object[0]));
                        }
                    }
                    catch (IOException ex) {
                        log.warn("create index ignore file failed", (Throwable)ex);
                        return false;
                    }
                }
                if (ArrayUtils.isEmpty((Object[])(fileEditors = FileEditorManager.getInstance((Project)this.project).openFile(file, true, true)))) {
                    log.warn("open fileEditors failed, empty tabs");
                }
                return true;
            });
        }
        log.warn("invalid project directory failed");
        return false;
    }

    private boolean handleOperateRuleFile(JSONObject requestObject) {
        JSONObject message = requestObject.getJSONObject("message");
        if (message == null) {
            return false;
        }
        String filePath = message.getString("filePath");
        if (StringUtils.isBlank((CharSequence)filePath)) {
            log.warn("handleOperateRuleFile filePath is empty or null");
            return false;
        }
        String operation = message.getString("operation");
        if (StringUtils.isBlank((CharSequence)operation)) {
            log.warn("handleOperateRuleFile operation is empty or null");
            return false;
        }
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(filePath);
        if ("delete".equals(operation)) {
            VirtualFile parent;
            if (virtualFile != null && (parent = virtualFile.getParent()) != null) {
                VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{parent});
            }
        } else if ("edit".equals(operation)) {
            VirtualFile parent;
            if (null != virtualFile && (parent = virtualFile.getParent()) != null) {
                ApplicationManager.getApplication().invokeLater(() -> VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{parent}));
            }
            this.openFile(virtualFile);
        } else {
            this.openFile(virtualFile);
        }
        return true;
    }

    private boolean handleOpenFile(JSONObject requestObject) {
        JSONObject message = requestObject.getJSONObject("message");
        if (message == null) {
            return false;
        }
        String filePath = message.getString("filePath");
        if (StringUtils.isBlank((CharSequence)filePath)) {
            log.warn("handleOpenFile filePath is empty or null");
            return false;
        }
        File file = new File(filePath);
        if (!file.exists() || !file.isFile()) {
            log.warn("handleOpenFile filePath is not exist or not a file");
            return false;
        }
        return this.openFile(LocalFileSystem.getInstance().refreshAndFindFileByPath(filePath));
    }

    private boolean openFile(VirtualFile virtualFile) {
        if (virtualFile == null) {
            log.warn("handleOpenFile virtualFile is null");
            return false;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            Object[] fileEditors = FileEditorManager.getInstance((Project)this.project).openFile(virtualFile, true);
            if (ArrayUtils.isEmpty((Object[])fileEditors)) {
                log.warn("no files to open. path: " + virtualFile.getPath());
            }
        }, ModalityState.NON_MODAL);
        return true;
    }

    private void handleMcpQuickFix(JSONObject requestObject) {
        JSONObject message = requestObject.getJSONObject("message");
        if (message == null) {
            return;
        }
        String content = message.getString("content");
        if (StringUtils.isBlank((CharSequence)content)) {
            return;
        }
        AskInputPanel inputPanel = this.toolWindowPanel.getCurrentChatPanel().getInputPanel();
        if (inputPanel == null) {
            log.warn("handleMcpQuickFix inputPanel is null");
            return;
        }
        this.toolWindowPanel.switchChatPanel(this.toolWindowPanel.getCurrentChatPanel());
        String mode = inputPanel.getChatMode();
        if (!ChatMode.AGENT.getMode().equals(mode)) {
            ChatInputOperationPanel inputOperationPanel = inputPanel.getInputOperationPanel();
            if (inputOperationPanel == null) {
                log.warn("handleMcpQuickFix inputOperationPanel is null");
                return;
            }
            inputOperationPanel.getModeChooser().onModeSelected(new ChatModeItem(ChatMode.AGENT.getMode()));
        }
        inputPanel.setText(content);
    }

    private void handleMcpQuickExperience(JSONObject requestObject) {
        JSONObject message = requestObject.getJSONObject("message");
        if (message == null) {
            return;
        }
        String content = message.getString("content");
        if (StringUtils.isBlank((CharSequence)content)) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            this.toolWindowPanel.switchChatPanel(this.toolWindowPanel.getCurrentChatPanel());
            this.toolWindowPanel.createNewChatDirectly();
            this.toolWindowPanel.getCurrentChatPanel().stopSessionChatSync();
            AskInputPanel inputPanel = this.toolWindowPanel.getCurrentChatPanel().getInputPanel();
            if (inputPanel == null) {
                log.warn("handleMcpQuickExperience inputPanel is null");
                return;
            }
            String mode = inputPanel.getChatMode();
            if (!ChatMode.AGENT.getMode().equals(mode)) {
                ChatInputOperationPanel inputOperationPanel = inputPanel.getInputOperationPanel();
                if (inputOperationPanel == null) {
                    log.warn("handleMcpQuickExperience inputOperationPanel is null");
                    return;
                }
                inputOperationPanel.getModeChooser().onModeSelected(new ChatModeItem(ChatMode.AGENT.getMode()));
            }
            inputPanel.setText(content);
            inputPanel.doSendMessage();
        });
    }
}

