/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.editor.request;

import com.alibabacloud.intellij.cosy.common.CosyCacheKeys;
import com.alibabacloud.intellij.cosy.common.CosySetting;
import com.alibabacloud.intellij.cosy.concurrent.InlineEditActionProcessor;
import com.alibabacloud.intellij.cosy.core.Cosy;
import com.alibabacloud.intellij.cosy.core.lsp.LanguageWebSocketService;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.InlineEditResult;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.DiagnosticInfo;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.InlineEditParams;
import com.alibabacloud.intellij.cosy.editor.cache.InlineEditCache;
import com.alibabacloud.intellij.cosy.editor.model.InlineEditRequest;
import com.alibabacloud.intellij.cosy.editor.model.InlineEditSession;
import com.alibabacloud.intellij.cosy.editor.request.DelayStrategy;
import com.alibabacloud.intellij.cosy.editor.request.RuleBaseDelayStrategy;
import com.alibabacloud.intellij.cosy.editor.request.TypeSpeedDelayStrategy;
import com.alibabacloud.intellij.cosy.search.asyn.Debouncer;
import com.alibabacloud.intellij.cosy.search.enums.InlineTriggerModeEnum;
import com.alibabacloud.intellij.cosy.service.TelemetryService;
import com.alibabacloud.intellij.cosy.service.model.Features;
import com.alibabacloud.intellij.cosy.ui.config.CosyPersistentSetting;
import com.alibabacloud.intellij.cosy.ui.statusbar.CosyStatusBarWidget;
import com.alibabacloud.intellij.cosy.util.CompletionUtil;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.jetbrains.annotations.NotNull;

public class InlineEditRequestBuilder {
    private static final Logger LOGGER = Logger.getInstance(InlineEditRequestBuilder.class);
    private static final int MAX_DIAGNOSTICS_COUNT = 50;
    private static final long REQUEST_TIMEOUT = 5000L;

    public static InlineEditRequestBuilder build() {
        return new InlineEditRequestBuilder();
    }

    public void generate(@NotNull Editor editor, int cursorOffset, InlineTriggerModeEnum triggerMode) {
        if (editor == null) {
            InlineEditRequestBuilder.$$$reportNull$$$0(0);
        }
        CosySetting settings = CosyPersistentSetting.getInstance().getState();
        Project project = editor.getProject();
        if (project == null) {
            return;
        }
        if (!Cosy.INSTANCE.checkCosy(project, true)) {
            return;
        }
        if (editor.getDocument().getTextLength() > 5000000 || StringUtils.isBlank((CharSequence)editor.getDocument().getText())) {
            LOGGER.warn("file content is too long, skip inline edit");
            return;
        }
        InlineEditSession session = this.getSession(project, triggerMode, editor);
        boolean isComment = com.alibabacloud.intellij.cosy.util.EditorUtil.isCaretInComment(editor);
        DelayStrategy delayStrategy = this.getDelayStrategy();
        long delayTime = delayStrategy.calculateDelay(settings, editor, triggerMode.getName(), isComment);
        if (InlineTriggerModeEnum.TYPING.getName().equals(triggerMode.getName()) || InlineTriggerModeEnum.LOOKUP.getName().equals(triggerMode.getName())) {
            CompletionUtil.triggerPreCompletion(editor, delayTime);
        }
        try {
            Debouncer inlineEditDebouncer = Cosy.INSTANCE.getLanguageService(project).getInlayCompletionDebouncer();
            inlineEditDebouncer.debounce(() -> {
                try {
                    InlineEditParams params = this.createInlineEditParams(editor, cursorOffset, triggerMode);
                    InlineEditRequest request = new InlineEditRequest(params, editor, cursorOffset);
                    request.setComment(isComment);
                    request.setTriggerDelayTime(delayTime);
                    request.setTriggerMode(triggerMode);
                    InlineEditRequest prevRequest = session.getLastRequest();
                    session.addRequest(request);
                    InlineEditCache.recordNesLineContentChangeCache(editor.getDocument(), params.getPosition().getLine());
                    CosyStatusBarWidget.setStatusBarGenerating(project, true, false);
                    InlineEditResult result = this.sendInlineEditRequest(editor, request);
                    if (result == null || !result.isSuccess()) {
                        if (InlineTriggerModeEnum.CURSOR.getName().equals(triggerMode.getName())) {
                            com.alibabacloud.intellij.cosy.util.EditorUtil.runInEdt(() -> CompletionUtil.triggerCursorPreCompletion(editor));
                        }
                        CosyStatusBarWidget.setStatusBarGenerating(project, false, false);
                        LOGGER.warn("Inline edit request failed or empty result: " + (result != null ? result.getMessage() : "null result"));
                    } else {
                        TelemetryService.getInstance().triggerInlineEdit(request.getTriggerMode(), editor, request, prevRequest);
                        CosyStatusBarWidget.setStatusBarGenerating(project, false, true);
                        LOGGER.info("Inline edit request succeeded: " + request.getRequestId());
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to generate inline edit request: " + e.getMessage(), (Throwable)e);
                    CosyStatusBarWidget.setStatusBarGenerating(project, false, false);
                }
            }, delayTime, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to schedule inline edit request: " + e.getMessage(), (Throwable)e);
            CosyStatusBarWidget.setStatusBarGenerating(project, false, false);
        }
    }

    public InlineEditResult sendInlineEditRequest(@NotNull Editor editor, InlineEditRequest request) {
        Project project;
        if (editor == null) {
            InlineEditRequestBuilder.$$$reportNull$$$0(1);
        }
        if ((project = editor.getProject()) == null) {
            return null;
        }
        LanguageWebSocketService service = Cosy.INSTANCE.getLanguageService(project);
        if (service == null || !service.isSessionOpen()) {
            LOGGER.warn("Language service not available");
            return null;
        }
        try {
            InlineEditActionProcessor.INSTANCE.triggerNextConsumption(true);
            LOGGER.debug("Sending inline edit request: " + request.getRequestId());
            CompletableFuture<InlineEditResult> future = service.getServer().getTextDocumentService().inlineEdit(request.getParams());
            return future.get(5000L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to send inline edit request: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InlineEditSession getSession(Project project, InlineTriggerModeEnum triggerMode, Editor editor) {
        InlineEditSession session;
        Key<InlineEditSession> key = CosyCacheKeys.KEY_INLINE_EDIT_SESSION;
        synchronized (key) {
            session = (InlineEditSession)CosyCacheKeys.KEY_INLINE_EDIT_SESSION.get((UserDataHolder)project);
            if (session == null || InlineTriggerModeEnum.CURSOR.getName().equals(triggerMode.getName()) || InlineTriggerModeEnum.TYPING.getName().equals(triggerMode.getName()) || InlineTriggerModeEnum.LOOKUP.getName().equals(triggerMode.getName())) {
                session = this.buildNewSession(editor);
            }
        }
        return session;
    }

    private InlineEditSession buildNewSession(Editor editor) {
        Project project = editor.getProject();
        InlineEditSession session = (InlineEditSession)CosyCacheKeys.KEY_INLINE_EDIT_SESSION.get((UserDataHolder)project);
        if (session != null) {
            Disposer.dispose((Disposable)session);
        }
        session = new InlineEditSession();
        EditorUtil.disposeWithEditor((Editor)editor, (Disposable)session);
        CosyCacheKeys.KEY_INLINE_EDIT_SESSION.set((UserDataHolder)project, (Object)session);
        return session;
    }

    public InlineEditParams createInlineEditParams(@NotNull Editor editor, int cursorOffset, InlineTriggerModeEnum triggerMode) {
        Project project;
        if (editor == null) {
            InlineEditRequestBuilder.$$$reportNull$$$0(2);
        }
        if ((project = editor.getProject()) == null) {
            return null;
        }
        String fileContent = editor.getDocument().getText();
        int line = editor.getDocument().getLineNumber(cursorOffset);
        int column = cursorOffset - editor.getDocument().getLineStartOffset(line);
        InlineEditParams params = new InlineEditParams();
        params.setRequestId(UUID.randomUUID().toString());
        params.setFileContent(fileContent);
        params.setPosition(new Position(line, column));
        params.setVersion("2");
        String filePath = com.alibabacloud.intellij.cosy.util.EditorUtil.getEditorFilePath(editor);
        params.setTextDocument(new TextDocumentIdentifier(filePath));
        params.setTrigger(triggerMode.getName());
        ApplicationManager.getApplication().runReadAction(() -> {
            params.setTabWidth(editor.getSettings().getTabSize(project));
            params.setTabChar(editor.getSettings().isUseTabCharacter(project) ? "\t" : " ");
        });
        params.setDiagnostics(this.getDiagnostics(editor, cursorOffset));
        return params;
    }

    public List<DiagnosticInfo> getDiagnostics(@NotNull Editor editor, int cursorOffset) {
        Project project;
        if (editor == null) {
            InlineEditRequestBuilder.$$$reportNull$$$0(3);
        }
        if ((project = editor.getProject()) == null) {
            return Collections.emptyList();
        }
        VirtualFile file = FileDocumentManager.getInstance().getFile(editor.getDocument());
        if (file == null) {
            return Collections.emptyList();
        }
        long startTime = System.currentTimeMillis();
        int currentLine = editor.getDocument().getLineNumber(cursorOffset);
        List<DiagnosticInfo> diagnostics = new ArrayList<DiagnosticInfo>();
        try {
            List<HighlightInfo> highlightInfos = com.alibabacloud.intellij.cosy.util.EditorUtil.getDiagnostics(editor);
            LOGGER.debug("Get error highlight count: " + highlightInfos.size());
            for (HighlightInfo highlight : highlightInfos) {
                if (!highlight.getSeverity().equals((Object)HighlightSeverity.ERROR)) continue;
                int startOffset = highlight.getStartOffset();
                int endOffset = highlight.getEndOffset();
                int startLine = editor.getDocument().getLineNumber(startOffset);
                int endLine = editor.getDocument().getLineNumber(endOffset);
                DiagnosticInfo diagnostic = new DiagnosticInfo();
                diagnostic.setSeverity("ERROR");
                diagnostic.setMessage(highlight.getDescription());
                diagnostic.setFilePath(file.getPath());
                Range range = new Range();
                range.setStart(new Position(startLine, editor.getDocument().getLineStartOffset(startLine)));
                range.setEnd(new Position(endLine, editor.getDocument().getLineEndOffset(endLine)));
                diagnostic.setRange(range);
                String lineContent = com.alibabacloud.intellij.cosy.util.EditorUtil.getLineTextByOffset(editor.getDocument(), startOffset);
                diagnostic.setContent(lineContent);
                diagnostics.add(diagnostic);
            }
            diagnostics.sort(Comparator.comparingInt(d -> Math.abs(currentLine - d.getRange().getStart().getLine())));
            if (diagnostics.size() > 50) {
                diagnostics = diagnostics.subList(0, 50);
            }
            LOGGER.info("Get diagnostics count:" + diagnostics.size() + " cost: " + (System.currentTimeMillis() - startTime) + "ms");
        }
        catch (Exception e) {
            LOGGER.warn("Failed to get diagnostics: " + e.getMessage(), (Throwable)e);
        }
        return diagnostics;
    }

    private DelayStrategy getDelayStrategy() {
        String delayStrategy = Features.COMPLETION_AUTO_DELAY_STRATEGY.stringValue();
        if (StringUtils.isBlank((CharSequence)delayStrategy) || "default".equals(delayStrategy)) {
            return new RuleBaseDelayStrategy();
        }
        if ("TypeSpeed".equals(delayStrategy)) {
            return new TypeSpeedDelayStrategy();
        }
        return new RuleBaseDelayStrategy();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "editor";
        objectArray2[1] = "com/alibabacloud/intellij/cosy/editor/request/InlineEditRequestBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "generate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "sendInlineEditRequest";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createInlineEditParams";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getDiagnostics";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

