/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.editor.request;

import com.alibabacloud.intellij.cosy.common.CosyCacheKeys;
import com.alibabacloud.intellij.cosy.common.CosySetting;
import com.alibabacloud.intellij.cosy.completion.CosyCompletionService;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.AuthStatus;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.ChangeUserSettingParams;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.CompletionContextParams;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.CompletionParams;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.RemoteModelParams;
import com.alibabacloud.intellij.cosy.editor.DefaultInlayCompletionCollector;
import com.alibabacloud.intellij.cosy.editor.InlayCompletionCollector;
import com.alibabacloud.intellij.cosy.editor.cache.CompletionCacheManager;
import com.alibabacloud.intellij.cosy.editor.cache.CompletionRequestManager;
import com.alibabacloud.intellij.cosy.editor.model.CompletionTriggerConfig;
import com.alibabacloud.intellij.cosy.editor.model.InlayCompletionRequest;
import com.alibabacloud.intellij.cosy.editor.request.DelayStrategy;
import com.alibabacloud.intellij.cosy.editor.request.RuleBaseDelayStrategy;
import com.alibabacloud.intellij.cosy.editor.request.TypeSpeedDelayStrategy;
import com.alibabacloud.intellij.cosy.search.enums.CompletionGenerateLengthLevelEnum;
import com.alibabacloud.intellij.cosy.search.enums.CompletionTriggerModeEnum;
import com.alibabacloud.intellij.cosy.search.enums.ModelPowerLevelEnum;
import com.alibabacloud.intellij.cosy.service.TelemetryService;
import com.alibabacloud.intellij.cosy.service.UserAuthService;
import com.alibabacloud.intellij.cosy.service.model.Features;
import com.alibabacloud.intellij.cosy.service.model.Measurements;
import com.alibabacloud.intellij.cosy.ui.config.CosyPersistentSetting;
import com.alibabacloud.intellij.cosy.util.CompletionUtil;
import com.alibabacloud.intellij.cosy.util.EditorUtil;
import com.google.gson.JsonObject;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import java.util.Random;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.jetbrains.annotations.NotNull;

public class InlayPreviewRequest {
    private static final long REQUEST_TIMEOUT = 10000L;
    private static final Logger LOGGER = Logger.getInstance(InlayPreviewRequest.class);
    private static final long INLAY_COMPLETION_TOGGLE_DELAY = 75L;

    private InlayPreviewRequest() {
    }

    public static InlayPreviewRequest build() {
        return new InlayPreviewRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(@NotNull CompletionTriggerConfig config, Editor editor, CompletionTriggerModeEnum triggerMode) {
        CosySetting settings;
        if (config == null) {
            InlayPreviewRequest.$$$reportNull$$$0(0);
        }
        if (!this.isAllowInvoke(settings = CosyPersistentSetting.getInstance().getState(), editor, triggerMode)) {
            return;
        }
        if (editor.getDocument().getTextLength() > 5000000 || StringUtils.isBlank((CharSequence)editor.getDocument().getText())) {
            LOGGER.warn("file content is too long, skip completion");
            return;
        }
        ChangeUserSettingParams.AbstractModelTrigger modelTrigger = this.getModelTrigger(settings, triggerMode);
        int offset = EditorUtil.getCaretOffset(editor);
        String modelLevel = modelTrigger != null ? modelTrigger.getModelLevel() : ModelPowerLevelEnum.LARGE.getLabel();
        boolean isComment = EditorUtil.isCaretInComment(editor);
        String generateLength = this.configGenerateLength(config, editor, offset, isComment, modelTrigger);
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        VirtualFile virtualFile = fileDocumentManager.getFile(editor.getDocument());
        if (virtualFile == null) {
            LOGGER.warn("invalid virtual file for:" + editor.getDocument());
            return;
        }
        int tabWidth = editor.getSettings().getTabSize(editor.getProject());
        CompletionParams params = new CompletionParams();
        params.setRequestId(UUID.randomUUID().toString());
        params.setTextDocument(new TextDocumentIdentifier(virtualFile.getPresentableUrl()));
        params.setUseLocalModel(false);
        params.setUseRemoteModel(true);
        params.setRemoteModelParams(new RemoteModelParams(triggerMode.getName(), true, 0.1, 0.9, generateLength, modelLevel, tabWidth, null, 1000L));
        this.fillRequestContent(editor, offset, params);
        DelayStrategy delayStrategy = this.getDelayStrategy();
        long delay = delayStrategy.calculateDelay(settings, editor, triggerMode.getName(), isComment);
        Measurements measurements = Measurements.build(editor);
        measurements.setCompletionDelayMs(delay);
        params.setCompletionContextParams(new CompletionContextParams(isComment, config.getTriggerEvent() == null ? null : config.getTriggerEvent().getName(), measurements));
        Key<InlayCompletionRequest> key = CosyCacheKeys.KEY_COMPLETION_LATEST_REQUEST;
        synchronized (key) {
            InlayCompletionRequest oldRequest = (InlayCompletionRequest)CosyCacheKeys.KEY_COMPLETION_LATEST_REQUEST.get((UserDataHolder)editor);
            if (oldRequest != null) {
                oldRequest.cancel();
                Disposer.dispose((Disposable)oldRequest);
                CosyCacheKeys.KEY_COMPLETION_LATEST_REQUEST.set((UserDataHolder)editor, null);
            }
            LOGGER.info("inlay completion request id:" + params.getRequestId());
            InlayCompletionRequest request = new InlayCompletionRequest(params, editor, offset);
            DefaultInlayCompletionCollector collector = new DefaultInlayCompletionCollector(editor, request);
            request.setCollector(collector);
            CosyCacheKeys.KEY_COMPLETION_LATEST_REQUEST.set((UserDataHolder)editor, (Object)request);
            CosyCacheKeys.KEY_COMPLETION_LATEST_PROJECT_REQUEST.set((UserDataHolder)editor.getProject(), (Object)request);
            CompletionRequestManager.getInstance().add(request);
            if (CompletionTriggerModeEnum.AUTO.getName().equals(triggerMode.getName()) && this.tryCompletionByCache(config, modelTrigger, request, collector)) {
                return;
            }
            CompletionUtil.triggerPreCompletion(request, delay, triggerMode);
            CosyCompletionService.getInstance().asyncCompletionInlay(request, delay, 10000L, (Consumer<CompletionParams>)((Consumer)p -> {
                ApplicationManager.getApplication().runReadAction(() -> {
                    int caretOffset = editor.getCaretModel().getOffset();
                    if (request.getCursorOffset() != caretOffset) {
                        LOGGER.debug("cursor offset changed (" + request.getCursorOffset() + " -> " + caretOffset + "), regenerate completion request");
                        this.refreshNewEditorContext(config, modelTrigger, request, editor, caretOffset, params, delay);
                    }
                });
                TelemetryService.getInstance().triggerCompletion(triggerMode, editor, params);
            }));
        }
    }

    public InlayCompletionRequest buildSyncCompletionRequest(@NotNull CompletionTriggerConfig config, Editor editor, Document document, int offset, CompletionTriggerModeEnum triggerMode) {
        CosySetting settings;
        ChangeUserSettingParams.AbstractModelTrigger modelTrigger;
        if (config == null) {
            InlayPreviewRequest.$$$reportNull$$$0(1);
        }
        String modelLevel = (modelTrigger = this.getModelTrigger(settings = CosyPersistentSetting.getInstance().getState(), triggerMode)) != null ? modelTrigger.getModelLevel() : ModelPowerLevelEnum.LARGE.getLabel();
        boolean isComment = EditorUtil.isCaretInComment(editor);
        String generateLength = this.configGenerateLength(config, editor, offset, isComment, modelTrigger);
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        VirtualFile virtualFile = fileDocumentManager.getFile(editor.getDocument());
        if (virtualFile == null) {
            LOGGER.warn("invalid virtual file for:" + editor.getDocument());
            return null;
        }
        int tabWidth = editor.getSettings().getTabSize(editor.getProject());
        CompletionParams params = new CompletionParams();
        params.setRequestId(UUID.randomUUID().toString());
        params.setTextDocument(new TextDocumentIdentifier(virtualFile.getPresentableUrl()));
        params.setUseLocalModel(false);
        params.setUseRemoteModel(true);
        params.setRemoteModelParams(new RemoteModelParams(triggerMode.getName(), false, 0.1, 0.9, generateLength, modelLevel, tabWidth, null, 5000L));
        if (offset > document.getTextLength()) {
            LOGGER.warn("offset out of range:" + offset + " length:" + document.getTextLength() + " for document:" + document);
            return null;
        }
        int line = document.getLineNumber(offset);
        int column = offset - document.getLineStartOffset(line);
        params.setFileContent(document.getText());
        params.setPosition(new Position(line, column));
        long delay = 25L;
        Measurements measurements = Measurements.build(editor);
        measurements.setCompletionDelayMs(delay);
        params.setCompletionContextParams(new CompletionContextParams(isComment, config.getTriggerEvent() == null ? null : config.getTriggerEvent().getName(), measurements));
        LOGGER.info("sync inlay completion request id:" + params.getRequestId());
        InlayCompletionRequest request = new InlayCompletionRequest(params, editor, offset);
        CompletionRequestManager.getInstance().add(request);
        return request;
    }

    private boolean tryCompletionByCache(CompletionTriggerConfig config, ChangeUserSettingParams.AbstractModelTrigger modelTrigger, InlayCompletionRequest request, InlayCompletionCollector collector) {
        if (!Features.COMPLETION_CACHE_ENABLE.booleanValue().booleanValue()) {
            return false;
        }
        CompletionItem completionItem = CompletionCacheManager.getInstance().getCacheResult(request.getEditor());
        if (completionItem == null) {
            LOGGER.debug("no cache result for:" + request.getParams().getRequestId());
            return false;
        }
        JsonObject data = (JsonObject)completionItem.getData();
        String requestId = data.get("RequestId").getAsString();
        request.getParams().setRequestId(requestId);
        CosyCacheKeys.KEY_COMPLETION_LATEST_REQUEST.set((UserDataHolder)request.getEditor(), (Object)request);
        CosyCacheKeys.KEY_COMPLETION_LATEST_PROJECT_REQUEST.set((UserDataHolder)request.getEditor().getProject(), (Object)request);
        LOGGER.debug("wait to use cache completion result:" + completionItem.getInsertText());
        long delayTime = Features.COMPLETION_CACHE_TRIGGER_DELAY.longValue();
        CosyCompletionService.getInstance().completionDebounce(request, delayTime, (Consumer<CompletionParams>)((Consumer)p -> ApplicationManager.getApplication().runReadAction(() -> {
            Editor editor = request.getEditor();
            int caretOffset = editor.getCaretModel().getOffset();
            this.refreshNewEditorContext(config, modelTrigger, request, editor, caretOffset, request.getParams(), delayTime);
            CompletionItem newCompletion = CompletionCacheManager.getInstance().getCacheResult(request.getEditor());
            if (newCompletion != null) {
                LOGGER.debug("using cache completion result:" + newCompletion.getInsertText() + " data:" + newCompletion.getData());
                ApplicationManager.getApplication().invokeLater(() -> collector.onCollect(newCompletion));
            }
        })));
        return true;
    }

    private void refreshNewEditorContext(@NotNull CompletionTriggerConfig config, ChangeUserSettingParams.AbstractModelTrigger modelTrigger, InlayCompletionRequest request, Editor editor, int caretOffset, CompletionParams params, long delay) {
        if (config == null) {
            InlayPreviewRequest.$$$reportNull$$$0(2);
        }
        request.setCursorOffset(caretOffset);
        this.fillRequestContent(editor, caretOffset, request.getParams());
        Measurements newMeasurements = Measurements.build(editor, caretOffset);
        newMeasurements.setCompletionDelayMs(delay);
        params.getCompletionContextParams().setMeasurements(newMeasurements);
        boolean isComment = EditorUtil.isCaretInComment(editor);
        params.getRemoteModelParams().setGenerateLength(this.configGenerateLength(config, editor, caretOffset, isComment, modelTrigger));
    }

    private String configGenerateLength(CompletionTriggerConfig config, Editor editor, int offset, boolean isComment, ChangeUserSettingParams.AbstractModelTrigger modelTrigger) {
        String generateLength;
        Document document = editor.getDocument();
        String lineSuffixCode = null;
        if (offset < document.getTextLength()) {
            lineSuffixCode = document.getText(TextRange.create((int)offset, (int)document.getLineEndOffset(document.getLineNumber(offset))));
        }
        String string = generateLength = modelTrigger != null ? modelTrigger.getGenerateLength() : CompletionGenerateLengthLevelEnum.LEVEL_1.getLabel();
        if (isComment) {
            generateLength = CompletionGenerateLengthLevelEnum.LINE_LEVEL.getLabel();
        } else if (StringUtils.isNotBlank(lineSuffixCode)) {
            generateLength = CompletionGenerateLengthLevelEnum.LINE_LEVEL.getLabel();
        }
        if (config.getForceGenerateLengthLevel() != null) {
            generateLength = config.getForceGenerateLengthLevel().getLabel();
        }
        return generateLength;
    }

    private void fillRequestContent(Editor editor, int caretOffset, CompletionParams params) {
        LogicalPosition position = editor.getCaretModel().getLogicalPosition();
        int line = position.line;
        int column = caretOffset - editor.getDocument().getLineStartOffset(line);
        column = column > 0 ? column : position.column;
        params.setFileContent(editor.getDocument().getText());
        params.setPosition(new Position(line, column));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toggle(Editor editor, InlayCompletionRequest oldRequest) {
        String triggerMode;
        CosySetting settings = CosyPersistentSetting.getInstance().getState();
        String string = triggerMode = oldRequest.getParams().getRemoteModelParams() != null ? oldRequest.getParams().getRemoteModelParams().getTriggerMode() : CompletionTriggerModeEnum.AUTO.getName();
        if (!this.isAllowInvoke(settings, editor, CompletionTriggerModeEnum.getTriggerModeEnum(triggerMode))) {
            LOGGER.warn("ignore invoke completion request, need user login auth");
            return;
        }
        int tabWidth = editor.getSettings().getTabSize(editor.getProject());
        CompletionParams params = new CompletionParams();
        params.setRequestId(UUID.randomUUID().toString());
        params.setFileContent(oldRequest.getParams().getFileContent());
        params.setPosition(oldRequest.getParams().getPosition());
        params.setTextDocument(oldRequest.getParams().getTextDocument());
        params.setUseLocalModel(false);
        params.setUseRemoteModel(true);
        String generateLength = oldRequest.getParams().getRemoteModelParams() != null ? oldRequest.getParams().getRemoteModelParams().getGenerateLength() : CompletionGenerateLengthLevelEnum.LEVEL_1.getLabel();
        String modelLevel = oldRequest.getParams().getRemoteModelParams() != null ? oldRequest.getParams().getRemoteModelParams().getModelLevel() : ModelPowerLevelEnum.LARGE.getLabel();
        Random random = new Random();
        params.setRemoteModelParams(new RemoteModelParams(triggerMode, true, 0.3, 0.9, generateLength, modelLevel, tabWidth, random.nextInt(1001) + 1, 1000L));
        params.setCompletionContextParams(oldRequest.getParams().getCompletionContextParams());
        Key<InlayCompletionRequest> key = CosyCacheKeys.KEY_COMPLETION_LATEST_REQUEST;
        synchronized (key) {
            if (oldRequest != null) {
                oldRequest.cancel();
                Disposer.dispose((Disposable)oldRequest);
                CosyCacheKeys.KEY_COMPLETION_LATEST_REQUEST.set((UserDataHolder)editor, null);
            }
            LOGGER.info("inlay toggle completion request id:" + params.getRequestId());
            InlayCompletionRequest request = new InlayCompletionRequest(params, editor, oldRequest.getCursorOffset());
            DefaultInlayCompletionCollector collector = new DefaultInlayCompletionCollector(editor, request);
            request.setCollector(collector);
            CosyCacheKeys.KEY_COMPLETION_LATEST_REQUEST.set((UserDataHolder)editor, (Object)request);
            CosyCacheKeys.KEY_COMPLETION_LATEST_PROJECT_REQUEST.set((UserDataHolder)editor.getProject(), (Object)request);
            CompletionRequestManager.getInstance().add(request);
            CosyCompletionService.getInstance().asyncCompletionInlay(request, 75L, 10000L, (Consumer<CompletionParams>)((Consumer)p -> TelemetryService.getInstance().triggerCompletion(CompletionTriggerModeEnum.TOGGLE, editor, params)));
        }
    }

    private boolean isAllowInvoke(CosySetting settings, Editor editor, CompletionTriggerModeEnum triggerMode) {
        if (!CosyPersistentSetting.getInstance().isEnableCloudCompletion(settings, triggerMode)) {
            return false;
        }
        AuthStatus authStatus = (AuthStatus)CosyCacheKeys.KEY_AUTH_STATUS.get((UserDataHolder)ApplicationManager.getApplication());
        if (authStatus == null) {
            authStatus = UserAuthService.getInstance().getState(editor.getProject());
            CosyCacheKeys.KEY_AUTH_STATUS.set((UserDataHolder)ApplicationManager.getApplication(), (Object)authStatus);
        }
        return authStatus != null && authStatus.isAllow();
    }

    private DelayStrategy getDelayStrategy() {
        String delayStrategy = Features.COMPLETION_AUTO_DELAY_STRATEGY.stringValue();
        if (StringUtils.isBlank((CharSequence)delayStrategy) || "default".equals(delayStrategy)) {
            return new RuleBaseDelayStrategy();
        }
        if ("TypeSpeed".equals(delayStrategy)) {
            return new TypeSpeedDelayStrategy();
        }
        return new RuleBaseDelayStrategy();
    }

    private ChangeUserSettingParams.AbstractModelTrigger getModelTrigger(CosySetting settings, CompletionTriggerModeEnum triggerMode) {
        ChangeUserSettingParams.AbstractModelTrigger modelTrigger = null;
        modelTrigger = CompletionTriggerModeEnum.AUTO.getName().equals(triggerMode.getName()) ? (settings == null ? null : settings.getParameter().getCloud().getAutoTrigger()) : (settings == null ? null : settings.getParameter().getCloud().getManualTrigger());
        return modelTrigger;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "config";
        objectArray2[1] = "com/alibabacloud/intellij/cosy/editor/request/InlayPreviewRequest";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "generate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "buildSyncCompletionRequest";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "refreshNewEditorContext";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

