/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.editor.render.provider;

import com.alibabacloud.intellij.cosy.core.lsp.model.model.RewriteCodeAction;
import com.alibabacloud.intellij.cosy.editor.render.ComponentInlayKt;
import com.alibabacloud.intellij.cosy.editor.render.ComponentInlayRenderer;
import com.alibabacloud.intellij.cosy.editor.render.HighlighterDrawUtil;
import com.alibabacloud.intellij.cosy.editor.render.InlayProperties;
import com.alibabacloud.intellij.cosy.editor.render.InsertedCodeInlayRenderer;
import com.alibabacloud.intellij.cosy.editor.render.provider.BaseNesRenderProvider;
import com.alibabacloud.intellij.cosy.editor.render.provider.DiffFloatingPanel;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.util.LineRange;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.ui.EditorTextField;
import java.awt.Dimension;
import java.awt.Point;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

public class SideBySideNesRenderProvider
extends BaseNesRenderProvider {
    public static final SideBySideNesRenderProvider INSTANCE = new SideBySideNesRenderProvider();

    private SideBySideNesRenderProvider() {
    }

    @Override
    public void renderFragments(Editor editor, List<LineFragment> diffResult, RewriteCodeAction item) {
        boolean onlyInsert = SideBySideNesRenderProvider.isOnlyInsert(diffResult);
        DiffFloatingPanel panel = DiffFloatingPanel.createMultiLineChangePanel(item.getContent(), diffResult, editor, true, onlyInsert);
        if (panel == null) {
            return;
        }
        if (!onlyInsert) {
            List<RangeHighlighter> highlighterList = HighlighterDrawUtil.createMultilineHighlight(editor, diffResult, item);
            this.highlighters.addAll(highlighterList);
        }
        int editStartLine = item.getEditRange().getStart().getLine();
        int start = editStartLine + diffResult.get(0).getStartLine1();
        int end = editStartLine + diffResult.get(diffResult.size() - 1).getEndLine1();
        Pair<Integer, Integer> longestLine = this.getLongestLine(editor, new LineRange(start, end));
        LogicalPosition logicalPosition = onlyInsert && (Integer)longestLine.getRight() == 0 && null != panel.getMinIndent() ? new LogicalPosition(start, panel.getMinIndent().length()) : new LogicalPosition(start, ((Integer)longestLine.getRight()).intValue());
        VisualPosition visualPosition = editor.logicalToVisualPosition(logicalPosition);
        Point point = editor.visualPositionToXY(visualPosition);
        if (onlyInsert) {
            point.y -= editor.getLineHeight() / 2;
        }
        panel.showInsideAtPosition(point, onlyInsert && point.x >= 4);
        this.floatingPanels.add(panel);
        this.addInlayForShowScrollbar(editor, diffResult, (Integer)longestLine.getLeft(), panel);
    }

    private void addInlayForShowScrollbar(Editor editor, List<LineFragment> diffResult, int start, DiffFloatingPanel panel) {
        if (start < editor.getDocument().getLineCount()) {
            int offset = editor.getDocument().getLineEndOffset(start);
            InlayProperties properties = new InlayProperties();
            EditorTextField editorTextField = new EditorTextField("");
            editorTextField.setPreferredSize(new Dimension(panel.getWidth(), editor.getLineHeight()));
            InsertedCodeInlayRenderer render = new InsertedCodeInlayRenderer(editorTextField, diffResult.get(0));
            Inlay<ComponentInlayRenderer<EditorTextField>> inlay = ComponentInlayKt.addComponentInlayAfterLineEnd(editor, offset, properties, render, false);
            if (inlay == null) {
                throw new IllegalStateException("Cannot create inlay");
            }
            render.setInlay(inlay);
            this.inlays.add(inlay);
        }
    }

    public Pair<Integer, Integer> getLongestLine(Editor editor, LineRange lineRange) {
        Document document = editor.getDocument();
        int totalLineCount = document.getLineCount();
        if (totalLineCount <= lineRange.start) {
            return Pair.of((Object)lineRange.start, (Object)0);
        }
        int diffStartLine = lineRange.start;
        int diffEndLine = lineRange.end;
        int maxColumn = editor.offsetToLogicalPosition((int)document.getLineEndOffset((int)diffStartLine)).column;
        int longestLine = diffStartLine;
        for (int i = diffStartLine; i < diffEndLine && i < totalLineCount; ++i) {
            int lineEndOffset = document.getLineEndOffset(i);
            int column = editor.offsetToLogicalPosition((int)lineEndOffset).column;
            if (column <= maxColumn) continue;
            maxColumn = column;
            longestLine = i;
        }
        return Pair.of((Object)longestLine, (Object)maxColumn);
    }
}

