/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.editor.render.provider;

import com.alibabacloud.intellij.cosy.ui.search.component.RoundRectPanel;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.alibabacloud.intellij.cosy.util.SwingUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class NesHoverOption
extends RoundRectPanel {
    JLabel textLabel;
    JLabel hintLabel;
    Color backgroundColor;

    public NesHoverOption(Icon icon, String text) {
        this(icon, text, "");
    }

    public NesHoverOption(Icon icon, String text, String hint) {
        super(new BorderLayout());
        this.setCornerRadius(8);
        this.setBorder(BorderFactory.createEmptyBorder(6, 4, 6, 4));
        this.setPreferredSize(new Dimension(170, 30));
        this.textLabel = new JLabel(text);
        this.textLabel.setIcon(icon);
        this.textLabel.setOpaque(false);
        this.textLabel.setFont(this.textLabel.getFont().deriveFont(13.0f));
        this.textLabel.setBorder(JBUI.Borders.empty((int)4));
        this.add((Component)this.textLabel, "West");
        this.hintLabel = new JLabel(hint);
        this.hintLabel.setFont(this.hintLabel.getFont().deriveFont(13.0f));
        this.hintLabel.setBorder(JBUI.Borders.empty((int)4));
        this.hintLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
        this.add((Component)this.hintLabel, "East");
        this.backgroundColor = this.getBackground();
        this.setupListeners();
    }

    private void setupListeners() {
        SwingUtil.foreachChildComponent(this, cp -> {
            cp.setCursor(Cursor.getPredefinedCursor(12));
            cp.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    NesHoverOption.this.setBackground(ColorUtil.getItemSelectionBackground());
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    NesHoverOption.this.setBackground(NesHoverOption.this.backgroundColor);
                }
            });
        });
    }

    public void addClickHandler(final Consumer<JComponent> handler) {
        SwingUtil.foreachChildComponent(this, cp -> cp.addMouseListener(new MouseAdapter((JComponent)cp){
            final /* synthetic */ JComponent val$cp;
            {
                this.val$cp = jComponent;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                handler.accept(this.val$cp);
            }
        }));
    }

    public void setHint(String hint) {
        this.hintLabel.setText(hint);
    }
}

