/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.editor.render.provider;

import com.alibabacloud.intellij.cosy.core.lsp.model.model.RewriteCodeAction;
import com.alibabacloud.intellij.cosy.editor.render.HighlighterDrawUtil;
import com.alibabacloud.intellij.cosy.editor.render.provider.BaseNesRenderProvider;
import com.alibabacloud.intellij.cosy.editor.render.provider.DiffFloatingPanel;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import java.awt.Point;
import java.util.List;

public class InlinePopupNesRenderProvider
extends BaseNesRenderProvider {
    public static final InlinePopupNesRenderProvider INSTANCE = new InlinePopupNesRenderProvider();

    private InlinePopupNesRenderProvider() {
    }

    @Override
    public void renderFragments(Editor editor, List<LineFragment> diffResult, RewriteCodeAction item) {
        boolean onlyInsert = InlinePopupNesRenderProvider.isOnlyInsert(diffResult);
        if (onlyInsert) {
            this.showOnlyInsertDiff(editor, diffResult, item);
        } else {
            this.showChangeDiff(editor, diffResult, item);
        }
    }

    private void showOnlyInsertDiff(Editor editor, List<LineFragment> diffResult, RewriteCodeAction item) {
        DiffFloatingPanel panel = DiffFloatingPanel.createMultiLineChangePanel(item.getContent(), diffResult, editor, false);
        if (panel == null) {
            return;
        }
        int startLine = HighlighterDrawUtil.getFirstOriginStartLine(editor, diffResult, item);
        if (startLine == Integer.MAX_VALUE) {
            return;
        }
        Point showPoint = editor.visualPositionToXY(editor.logicalToVisualPosition(new LogicalPosition(startLine, 0)));
        panel.showUnderAtPoint(showPoint, 0, false);
        this.floatingPanels.add(panel);
    }

    private void showChangeDiff(Editor editor, List<LineFragment> diffResult, RewriteCodeAction item) {
        DiffFloatingPanel panel = DiffFloatingPanel.createMultiLineChangePanel(item.getContent(), diffResult, editor, true);
        if (panel == null) {
            return;
        }
        HighlighterDrawUtil.DiffChangeRange changeRange = HighlighterDrawUtil.getStartAndEndDiffPoint(editor, diffResult, item);
        if (changeRange == null) {
            return;
        }
        Point showPoint = new Point(changeRange.getStartPoint().x, changeRange.getEndPoint().y + editor.getLineHeight());
        panel.showUnderAtPoint(showPoint, 4, true);
        this.floatingPanels.add(panel);
        List<RangeHighlighter> highlighterList = HighlighterDrawUtil.createMultilineHighlight(editor, diffResult, item);
        this.highlighters.addAll(highlighterList);
    }
}

