/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.editor.render.provider;

import com.alibabacloud.intellij.cosy.core.lsp.model.model.RewriteCodeAction;
import com.alibabacloud.intellij.cosy.editor.render.ComponentInlayKt;
import com.alibabacloud.intellij.cosy.editor.render.ComponentInlayRenderer;
import com.alibabacloud.intellij.cosy.editor.render.HighlighterDrawUtil;
import com.alibabacloud.intellij.cosy.editor.render.InlayProperties;
import com.alibabacloud.intellij.cosy.editor.render.InsertedCodeInlayRenderer;
import com.alibabacloud.intellij.cosy.editor.render.provider.BaseNesRenderProvider;
import com.alibabacloud.intellij.cosy.util.CosyDiffDrawUtil;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.fragments.LineFragmentImpl;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.TextDiffType;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.ex.LineStatusMarkerPopupPanel;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.EditorTextField;
import java.util.List;
import javax.swing.JComponent;

public class InlineEmbeddingNesRenderProvider
extends BaseNesRenderProvider {
    public static final InlineEmbeddingNesRenderProvider INSTANCE = new InlineEmbeddingNesRenderProvider();

    private InlineEmbeddingNesRenderProvider() {
    }

    @Override
    public void renderFragments(Editor editor, List<LineFragment> diffResult, RewriteCodeAction item) {
        int startOffsetOfLine = editor.getDocument().getLineStartOffset(item.getEditRange().getStart().getLine());
        for (LineFragment change : diffResult) {
            LineFragment absoluteChange = this.addOffset(change, item.getEditRange().getStart().getLine(), startOffsetOfLine);
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            String newText = item.getContent();
            LineRange insertRange = new LineRange(absoluteChange.getStartLine1(), absoluteChange.getEndLine1());
            List<RangeHighlighter> rangeHighlighters = CosyDiffDrawUtil.createUnifiedChunkHighlighters(editor, insertRange, null, absoluteChange.getInnerFragments());
            this.highlighters.addAll(rangeHighlighters);
            if (change.getStartLine2() == change.getEndLine2()) continue;
            EditorTextField editorTextField = this.addInsertCodeInlay(absoluteChange, editor, item, newText);
            this.setupInsertCodeInlay(editorTextField, absoluteChange);
        }
    }

    private void setupInsertCodeInlay(EditorTextField inlay, LineFragment change) {
        Editor inlayEditor = inlay.getEditor();
        if (inlayEditor == null) {
            throw new IllegalStateException("Cannot create inlay editor");
        }
        DataManager.registerDataProvider((JComponent)inlayEditor.getComponent(), dataId -> !CommonDataKeys.EDITOR.is(dataId) && !CommonDataKeys.HOST_EDITOR.is(dataId) ? null : inlay.getEditor());
        int inlayLinesCount = change.getEndLine2() - change.getStartLine2();
        HighlighterDrawUtil.createInsertionHighlighters(inlayEditor, new LineRange(0, inlayLinesCount), change.getInnerFragments(), TextDiffType.INSERTED, true);
    }

    private EditorTextField addInsertCodeInlay(LineFragment change, Editor editor, RewriteCodeAction item, String newText) {
        InsertedCodeInlayRenderer render;
        InlayProperties properties;
        EditorFactory editorFactory = EditorFactory.getInstance();
        Document newDocument = editorFactory.createDocument((CharSequence)newText);
        int startOffsetOfLine = editor.getDocument().getLineStartOffset(item.getEditRange().getStart().getLine());
        int lineOffset = item.getEditRange().getStart().getLine();
        LineFragment relativeChange = this.getRelativeChange(change, lineOffset, startOffsetOfLine);
        String insertText = DiffUtil.getLinesContent((Document)newDocument, (int)relativeChange.getStartLine2(), (int)relativeChange.getEndLine2()).toString();
        Document changeDocument = editorFactory.createDocument((CharSequence)(insertText + " "));
        EditorTextField editorTextField = InlineEmbeddingNesRenderProvider.createTextField(editor, changeDocument);
        boolean isAbove = change.getEndLine1() != editor.getDocument().getLineCount();
        int inlayLine = isAbove ? change.getEndLine1() : Math.max(change.getEndLine1() - 1, 0);
        int offset = editor.getDocument().getLineStartOffset(inlayLine);
        Inlay<ComponentInlayRenderer<EditorTextField>> inlay = ComponentInlayKt.addComponentInlay(editor, offset, properties = new InlayProperties().showAbove(isAbove), render = new InsertedCodeInlayRenderer(editorTextField, change));
        if (inlay == null) {
            throw new IllegalStateException("Cannot create inlay");
        }
        render.setInlay(inlay);
        this.inlays.add(inlay);
        return editorTextField;
    }

    private static EditorTextField createTextField(Editor editor, Document completionDocument) {
        EditorTextField textField = LineStatusMarkerPopupPanel.createTextField((Editor)editor, (String)completionDocument.getText());
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)editor.getProject()).getPsiFile(editor.getDocument());
        LineStatusMarkerPopupPanel.installBaseEditorSyntaxHighlighters((Project)editor.getProject(), (EditorTextField)textField, (Document)completionDocument, (TextRange)new TextRange(0, completionDocument.getTextLength()), (FileType)psiFile.getFileType());
        return textField;
    }

    private LineFragment getRelativeChange(LineFragment fragment, int lineOffset, int offsetOfLine) {
        int startLine1 = fragment.getStartLine1() - lineOffset;
        int endLine1 = fragment.getEndLine1() - lineOffset;
        int startLine2 = fragment.getStartLine2() - lineOffset;
        int endLine2 = fragment.getEndLine2() - lineOffset;
        int startOffset1 = fragment.getStartOffset1() - offsetOfLine;
        int endOffset1 = fragment.getEndOffset1() - offsetOfLine;
        int startOffset2 = fragment.getStartOffset2() - offsetOfLine;
        int endOffset2 = fragment.getEndOffset2() - offsetOfLine;
        return new LineFragmentImpl(startLine1, endLine1, startLine2, endLine2, startOffset1, endOffset1, startOffset2, endOffset2, fragment.getInnerFragments());
    }
}

