/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.editor.render;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.ui.JBColor;
import com.intellij.ui.paint.EffectPainter;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WordHighlighterRenderer
implements CustomHighlighterRenderer {
    private final Color highlightColor;
    private final Color borderColor;
    private final boolean hasStrikeThrough;
    private final Color strikeColor;

    public WordHighlighterRenderer(@Nullable Color highlightColor, @Nullable Color borderColor, @Nullable Boolean hasStrikeThrough, @Nullable Color strikeColor) {
        this.highlightColor = highlightColor;
        this.borderColor = borderColor;
        this.hasStrikeThrough = Boolean.TRUE.equals(hasStrikeThrough);
        this.strikeColor = strikeColor;
    }

    public void paint(@NotNull Editor editor, @NotNull RangeHighlighter rangeHighlighter, @NotNull Graphics graphics) {
        if (editor == null) {
            WordHighlighterRenderer.$$$reportNull$$$0(0);
        }
        if (rangeHighlighter == null) {
            WordHighlighterRenderer.$$$reportNull$$$0(1);
        }
        if (graphics == null) {
            WordHighlighterRenderer.$$$reportNull$$$0(2);
        }
        Point startPoint = editor.logicalPositionToXY(editor.offsetToLogicalPosition(rangeHighlighter.getStartOffset()));
        Point endPoint = editor.logicalPositionToXY(editor.offsetToLogicalPosition(rangeHighlighter.getEndOffset()));
        GraphicsUtil.setupRoundedBorderAntialiasing((Graphics)graphics);
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        int width = endPoint.x - startPoint.x;
        if (this.highlightColor != null) {
            graphics.setColor(this.highlightColor);
            graphics.fillRect(startPoint.x, startPoint.y, JBUIScale.scale((int)width), editor.getLineHeight());
        }
        if (this.borderColor != null) {
            graphics.setColor(this.borderColor);
            graphics.drawRoundRect(startPoint.x, startPoint.y, JBUIScale.scale((int)width), editor.getLineHeight(), JBUIScale.scale((int)8), JBUIScale.scale((int)8));
        }
        if (this.hasStrikeThrough) {
            if (this.strikeColor != null) {
                graphics.setColor(this.strikeColor);
            } else {
                graphics.setColor((Color)JBColor.WHITE);
            }
            EffectPainter.STRIKE_THROUGH.paint((Graphics2D)graphics, startPoint.x, startPoint.y + editor.getLineHeight() * 3 / 4, width, graphics.getFontMetrics().charWidth('a'), (Object)editor.getComponent().getFont());
        }
    }

    public boolean isForeground() {
        return this.hasStrikeThrough;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "rangeHighlighter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "graphics";
                break;
            }
        }
        objectArray[1] = "com/alibabacloud/intellij/cosy/editor/render/WordHighlighterRenderer";
        objectArray[2] = "paint";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

