/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.editor.render;

import com.intellij.diff.util.DiffEmptyHighlighterRenderer;
import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import java.awt.Color;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InlineHighlighterBuilder {
    @NotNull
    private final Editor editor;
    @NotNull
    private final TextDiffType type;
    private final int start;
    private final int end;
    private int layerPriority;

    public InlineHighlighterBuilder(@NotNull Editor editor, int start, int end, @NotNull TextDiffType type) {
        if (editor == null) {
            InlineHighlighterBuilder.$$$reportNull$$$0(0);
        }
        if (type == null) {
            InlineHighlighterBuilder.$$$reportNull$$$0(1);
        }
        this.layerPriority = 0;
        this.editor = editor;
        this.type = type;
        this.start = start;
        this.end = end;
    }

    @NotNull
    public InlineHighlighterBuilder withLayerPriority(int layerPriority) {
        this.layerPriority = layerPriority;
        InlineHighlighterBuilder inlineHighlighterBuilder = this;
        if (inlineHighlighterBuilder == null) {
            InlineHighlighterBuilder.$$$reportNull$$$0(2);
        }
        return inlineHighlighterBuilder;
    }

    @NotNull
    public List<RangeHighlighter> done() {
        TextAttributes attributes = InlineHighlighterBuilder.getTextAttributes(this.type, this.editor, BackgroundType.DEFAULT);
        RangeHighlighter highlighter = this.editor.getMarkupModel().addRangeHighlighter(this.start, this.end, InlineHighlighterBuilder.getLayer(5899, this.layerPriority), attributes, HighlighterTargetArea.EXACT_RANGE);
        if (this.start == this.end) {
            InlineHighlighterBuilder.installEmptyRangeRenderer(highlighter, this.type);
        }
        List<RangeHighlighter> list = Collections.singletonList(highlighter);
        if (list == null) {
            InlineHighlighterBuilder.$$$reportNull$$$0(3);
        }
        return list;
    }

    private static void installEmptyRangeRenderer(@NotNull RangeHighlighter highlighter, @NotNull TextDiffType type) {
        if (highlighter == null) {
            InlineHighlighterBuilder.$$$reportNull$$$0(4);
        }
        if (type == null) {
            InlineHighlighterBuilder.$$$reportNull$$$0(5);
        }
        highlighter.setCustomRenderer((CustomHighlighterRenderer)new DiffEmptyHighlighterRenderer(type));
    }

    private static int getLayer(int layer, int layerPriority) {
        return layer + layerPriority * 5;
    }

    private static TextAttributes getTextAttributes(@NotNull TextDiffType type, @Nullable Editor editor, @NotNull BackgroundType background) {
        if (type == null) {
            InlineHighlighterBuilder.$$$reportNull$$$0(6);
        }
        if (background == null) {
            InlineHighlighterBuilder.$$$reportNull$$$0(7);
        }
        if (background == BackgroundType.NONE) {
            return null;
        }
        return new DiffTextAttributes(background, type, editor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/alibabacloud/intellij/cosy/editor/render/InlineHighlighterBuilder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "background";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/alibabacloud/intellij/cosy/editor/render/InlineHighlighterBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "withLayerPriority";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "done";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "installEmptyRangeRenderer";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTextAttributes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum BackgroundType {
        NONE,
        DEFAULT,
        IGNORED;

    }

    public static class DiffTextAttributes
    extends TextAttributes {
        @NotNull
        private final BackgroundType myBackground;
        @NotNull
        private final TextDiffType myType;
        @Nullable
        private final Editor myEditor;

        public DiffTextAttributes(@NotNull BackgroundType background, @NotNull TextDiffType type, @Nullable Editor editor) {
            if (background == null) {
                DiffTextAttributes.$$$reportNull$$$0(0);
            }
            if (type == null) {
                DiffTextAttributes.$$$reportNull$$$0(1);
            }
            this.myBackground = background;
            this.myType = type;
            this.myEditor = editor;
        }

        public Color getBackgroundColor() {
            return this.myBackground == BackgroundType.IGNORED ? this.myType.getIgnoredColor(this.myEditor) : this.myType.getColor(this.myEditor);
        }

        @NotNull
        public TextDiffType getType() {
            TextDiffType textDiffType = this.myType;
            if (textDiffType == null) {
                DiffTextAttributes.$$$reportNull$$$0(2);
            }
            return textDiffType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "background";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/alibabacloud/intellij/cosy/editor/render/InlineHighlighterBuilder$DiffTextAttributes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/alibabacloud/intellij/cosy/editor/render/InlineHighlighterBuilder$DiffTextAttributes";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

