/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.editor.render;

import com.alibabacloud.intellij.cosy.common.CosySetting;
import com.alibabacloud.intellij.cosy.common.LingmaNesConfig;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.RewriteCodeAction;
import com.alibabacloud.intellij.cosy.editor.model.DiffChangeModel;
import com.alibabacloud.intellij.cosy.editor.model.InlineEditRequest;
import com.alibabacloud.intellij.cosy.editor.render.InlineDiffRenderContext;
import com.alibabacloud.intellij.cosy.editor.render.TabJumpButton;
import com.alibabacloud.intellij.cosy.editor.render.provider.InlineEmbeddingNesRenderProvider;
import com.alibabacloud.intellij.cosy.editor.render.provider.InlinePopupNesRenderProvider;
import com.alibabacloud.intellij.cosy.editor.render.provider.NesRenderProvider;
import com.alibabacloud.intellij.cosy.editor.render.provider.SideBySideNesRenderProvider;
import com.alibabacloud.intellij.cosy.ui.config.CosyPersistentSetting;
import com.alibabacloud.intellij.cosy.util.DiffUtil;
import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.util.LineRange;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.progress.DumbProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import java.awt.Rectangle;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;

public class InlineEditRender
implements Disposable {
    private static final Logger LOG = Logger.getInstance(InlineEditRender.class);
    InlineEditRequest request;
    NesRenderProvider renderProvider;
    DiffChangeModel diffChangeModel;
    TabJumpButton tabJumpButton;
    AtomicLong renderStartTime = new AtomicLong(-1L);
    AtomicLong renderEndTime = new AtomicLong(-1L);

    public InlineEditRender(InlineEditRequest request) {
        this.request = request;
        Editor editor = request.getEditor();
        if (editor != null) {
            Disposer.register((Disposable)request, (Disposable)this);
        }
    }

    public void renderInlineEditItem(RewriteCodeAction item) {
        int rangeEndLine;
        long st = System.currentTimeMillis();
        Editor editor = this.request.getEditor();
        if (item.getEditRange().getStart().getLine() >= editor.getDocument().getLineCount() || item.getEditRange().getEnd().getLine() >= editor.getDocument().getLineCount()) {
            LOG.warn("Invalid edit range: " + item.getEditRange());
            return;
        }
        Document document = editor.getDocument();
        int startOffsetOfLine = document.getLineStartOffset(item.getEditRange().getStart().getLine());
        if (startOffsetOfLine < 0) {
            return;
        }
        int rangeStartLine = item.getEditRange().getStart().getLine();
        int realEndLine = rangeStartLine >= (rangeEndLine = item.getEditRange().getEnd().getLine()) ? rangeEndLine : rangeEndLine - 1;
        int endOffsetOfLine = document.getLineEndOffset(realEndLine);
        if (endOffsetOfLine < 0) {
            return;
        }
        this.renderStartTime.getAndSet(System.currentTimeMillis());
        String originalText = document.getText(new TextRange(startOffsetOfLine, endOffsetOfLine));
        String newText = item.getContent();
        List diffResult = ComparisonManager.getInstance().compareLinesInner((CharSequence)originalText, (CharSequence)newText, ComparisonPolicy.IGNORE_WHITESPACES, (ProgressIndicator)DumbProgressIndicator.INSTANCE);
        LOG.debug("inline diff originalText:" + originalText + " newText:" + newText + " result:" + diffResult);
        if (!DiffUtil.isValidDiffs(diffResult, originalText, newText)) {
            LOG.debug("Invalid diffs: " + diffResult);
            return;
        }
        this.diffChangeModel = new DiffChangeModel(diffResult, item);
        this.renderProvider = InlineEditRender.getProviderInstance(editor, diffResult, item);
        InlineDiffRenderContext context = new InlineDiffRenderContext(editor, this.diffChangeModel, item, originalText, this.request.isChangeActivated());
        this.renderProvider.render(context);
        if (!this.request.isChangeActivated()) {
            LOG.debug("inline diff render has tab jump button");
            this.tabJumpButton = new TabJumpButton(editor, this);
        }
        this.renderEndTime.getAndSet(System.currentTimeMillis());
        LOG.debug("inline diff render finish time:" + (System.currentTimeMillis() - st));
        if (Disposer.isDisposed((Disposable)this.request)) {
            this.dispose();
            LOG.info("dispose inline diff render after finish");
        }
        this.request.getDiffChangeModels().add(this.diffChangeModel);
    }

    public void dispose() {
        if (this.renderProvider != null) {
            this.renderProvider.dispose();
        }
        if (this.tabJumpButton != null) {
            this.tabJumpButton.dispose();
        }
        this.request.getEditor().getContentComponent().revalidate();
        this.request.getEditor().getContentComponent().repaint();
    }

    public boolean hasShowingInlineEdit() {
        if (this.renderProvider != null) {
            return this.renderProvider.hasShowingInlineEdit();
        }
        return false;
    }

    public static NesRenderProvider getProviderInstance(Editor editor, List<LineFragment> diffResult, RewriteCodeAction item) {
        String suggestMode = LingmaNesConfig.SuggestMode.INLINE.name();
        boolean codeShifting = false;
        if (CosyPersistentSetting.getInstance().getState() != null) {
            CosySetting setting = CosyPersistentSetting.getInstance().getState();
            suggestMode = setting.getNesConfig().getSuggestMode();
            codeShifting = setting.getNesConfig().getCodeShiftEnabled();
        }
        if (suggestMode.equals(LingmaNesConfig.SuggestMode.INLINE.name()) || suggestMode.equals(LingmaNesConfig.SuggestMode.AUTO.name()) && !InlineEditRender.useSideBySide(editor, diffResult, item)) {
            if (codeShifting) {
                return InlineEmbeddingNesRenderProvider.INSTANCE;
            }
            return InlinePopupNesRenderProvider.INSTANCE;
        }
        return SideBySideNesRenderProvider.INSTANCE;
    }

    private static boolean useSideBySide(Editor editor, List<LineFragment> diffResult, RewriteCodeAction item) {
        int end;
        Document document = editor.getDocument();
        int editStartLine = item.getEditRange().getStart().getLine();
        int start = editStartLine + diffResult.get(0).getStartLine1();
        if (start == (end = editStartLine + diffResult.get(diffResult.size() - 1).getEndLine1())) {
            start = Math.max(0, start - 1);
            end = Math.min(document.getLineCount(), end + 1);
        }
        int maxWidthOriginal = InlineEditRender.getMaxWidth(editor, document, new LineRange(start, end));
        EditorFactory editorFactory = EditorFactory.getInstance();
        Document newDocument = editorFactory.createDocument((CharSequence)item.getContent());
        Editor editorNew = editorFactory.createViewer(newDocument, editor.getProject());
        start = diffResult.get(0).getStartLine2();
        end = diffResult.get(diffResult.size() - 1).getEndLine2();
        int maxWidthNew = InlineEditRender.getMaxWidth(editorNew, newDocument, new LineRange(start, end));
        editorFactory.releaseEditor(editorNew);
        Rectangle visibleArea = editor.getScrollingModel().getVisibleArea();
        return maxWidthOriginal + maxWidthNew < visibleArea.width;
    }

    private static int getMaxWidth(Editor editor, Document document, LineRange lineRange) {
        int maxWidth = 0;
        for (int i = lineRange.start; i < lineRange.end; ++i) {
            int lineEndOffset = document.getLineEndOffset(i);
            int column = editor.offsetToLogicalPosition((int)lineEndOffset).column;
            maxWidth = Math.max(maxWidth, editor.logicalPositionToXY((LogicalPosition)new LogicalPosition((int)i, (int)column)).x);
        }
        return maxWidth;
    }

    public long getRenderStartTime() {
        return this.renderStartTime.get();
    }

    public long getRenderEndTime() {
        return this.renderEndTime.get();
    }

    @Generated
    public InlineEditRequest getRequest() {
        return this.request;
    }

    @Generated
    public NesRenderProvider getRenderProvider() {
        return this.renderProvider;
    }

    @Generated
    public DiffChangeModel getDiffChangeModel() {
        return this.diffChangeModel;
    }
}

