/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.editor.render;

import com.alibabacloud.intellij.cosy.core.lsp.model.model.RewriteCodeAction;
import com.alibabacloud.intellij.cosy.editor.render.WordHighlighterRenderer;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.alibabacloud.intellij.cosy.util.CosyDiffDrawUtil;
import com.alibabacloud.intellij.cosy.util.DiffUtil;
import com.alibabacloud.intellij.cosy.util.DocumentUtils;
import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.TextRange;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlighterDrawUtil {
    private static final Logger LOG = Logger.getInstance(HighlighterDrawUtil.class);

    @NotNull
    public static List<RangeHighlighter> createDeletionHighlighters(@NotNull Editor editor, @NotNull LineRange range, @Nullable List<? extends DiffFragment> innerFragments, Boolean isFullLine) {
        if (editor == null) {
            HighlighterDrawUtil.$$$reportNull$$$0(0);
        }
        if (range == null) {
            HighlighterDrawUtil.$$$reportNull$$$0(1);
        }
        boolean ignored = innerFragments != null;
        ArrayList<RangeHighlighter> list = new ArrayList<RangeHighlighter>();
        if (isFullLine.booleanValue() && !range.isEmpty()) {
            list.addAll(DiffDrawUtil.createHighlighter((Editor)editor, (int)range.start, (int)range.end, (TextDiffType)TextDiffType.DELETED, (boolean)ignored));
        }
        if (innerFragments != null) {
            int startOffset = editor.getDocument().getLineStartOffset(range.start);
            for (DiffFragment diffFragment : innerFragments) {
                int wordStart = startOffset + diffFragment.getStartOffset1();
                int wordEnd = startOffset + diffFragment.getEndOffset1();
                List wordHighlighters = DiffDrawUtil.createInlineHighlighter((Editor)editor, (int)wordStart, (int)wordEnd, (TextDiffType)TextDiffType.DELETED);
                list.addAll(wordHighlighters);
                List strikes = DiffDrawUtil.createInlineHighlighter((Editor)editor, (int)wordStart, (int)wordEnd, (TextDiffType)TextDiffType.DELETED);
                for (RangeHighlighter highlighter : strikes) {
                    highlighter.setCustomRenderer((CustomHighlighterRenderer)new WordHighlighterRenderer(null, null, true, null));
                }
                list.addAll(strikes);
            }
        }
        ArrayList<RangeHighlighter> arrayList = list;
        if (arrayList == null) {
            HighlighterDrawUtil.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NotNull
    public static List<RangeHighlighter> createDeletionWordHighlighters(@NotNull Editor editor, @NotNull LineRange range, @NotNull List<? extends DiffFragment> innerFragments) {
        if (editor == null) {
            HighlighterDrawUtil.$$$reportNull$$$0(3);
        }
        if (range == null) {
            HighlighterDrawUtil.$$$reportNull$$$0(4);
        }
        if (innerFragments == null) {
            HighlighterDrawUtil.$$$reportNull$$$0(5);
        }
        ArrayList<RangeHighlighter> list = new ArrayList<RangeHighlighter>();
        int startOffset = editor.getDocument().getLineStartOffset(range.start);
        for (DiffFragment diffFragment : innerFragments) {
            if (diffFragment.getStartOffset1() != diffFragment.getStartOffset2() || diffFragment.getEndOffset1() <= diffFragment.getEndOffset2()) continue;
            int wordStart = startOffset + diffFragment.getEndOffset2();
            int wordEnd = startOffset + diffFragment.getEndOffset1();
            ColorUtil.HighlightResult wordColorResult = ColorUtil.getHighlightColor(editor, wordStart);
            Color wordColor = wordColorResult == null ? null : wordColorResult.getForegroundColor();
            List wordHighlighters = DiffDrawUtil.createInlineHighlighter((Editor)editor, (int)wordStart, (int)wordEnd, (TextDiffType)TextDiffType.DELETED);
            for (RangeHighlighter highlighter : wordHighlighters) {
                highlighter.setCustomRenderer((CustomHighlighterRenderer)new WordHighlighterRenderer(null, null, true, wordColor));
            }
            list.addAll(wordHighlighters);
        }
        ArrayList<RangeHighlighter> arrayList = list;
        if (arrayList == null) {
            HighlighterDrawUtil.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    public static List<RangeHighlighter> createInsertionHighlighters(@NotNull Editor editor, @NotNull LineRange range, @Nullable List<? extends DiffFragment> innerFragments, TextDiffType type) {
        if (editor == null) {
            HighlighterDrawUtil.$$$reportNull$$$0(7);
        }
        if (range == null) {
            HighlighterDrawUtil.$$$reportNull$$$0(8);
        }
        return HighlighterDrawUtil.createInsertionHighlighters(editor, range, innerFragments, type, false);
    }

    @NotNull
    public static List<RangeHighlighter> createInsertionHighlighters(@NotNull Editor editor, @NotNull LineRange range, @Nullable List<? extends DiffFragment> innerFragments, TextDiffType type, boolean isInlay) {
        if (editor == null) {
            HighlighterDrawUtil.$$$reportNull$$$0(9);
        }
        if (range == null) {
            HighlighterDrawUtil.$$$reportNull$$$0(10);
        }
        if (editor.getDocument().getLineCount() <= range.start) {
            List<RangeHighlighter> list = List.of();
            if (list == null) {
                HighlighterDrawUtil.$$$reportNull$$$0(11);
            }
            return list;
        }
        boolean ignored = innerFragments != null;
        ArrayList<RangeHighlighter> list = new ArrayList<RangeHighlighter>();
        if (!range.isEmpty()) {
            list.addAll(DiffDrawUtil.createHighlighter((Editor)editor, (int)range.start, (int)range.end, (TextDiffType)type, (boolean)ignored));
        }
        if (innerFragments != null) {
            int startOffset = editor.getDocument().getLineStartOffset(range.start);
            for (DiffFragment diffFragment : innerFragments) {
                boolean isWordDeletion;
                boolean bl = isWordDeletion = diffFragment.getEndOffset2() - diffFragment.getStartOffset2() == 0;
                if (!isInlay && isWordDeletion) {
                    list.addAll(HighlighterDrawUtil.createDeletionHighlighters(editor, range, innerFragments, false));
                    continue;
                }
                int wordStart = startOffset + (isInlay ? diffFragment.getStartOffset2() : diffFragment.getStartOffset1());
                int wordEnd = startOffset + (isInlay ? diffFragment.getEndOffset2() : diffFragment.getEndOffset1());
                int documentLength = editor.getDocument().getTextLength();
                if (wordStart < 0 || wordStart > wordEnd || wordStart > documentLength) continue;
                List wordHighlighters = DiffDrawUtil.createInlineHighlighter((Editor)editor, (int)wordStart, (int)wordEnd, (TextDiffType)type);
                list.addAll(wordHighlighters);
            }
        }
        ArrayList<RangeHighlighter> arrayList = list;
        if (arrayList == null) {
            HighlighterDrawUtil.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    public static List<RangeHighlighter> createMultilineHighlight(@NotNull Editor editor, @NotNull List<LineFragment> diffResult, RewriteCodeAction item) {
        if (editor == null) {
            HighlighterDrawUtil.$$$reportNull$$$0(13);
        }
        if (diffResult == null) {
            HighlighterDrawUtil.$$$reportNull$$$0(14);
        }
        ArrayList<RangeHighlighter> list = new ArrayList<RangeHighlighter>();
        int startOffsetOfLine = editor.getDocument().getLineStartOffset(item.getEditRange().getStart().getLine());
        for (LineFragment change : diffResult) {
            LineFragment absoluteChange = DiffUtil.addOffset(change, item.getEditRange().getStart().getLine(), startOffsetOfLine);
            if (absoluteChange.getStartLine1() == absoluteChange.getEndLine1()) continue;
            LineRange range = new LineRange(absoluteChange.getStartLine1(), absoluteChange.getEndLine1());
            List<RangeHighlighter> rangeHighlighter = CosyDiffDrawUtil.createUnifiedChunkHighlighters(editor, range, null, change.getInnerFragments());
            list.addAll(rangeHighlighter);
        }
        RangeHighlighter innerHighlighter = HighlighterDrawUtil.createMultilineInnerHighlight(editor, diffResult, item, true);
        if (innerHighlighter != null) {
            list.add(innerHighlighter);
        }
        return list;
    }

    public static RangeHighlighter createMultilineInnerHighlight(@NotNull Editor editor, @NotNull List<LineFragment> diffResult, RewriteCodeAction item, boolean needRoundRect) {
        if (editor == null) {
            HighlighterDrawUtil.$$$reportNull$$$0(15);
        }
        if (diffResult == null) {
            HighlighterDrawUtil.$$$reportNull$$$0(16);
        }
        DiffChangeRange changeRange = HighlighterDrawUtil.getStartAndEndDiffPoint(editor, diffResult, item);
        return HighlighterDrawUtil.createMultilineInnerHighlight(editor, changeRange, needRoundRect);
    }

    public static RangeHighlighter createMultilineInnerHighlight(@NotNull Editor editor, DiffChangeRange changeRange, boolean needRoundRect) {
        if (editor == null) {
            HighlighterDrawUtil.$$$reportNull$$$0(17);
        }
        if (changeRange == null) {
            return null;
        }
        return HighlighterDrawUtil.drawSectionHighlight(editor, changeRange.minStartOffset, changeRange.maxEndOffset, changeRange.startPoint, changeRange.endPoint, needRoundRect);
    }

    public static DiffChangeRange getStartAndEndDiffPoint(@NotNull Editor editor, @NotNull List<LineFragment> diffResult, RewriteCodeAction item) {
        if (editor == null) {
            HighlighterDrawUtil.$$$reportNull$$$0(18);
        }
        if (diffResult == null) {
            HighlighterDrawUtil.$$$reportNull$$$0(19);
        }
        Point startPoint = null;
        Point endPoint = null;
        int minStartOffset = Integer.MAX_VALUE;
        int maxEndOffset = -1;
        int startOffsetOfLine = editor.getDocument().getLineStartOffset(item.getEditRange().getStart().getLine());
        int changeStartLine = Integer.MAX_VALUE;
        int changeEndLine = -1;
        for (LineFragment change : diffResult) {
            int startOffset;
            int lineEndOffset;
            int lineStartOffset;
            LineFragment absoluteChange = DiffUtil.addOffset(change, item.getEditRange().getStart().getLine(), startOffsetOfLine);
            if (absoluteChange.getStartLine1() == absoluteChange.getEndLine1()) {
                int insertLine = Math.max(absoluteChange.getStartLine1(), 0);
                insertLine = insertLine >= editor.getDocument().getLineCount() ? editor.getDocument().getLineCount() - 1 : insertLine;
                lineStartOffset = DocumentUtils.getSafeLineStartOffset(editor.getDocument(), insertLine);
                lineEndOffset = DocumentUtils.getSafeLineEndOffset(editor.getDocument(), insertLine);
                startOffset = HighlighterDrawUtil.getStartValidCharOffset(editor.getDocument(), lineStartOffset);
                minStartOffset = Math.min(minStartOffset, startOffset);
                maxEndOffset = Math.max(maxEndOffset, lineEndOffset);
                changeStartLine = Math.min(changeStartLine, insertLine);
                changeEndLine = Math.max(changeEndLine, insertLine - 1);
                continue;
            }
            for (int i = absoluteChange.getStartLine1(); i < absoluteChange.getEndLine1(); ++i) {
                lineStartOffset = DocumentUtils.getSafeLineStartOffset(editor.getDocument(), i);
                lineEndOffset = DocumentUtils.getSafeLineEndOffset(editor.getDocument(), i);
                startOffset = HighlighterDrawUtil.getStartValidCharOffset(editor.getDocument(), lineStartOffset);
                minStartOffset = Math.min(minStartOffset, startOffset);
                maxEndOffset = Math.max(maxEndOffset, lineEndOffset);
                changeStartLine = Math.min(changeStartLine, i);
                changeEndLine = Math.max(changeEndLine, i);
            }
        }
        if (changeEndLine < changeStartLine) {
            changeEndLine = changeStartLine;
        }
        for (int i = changeStartLine; i <= changeEndLine; ++i) {
            int lineStartOffset = editor.getDocument().getLineStartOffset(i);
            int lineEndOffset = editor.getDocument().getLineEndOffset(i);
            String line = editor.getDocument().getText(new TextRange(lineStartOffset, lineEndOffset));
            int startOffset = HighlighterDrawUtil.getStartValidCharOffset(editor.getDocument(), lineStartOffset);
            Point start = editor.visualPositionToXY(editor.offsetToVisualPosition(startOffset));
            Point end = editor.visualPositionToXY(editor.offsetToVisualPosition(lineEndOffset));
            if (line.isEmpty()) {
                start.x = Integer.MAX_VALUE;
            }
            if (startPoint == null) {
                startPoint = start;
            } else {
                if (start.y < startPoint.y) {
                    startPoint.y = start.y;
                }
                if (start.x < startPoint.x) {
                    startPoint.x = start.x;
                }
            }
            if (endPoint == null) {
                endPoint = end;
                continue;
            }
            if (end.y > endPoint.y) {
                endPoint.y = end.y;
            }
            if (end.x <= endPoint.x) continue;
            endPoint.x = end.x;
        }
        if (startPoint == null) {
            return null;
        }
        if (startPoint.x == Integer.MAX_VALUE) {
            startPoint.x = 0;
        }
        return new DiffChangeRange(startPoint, endPoint, minStartOffset, maxEndOffset);
    }

    public static int getFirstOriginStartLine(@NotNull Editor editor, @NotNull List<LineFragment> diffResult, RewriteCodeAction item) {
        if (editor == null) {
            HighlighterDrawUtil.$$$reportNull$$$0(20);
        }
        if (diffResult == null) {
            HighlighterDrawUtil.$$$reportNull$$$0(21);
        }
        int minStartLine = Integer.MAX_VALUE;
        int startOffsetOfLine = editor.getDocument().getLineStartOffset(item.getEditRange().getStart().getLine());
        for (LineFragment fragment : diffResult) {
            LineFragment absoluteChange = DiffUtil.addOffset(fragment, item.getEditRange().getStart().getLine(), startOffsetOfLine);
            minStartLine = Math.min(minStartLine, absoluteChange.getStartLine1());
        }
        return minStartLine;
    }

    public static int getStartValidCharOffset(Document document, int offset) {
        char ch;
        while (offset < document.getTextLength() && Character.isWhitespace(ch = document.getCharsSequence().charAt(offset)) && ch != '\n') {
            ++offset;
        }
        return offset;
    }

    public static RangeHighlighter drawSectionHighlight(@NotNull Editor editor, int startOffset, int endOffset, Point startPoint, Point endPoint, boolean needRoundRect) {
        if (editor == null) {
            HighlighterDrawUtil.$$$reportNull$$$0(22);
        }
        MarkupModel markupModel = editor.getMarkupModel();
        RangeHighlighter highlighter = markupModel.addRangeHighlighter(startOffset, endOffset, 6000, null, HighlighterTargetArea.EXACT_RANGE);
        highlighter.setCustomRenderer((CustomHighlighterRenderer)new MultiLineBorderHighlightRender(startPoint, endPoint, needRoundRect));
        return highlighter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: 
            case 6: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/alibabacloud/intellij/cosy/editor/render/HighlighterDrawUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerFragments";
                break;
            }
            case 14: 
            case 16: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diffResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/alibabacloud/intellij/cosy/editor/render/HighlighterDrawUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createDeletionHighlighters";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createDeletionWordHighlighters";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createInsertionHighlighters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createDeletionHighlighters";
                break;
            }
            case 2: 
            case 6: 
            case 11: 
            case 12: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createDeletionWordHighlighters";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createInsertionHighlighters";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createMultilineHighlight";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createMultilineInnerHighlight";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getStartAndEndDiffPoint";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getFirstOriginStartLine";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "drawSectionHighlight";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DiffChangeRange {
        Point startPoint;
        Point endPoint;
        int minStartOffset;
        int maxEndOffset;

        @Generated
        public Point getStartPoint() {
            return this.startPoint;
        }

        @Generated
        public Point getEndPoint() {
            return this.endPoint;
        }

        @Generated
        public int getMinStartOffset() {
            return this.minStartOffset;
        }

        @Generated
        public int getMaxEndOffset() {
            return this.maxEndOffset;
        }

        @Generated
        public void setStartPoint(Point startPoint) {
            this.startPoint = startPoint;
        }

        @Generated
        public void setEndPoint(Point endPoint) {
            this.endPoint = endPoint;
        }

        @Generated
        public void setMinStartOffset(int minStartOffset) {
            this.minStartOffset = minStartOffset;
        }

        @Generated
        public void setMaxEndOffset(int maxEndOffset) {
            this.maxEndOffset = maxEndOffset;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DiffChangeRange)) {
                return false;
            }
            DiffChangeRange other = (DiffChangeRange)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Point this$startPoint = this.getStartPoint();
            Point other$startPoint = other.getStartPoint();
            if (this$startPoint == null ? other$startPoint != null : !((Object)this$startPoint).equals(other$startPoint)) {
                return false;
            }
            Point this$endPoint = this.getEndPoint();
            Point other$endPoint = other.getEndPoint();
            if (this$endPoint == null ? other$endPoint != null : !((Object)this$endPoint).equals(other$endPoint)) {
                return false;
            }
            if (this.getMinStartOffset() != other.getMinStartOffset()) {
                return false;
            }
            return this.getMaxEndOffset() == other.getMaxEndOffset();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DiffChangeRange;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Point $startPoint = this.getStartPoint();
            result = result * 59 + ($startPoint == null ? 43 : ((Object)$startPoint).hashCode());
            Point $endPoint = this.getEndPoint();
            result = result * 59 + ($endPoint == null ? 43 : ((Object)$endPoint).hashCode());
            result = result * 59 + this.getMinStartOffset();
            result = result * 59 + this.getMaxEndOffset();
            return result;
        }

        @Generated
        public String toString() {
            return "HighlighterDrawUtil.DiffChangeRange(startPoint=" + this.getStartPoint() + ", endPoint=" + this.getEndPoint() + ", minStartOffset=" + this.getMinStartOffset() + ", maxEndOffset=" + this.getMaxEndOffset() + ")";
        }

        @Generated
        public DiffChangeRange() {
        }

        @Generated
        public DiffChangeRange(Point startPoint, Point endPoint, int minStartOffset, int maxEndOffset) {
            this.startPoint = startPoint;
            this.endPoint = endPoint;
            this.minStartOffset = minStartOffset;
            this.maxEndOffset = maxEndOffset;
        }
    }

    static class MultiLineBorderHighlightRender
    implements CustomHighlighterRenderer {
        Point startPoint;
        Point endPoint;
        boolean needRoundRect;

        public MultiLineBorderHighlightRender(Point startPoint, Point endPoint, boolean needRoundRect) {
            this.startPoint = startPoint;
            this.endPoint = endPoint;
            this.needRoundRect = needRoundRect;
        }

        public void paint(@NotNull Editor editor, @NotNull RangeHighlighter rangeHighlighter, @NotNull Graphics graphics) {
            if (editor == null) {
                MultiLineBorderHighlightRender.$$$reportNull$$$0(0);
            }
            if (rangeHighlighter == null) {
                MultiLineBorderHighlightRender.$$$reportNull$$$0(1);
            }
            if (graphics == null) {
                MultiLineBorderHighlightRender.$$$reportNull$$$0(2);
            }
            int width = this.endPoint.x - this.startPoint.x;
            int height = this.endPoint.y - this.startPoint.y + editor.getLineHeight();
            Graphics2D g2d = (Graphics2D)graphics;
            GraphicsUtil.setupRoundedBorderAntialiasing((Graphics)g2d);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2d.setColor(ColorUtil.getDiffTypeBorderColor(editor, TextDiffType.DELETED));
            g2d.setStroke(new BasicStroke(1.0f));
            if (this.needRoundRect) {
                g2d.drawRoundRect(this.startPoint.x, this.startPoint.y, JBUIScale.scale((int)width), JBUIScale.scale((int)height), JBUIScale.scale((int)8), JBUIScale.scale((int)8));
            } else {
                g2d.drawRect(this.startPoint.x, this.startPoint.y, JBUIScale.scale((int)width), JBUIScale.scale((int)height));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rangeHighlighter";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "graphics";
                    break;
                }
            }
            objectArray[1] = "com/alibabacloud/intellij/cosy/editor/render/HighlighterDrawUtil$MultiLineBorderHighlightRender";
            objectArray[2] = "paint";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

