/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.editor.model;

import com.alibabacloud.intellij.cosy.editor.model.InlineEditRequest;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import lombok.Generated;

public class InlineEditSession
implements Disposable {
    private final String sessionId = UUID.randomUUID().toString();
    private List<InlineEditRequest> requests = new CopyOnWriteArrayList<InlineEditRequest>();
    private Map<String, InlineEditRequest> requestMap = new ConcurrentHashMap<String, InlineEditRequest>();

    public void addRequest(InlineEditRequest request) {
        this.requests.add(request);
        this.requestMap.put(request.getRequestId(), request);
        Disposer.register((Disposable)this, (Disposable)request);
        request.setSessionId(this.sessionId);
    }

    public InlineEditRequest getLastRequest() {
        if (!this.requests.isEmpty()) {
            return this.requests.get(this.requests.size() - 1);
        }
        return null;
    }

    public int getRequestCount() {
        return this.requests.size();
    }

    public InlineEditRequest getCurrentRequest() {
        if (!this.requests.isEmpty()) {
            return this.requests.get(this.requests.size() - 1);
        }
        return null;
    }

    public InlineEditRequest getRequestById(String requestId) {
        return this.requestMap.get(requestId);
    }

    public void dispose() {
        if (this.requests != null) {
            for (InlineEditRequest request : this.requests) {
                Disposer.dispose((Disposable)request);
            }
            this.requests.clear();
        }
    }

    @Generated
    public String getSessionId() {
        return this.sessionId;
    }

    @Generated
    public List<InlineEditRequest> getRequests() {
        return this.requests;
    }

    @Generated
    public Map<String, InlineEditRequest> getRequestMap() {
        return this.requestMap;
    }

    @Generated
    public void setRequests(List<InlineEditRequest> requests) {
        this.requests = requests;
    }

    @Generated
    public void setRequestMap(Map<String, InlineEditRequest> requestMap) {
        this.requestMap = requestMap;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InlineEditSession)) {
            return false;
        }
        InlineEditSession other = (InlineEditSession)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$sessionId = this.getSessionId();
        String other$sessionId = other.getSessionId();
        if (this$sessionId == null ? other$sessionId != null : !this$sessionId.equals(other$sessionId)) {
            return false;
        }
        List<InlineEditRequest> this$requests = this.getRequests();
        List<InlineEditRequest> other$requests = other.getRequests();
        if (this$requests == null ? other$requests != null : !((Object)this$requests).equals(other$requests)) {
            return false;
        }
        Map<String, InlineEditRequest> this$requestMap = this.getRequestMap();
        Map<String, InlineEditRequest> other$requestMap = other.getRequestMap();
        return !(this$requestMap == null ? other$requestMap != null : !((Object)this$requestMap).equals(other$requestMap));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InlineEditSession;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $sessionId = this.getSessionId();
        result = result * 59 + ($sessionId == null ? 43 : $sessionId.hashCode());
        List<InlineEditRequest> $requests = this.getRequests();
        result = result * 59 + ($requests == null ? 43 : ((Object)$requests).hashCode());
        Map<String, InlineEditRequest> $requestMap = this.getRequestMap();
        result = result * 59 + ($requestMap == null ? 43 : ((Object)$requestMap).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "InlineEditSession(sessionId=" + this.getSessionId() + ", requests=" + this.getRequests() + ", requestMap=" + this.getRequestMap() + ")";
    }
}

