/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.editor.cache;

import com.alibabacloud.intellij.cosy.editor.model.InlineEditArea;
import com.alibabacloud.intellij.cosy.editor.model.InlineEditRequest;
import com.alibabacloud.intellij.cosy.util.EditorUtil;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class InlineEditCache {
    private static final Logger LOG = Logger.getInstance(InlineEditCache.class);
    private static final Cache<String, Boolean> nesLineTriggerCaches = Caffeine.newBuilder().expireAfterWrite(10L, TimeUnit.SECONDS).maximumSize(100L).build();
    private static final Cache<String, String> nesLineContentTriggerCaches = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).maximumSize(100L).build();
    private static final Cache<String, InlineEditArea> escapeAreaCaches = Caffeine.newBuilder().expireAfterWrite(10L, TimeUnit.SECONDS).maximumSize(100L).build();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkNesLineRepeatTrigger(@NotNull Editor editor) {
        if (editor == null) {
            InlineEditCache.$$$reportNull$$$0(0);
        }
        Cache<String, Boolean> cache = nesLineTriggerCaches;
        synchronized (cache) {
            int lineNumber = editor.getCaretModel().getLogicalPosition().line;
            VirtualFile vf = FileDocumentManager.getInstance().getFile(editor.getDocument());
            if (vf == null) {
                return true;
            }
            String cacheKey = String.format("%s_%s", vf.getPath(), lineNumber);
            Boolean triggered = (Boolean)nesLineTriggerCaches.getIfPresent((Object)cacheKey);
            if (triggered != null && triggered.booleanValue()) {
                LOG.debug(String.format("Caret line repeat click, skip trigger inline edit, lineNumber: %s", lineNumber));
                return true;
            }
            nesLineTriggerCaches.put((Object)cacheKey, (Object)true);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkNesLineContentChangeTrigger(@NotNull Editor editor) {
        if (editor == null) {
            InlineEditCache.$$$reportNull$$$0(1);
        }
        Cache<String, String> cache = nesLineContentTriggerCaches;
        synchronized (cache) {
            int lineNumber = editor.getCaretModel().getLogicalPosition().line;
            VirtualFile vf = FileDocumentManager.getInstance().getFile(editor.getDocument());
            if (vf == null) {
                return true;
            }
            int startLine = lineNumber - 3;
            int endLine = lineNumber + 3;
            startLine = Math.max(0, startLine);
            endLine = Math.min(endLine, editor.getDocument().getLineCount() - 1);
            String cacheKey = String.format("%s_%d_%d", vf.getPath(), startLine, endLine);
            String currentContent = EditorUtil.getContentByRange(editor.getDocument(), startLine, endLine);
            String cachedContent = (String)nesLineContentTriggerCaches.getIfPresent((Object)cacheKey);
            if (cachedContent == null || !cachedContent.equals(currentContent)) {
                LOG.debug(String.format("Content changed or no cache, allow trigger inline edit, lineNumber: %d", lineNumber));
                return false;
            }
            LOG.debug(String.format("Content not changed within cache time, skip trigger inline edit, lineNumber: %d", lineNumber));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recordNesLineContentChangeCache(Document document, int lineNumber) {
        Cache<String, String> cache = nesLineContentTriggerCaches;
        synchronized (cache) {
            VirtualFile vf = FileDocumentManager.getInstance().getFile(document);
            if (vf == null) {
                return;
            }
            int startLine = lineNumber - 3;
            int endLine = lineNumber + 3;
            startLine = Math.max(0, startLine);
            endLine = Math.min(endLine, document.getLineCount() - 1);
            String cacheKey = String.format("%s_%d_%d", vf.getPath(), startLine, endLine);
            String currentContent = EditorUtil.getContentByRange(document, startLine, endLine);
            nesLineContentTriggerCaches.put((Object)cacheKey, (Object)currentContent);
        }
    }

    public static void recordEscapeArea(@NotNull Editor editor, InlineEditRequest request) {
        VirtualFile vf;
        if (editor == null) {
            InlineEditCache.$$$reportNull$$$0(2);
        }
        if ((vf = FileDocumentManager.getInstance().getFile(editor.getDocument())) == null) {
            return;
        }
        int lineNumber = 0;
        lineNumber = request.getCursorOffset() >= editor.getDocument().getTextLength() ? editor.getDocument().getLineCount() - 1 : editor.getDocument().getLineNumber(request.getCursorOffset());
        int startLine = lineNumber - 3;
        int endLine = lineNumber + 3;
        startLine = Math.max(0, startLine);
        endLine = Math.min(endLine, editor.getDocument().getLineCount() - 1);
        String key = String.format("area-%s-%d-%d", vf.getPath(), startLine, endLine);
        escapeAreaCaches.put((Object)key, (Object)new InlineEditArea(startLine, endLine));
    }

    public static boolean checkEscapeArea(@NotNull Editor editor, int offset) {
        VirtualFile vf;
        if (editor == null) {
            InlineEditCache.$$$reportNull$$$0(3);
        }
        if ((vf = FileDocumentManager.getInstance().getFile(editor.getDocument())) == null) {
            return false;
        }
        int lineNumber = editor.getDocument().getLineNumber(offset);
        int startLine = lineNumber - 3;
        int endLine = lineNumber + 3;
        startLine = Math.max(0, startLine);
        endLine = Math.min(endLine, editor.getDocument().getLineCount() - 1);
        String key = String.format("area-%s-%d-%d", vf.getPath(), startLine, endLine);
        InlineEditArea area = (InlineEditArea)escapeAreaCaches.getIfPresent((Object)key);
        return area != null && area.isInRange(lineNumber);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "editor";
        objectArray2[1] = "com/alibabacloud/intellij/cosy/editor/cache/InlineEditCache";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkNesLineRepeatTrigger";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "checkNesLineContentChangeTrigger";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "recordEscapeArea";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkEscapeArea";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

