/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.editor.action;

import com.alibabacloud.intellij.cosy.core.lsp.model.model.InlineEditActionMessage;
import com.alibabacloud.intellij.cosy.editor.CosyInlineEditManager;
import com.alibabacloud.intellij.cosy.editor.action.InlineEditActionHandler;
import com.alibabacloud.intellij.cosy.editor.action.RewriteCodeActionHandler;
import com.alibabacloud.intellij.cosy.search.enums.InlineTriggerModeEnum;
import com.alibabacloud.intellij.cosy.util.EditorUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;

public class TriggerEditActionHandler
implements InlineEditActionHandler {
    private static final Logger LOG = Logger.getInstance(RewriteCodeActionHandler.class);

    @Override
    public boolean handle(InlineEditActionMessage message) {
        ApplicationManager.getApplication().invokeLater(() -> {
            Editor editor = EditorUtil.getSelectedEditorSafely(message.getProject());
            if (null != editor) {
                int offset = editor.getCaretModel().getOffset();
                int lineNumber = editor.getDocument().getLineNumber(offset);
                this.inlineEditOnLine(editor, lineNumber);
            }
        });
        return true;
    }

    private void inlineEditOnLine(Editor editor, int lineNumber) {
        LOG.debug("trigger inline edit action: " + lineNumber);
        int offset = editor.getDocument().getLineEndOffset(lineNumber);
        CosyInlineEditManager.getInstance().inlineEdit(editor, offset, InlineTriggerModeEnum.AUTO);
    }
}

