/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.editor.action;

import com.alibabacloud.intellij.cosy.common.CosyCacheKeys;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.InlineEditActionMessage;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.RewriteCodeAction;
import com.alibabacloud.intellij.cosy.editor.action.InlineActionType;
import com.alibabacloud.intellij.cosy.editor.action.InlineEditActionHandler;
import com.alibabacloud.intellij.cosy.editor.model.InlineEditRequest;
import com.alibabacloud.intellij.cosy.editor.model.InlineEditSession;
import com.alibabacloud.intellij.cosy.ui.statusbar.CosyStatusBarWidget;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.util.UserDataHolder;
import org.apache.commons.lang3.StringUtils;

public class RewriteCodeActionHandler
implements InlineEditActionHandler {
    private static final Logger LOG = Logger.getInstance(RewriteCodeActionHandler.class);
    private final Gson gson = new Gson();

    @Override
    public boolean handle(InlineEditActionMessage message) {
        if (message.getProject() == null || !message.getProject().isOpen()) {
            LOG.warn("Project is null or closed");
            return false;
        }
        try {
            InlineEditSession session = (InlineEditSession)CosyCacheKeys.KEY_INLINE_EDIT_SESSION.get((UserDataHolder)message.getProject());
            if (session == null || !message.getSessionId().equals(session.getSessionId())) {
                LOG.warn("Session is null or mismatched");
                return false;
            }
            InlineEditRequest currentRequest = session.getRequestById(message.getRequestId());
            if (currentRequest == null || !currentRequest.getRequestId().equals(message.getRequestId()) || currentRequest.isCanceled()) {
                LOG.warn("Request already canceled or new request initiated");
                return false;
            }
            if (currentRequest.getEditor().isDisposed()) {
                LOG.warn("Editor is disposed");
                return false;
            }
            currentRequest.setCacheRequestId(message.getCacheId());
            RewriteCodeAction item = (RewriteCodeAction)this.gson.fromJson((JsonElement)message.getData(), RewriteCodeAction.class);
            if (item == null || StringUtils.isBlank((CharSequence)item.getContent()) || item.getEditRange() == null) {
                LOG.warn("Invalid inline edit item: " + item);
                return false;
            }
            currentRequest.setActionResult(InlineActionType.REWRITE_CODE.getActionType(), item);
            Document document = currentRequest.getEditor().getDocument();
            if (document instanceof DocumentImpl && !((DocumentImpl)document).acceptsSlashR()) {
                item.setContent(StringUtils.remove((String)item.getContent(), (char)'\r'));
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                currentRequest.getRender().renderInlineEditItem(item);
                CosyStatusBarWidget.setStatusBarGenerating(message.getProject(), false, false);
            });
            return true;
        }
        catch (Exception e) {
            LOG.error("Failed to handle rewrite code action", (Throwable)e);
            return false;
        }
    }
}

