/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.editor.action;

import com.alibabacloud.intellij.cosy.common.CosyCacheKeys;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.InlineEditActionMessage;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.NextEditLocationAction;
import com.alibabacloud.intellij.cosy.editor.CosyInlineEditManager;
import com.alibabacloud.intellij.cosy.editor.action.InlineActionType;
import com.alibabacloud.intellij.cosy.editor.action.InlineEditActionHandler;
import com.alibabacloud.intellij.cosy.editor.model.InlineEditRequest;
import com.alibabacloud.intellij.cosy.editor.model.InlineEditSession;
import com.alibabacloud.intellij.cosy.search.enums.InlineTriggerModeEnum;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.UserDataHolder;

public class NextEditLocationActionHandler
implements InlineEditActionHandler {
    private static final Logger LOG = Logger.getInstance(NextEditLocationActionHandler.class);
    private final Gson gson = new Gson();

    @Override
    public boolean handle(InlineEditActionMessage message) {
        if (message.getProject() == null || !message.getProject().isOpen()) {
            LOG.warn("Project is null or closed");
            return false;
        }
        try {
            boolean hasRewriteCode;
            InlineEditSession session = (InlineEditSession)CosyCacheKeys.KEY_INLINE_EDIT_SESSION.get((UserDataHolder)message.getProject());
            if (session == null || !message.getSessionId().equals(session.getSessionId())) {
                return false;
            }
            InlineEditRequest currentRequest = session.getRequestById(message.getRequestId());
            if (currentRequest == null || !currentRequest.getRequestId().equals(message.getRequestId()) || currentRequest.isCanceled()) {
                LOG.warn("Request already canceled or new request initiated");
                return false;
            }
            currentRequest.setCacheRequestId(message.getCacheId());
            JsonObject data = message.getData();
            if (data == null) {
                LOG.warn("Empty data in next_edit_location message");
                return false;
            }
            NextEditLocationAction item = (NextEditLocationAction)this.gson.fromJson((JsonElement)message.getData(), NextEditLocationAction.class);
            if (item == null || item.getNextLineNumber() == null) {
                LOG.warn("Invalid next edit location item: " + item);
                return false;
            }
            boolean bl = hasRewriteCode = item.getHasRewriteCode() != null && item.getHasRewriteCode() != false;
            if (hasRewriteCode) {
                currentRequest.setActionResult(InlineActionType.NEXT_EDIT_LOCATION.getActionType(), item);
                LOG.debug("Cached next edit location: " + item.getNextLineNumber());
                return true;
            }
            int nextLine = item.getNextLineNumber();
            Editor editor = currentRequest.getEditor();
            ApplicationManager.getApplication().invokeLater(() -> this.inlineEditOnLine(editor, nextLine));
            return true;
        }
        catch (Exception e) {
            LOG.error("Failed to handle next edit location action", (Throwable)e);
            return false;
        }
    }

    private void inlineEditOnLine(Editor editor, int lineNumber) {
        LOG.debug("trigger inline edit at next edit location: " + lineNumber);
        int offset = editor.getDocument().getLineEndOffset(lineNumber);
        CosyInlineEditManager.getInstance().inlineEdit(editor, offset, InlineTriggerModeEnum.AUTO);
    }
}

