/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.editor.action;

import com.alibabacloud.intellij.cosy.common.CosyCacheKeys;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.InlineEditActionMessage;
import com.alibabacloud.intellij.cosy.editor.action.InlineActionType;
import com.alibabacloud.intellij.cosy.editor.action.InlineEditActionHandler;
import com.alibabacloud.intellij.cosy.editor.model.InlineEditRequest;
import com.alibabacloud.intellij.cosy.editor.model.InlineEditSession;
import com.alibabacloud.intellij.cosy.ui.statusbar.CosyStatusBarWidget;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.UserDataHolder;
import javax.swing.SwingUtilities;

public class InlineEditActionDispatcher {
    private static final Logger LOG = Logger.getInstance(InlineEditActionDispatcher.class);

    public void dispatch(InlineEditActionMessage message) {
        if (message == null) {
            LOG.warn("Received null action message");
            return;
        }
        LOG.debug("Dispatching inline edit action: " + message.getAction());
        if (!message.isSuccess()) {
            LOG.warn("Received unsuccessful action message: " + message.getMessage());
            return;
        }
        InlineEditSession session = (InlineEditSession)CosyCacheKeys.KEY_INLINE_EDIT_SESSION.get((UserDataHolder)message.getProject());
        if (session == null || !message.getSessionId().equals(session.getSessionId())) {
            LOG.warn("Session is null or mismatched");
            return;
        }
        InlineEditRequest currentRequest = session.getRequestById(message.getRequestId());
        if (currentRequest == null || !currentRequest.getRequestId().equals(message.getRequestId()) || currentRequest.isCanceled()) {
            LOG.warn("Request already canceled or new request initiated");
            return;
        }
        if (currentRequest.getEditor().isDisposed()) {
            LOG.warn("Editor is disposed");
            return;
        }
        currentRequest.setCacheRequestId(message.getCacheId());
        this.doDispatch(message);
    }

    private void doDispatch(InlineEditActionMessage message) {
        String actionType = message.getAction();
        InlineActionType actionTypeEnum = InlineActionType.getByActionType(actionType);
        boolean handled = false;
        InlineEditActionHandler handler = actionTypeEnum.getActionHandler();
        if (handler != null) {
            try {
                handled = handler.handle(message);
                if (handled) {
                    LOG.debug("Action " + actionType + " handled successfully");
                } else {
                    LOG.warn("Action " + actionType + " not handled");
                }
                SwingUtilities.invokeLater(() -> CosyStatusBarWidget.setStatusBarGenerating(message.getProject(), false, false));
            }
            catch (Exception e) {
                LOG.warn("Error handling action " + actionType, (Throwable)e);
            }
        }
        if (!handled) {
            LOG.warn("No handler found or failed to handle action type: " + actionType);
        }
    }
}

