/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.editor;

import com.alibabacloud.intellij.cosy.ui.search.Constants;
import com.alibabacloud.intellij.cosy.ui.search.component.textpane.RichTextPane;
import com.alibabacloud.intellij.cosy.ui.search.generate.input.ChatInputTextArea;
import com.alibabacloud.intellij.cosy.ui.search.topic.EditorFilePasteNotifier;
import com.intellij.codeInsight.editorActions.TextBlockTransferable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCopyPasteHelper;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actions.BasePasteHandler;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.Collections;
import javax.swing.JComponent;

public class LingmaEditorPasteActionHandler
extends BasePasteHandler {
    private static final Logger log = Logger.getInstance(LingmaEditorPasteActionHandler.class);
    EditorActionHandler handler;

    public LingmaEditorPasteActionHandler(EditorActionHandler handler) {
        this.handler = handler;
    }

    public void executeWriteAction(Editor editor, Caret caret, DataContext dataContext) {
        if (editor.getProject() != null) {
            ToolWindow toolWindow = ToolWindowManager.getInstance((Project)editor.getProject()).getToolWindow(Constants.PLUGIN_NAME);
            if (toolWindow == null || !toolWindow.isVisible()) {
                this.handler.execute(editor, caret, dataContext);
                return;
            }
        } else {
            this.handler.execute(editor, caret, dataContext);
            return;
        }
        TextRange range = null;
        JComponent contentComponent = editor.getContentComponent();
        String sessionType = null;
        if (contentComponent instanceof ChatInputTextArea) {
            ChatInputTextArea textArea = (ChatInputTextArea)contentComponent;
            sessionType = textArea.getChatInputContext().getSessionType();
        }
        if (this.myTransferable != null) {
            if (editor.getComponent() instanceof RichTextPane) {
                if ((this.myTransferable.isDataFlavorSupported(DataFlavor.imageFlavor) || this.myTransferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) && editor.getProject() != null) {
                    ((EditorFilePasteNotifier)editor.getProject().getMessageBus().syncPublisher(EditorFilePasteNotifier.EDITOR_PASTE_FILE_NOTIFICATION)).notifyPasteFile(this.myTransferable, sessionType);
                } else {
                    String text = EditorModificationUtil.getStringContent((Transferable)this.myTransferable);
                    if (text != null) {
                        int textLength = text.length();
                        if (BasePasteHandler.isContentTooLarge((int)textLength)) {
                            throw new EditorCopyPasteHelper.TooLargeContentException(textLength);
                        }
                        CaretModel caretModel = editor.getCaretModel();
                        int caretOffset = caretModel.getOffset();
                        String normalizedText = TextBlockTransferable.convertLineSeparators((String)text, (String)"\n", Collections.emptyList());
                        try {
                            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)normalizedText, (boolean)false, (boolean)true);
                        }
                        catch (Exception e) {
                            log.warn("insertStringAtCaret error", (Throwable)e);
                        }
                        range = new TextRange(caretOffset, caretOffset + text.length());
                    }
                }
            } else {
                TextRange[] ranges = EditorCopyPasteHelper.getInstance().pasteTransferable(editor, this.myTransferable);
                if (ranges != null && ranges.length == 1) {
                    range = ranges[0];
                }
            }
        } else if (editor.getComponent() instanceof RichTextPane) {
            this.handleScreenShotImage(editor, sessionType);
        }
        editor.putUserData(EditorEx.LAST_PASTED_REGION, range);
    }

    private void handleScreenShotImage(Editor editor, String sessionType) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(editor.getComponent());
        if (transferable != null && transferable.isDataFlavorSupported(DataFlavor.imageFlavor) && editor.getProject() != null) {
            ((EditorFilePasteNotifier)editor.getProject().getMessageBus().syncPublisher(EditorFilePasteNotifier.EDITOR_PASTE_FILE_NOTIFICATION)).notifyPasteFile(transferable, sessionType);
        }
    }
}

