/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.editor;

import com.alibabacloud.intellij.cosy.common.CosyCacheKeys;
import com.alibabacloud.intellij.cosy.common.CosySetting;
import com.alibabacloud.intellij.cosy.completion.CosyCompletionService;
import com.alibabacloud.intellij.cosy.editor.CosyInlayManager;
import com.alibabacloud.intellij.cosy.editor.InlayCompletionCollector;
import com.alibabacloud.intellij.cosy.editor.InlayCompletionHintFactory;
import com.alibabacloud.intellij.cosy.editor.model.CosyEditorInlayItem;
import com.alibabacloud.intellij.cosy.editor.model.CosyEditorInlayList;
import com.alibabacloud.intellij.cosy.editor.model.InlayCompletionRequest;
import com.alibabacloud.intellij.cosy.editor.model.InlayDisposeEventEnum;
import com.alibabacloud.intellij.cosy.ui.config.CosyPersistentSetting;
import com.alibabacloud.intellij.cosy.ui.statusbar.CosyStatusBarWidget;
import com.alibabacloud.intellij.cosy.util.EditorUtil;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import java.awt.Point;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.lsp4j.CompletionItem;

public class DefaultInlayCompletionCollector
implements InlayCompletionCollector {
    private static final Logger LOGGER = Logger.getInstance(DefaultInlayCompletionCollector.class);
    private final Editor editor;
    private final InlayCompletionRequest request;
    private AtomicInteger selectItemIndex = new AtomicInteger(0);
    private AtomicBoolean firstResult = new AtomicBoolean(true);
    private AtomicBoolean requestFinished = new AtomicBoolean(false);
    private volatile int generateLen = 0;
    private volatile int generateTrimLen = 0;

    public DefaultInlayCompletionCollector(Editor editor, InlayCompletionRequest request) {
        this.editor = editor;
        this.request = request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCollect(CompletionItem completionItem) {
        CosyStatusBarWidget.clearStatusBarDebouncer();
        CosyStatusBarWidget.setStatusBarGenerating(this.editor.getProject(), true, false);
        LOGGER.debug(this.request.getParams().getRequestId() + " flow onNext");
        if (this.editor.getProject() == null || this.editor.getProject().isDisposed()) {
            return;
        }
        CosyEditorInlayItem item = CosyCompletionService.getInstance().convertInlayItem(this.request, completionItem, "");
        if (item == null) {
            LOGGER.debug("invalid item " + completionItem);
            return;
        }
        String content = item.getContent();
        Key<CosyEditorInlayList> key = CosyCacheKeys.KEY_COMPLETION_INLAY_ITEMS;
        synchronized (key) {
            InlayCompletionRequest req = (InlayCompletionRequest)CosyCacheKeys.KEY_COMPLETION_LATEST_REQUEST.get((UserDataHolder)this.editor);
            if (req == null || req.isCanceled()) {
                LOGGER.warn("ignore inlay completion result caused by invalid request");
                return;
            }
            String[] parts = StringUtils.splitByWholeSeparator((String)content, (String)"<|cursor|>");
            if (parts.length == 0 || this.generateLen > parts[0].length()) {
                LOGGER.debug("ignore less length item " + content);
                return;
            }
            this.generateLen = parts[0].length();
            this.generateTrimLen = parts[0].trim().length();
            CosyEditorInlayList list = (CosyEditorInlayList)CosyCacheKeys.KEY_COMPLETION_INLAY_ITEMS.get((UserDataHolder)this.editor);
            if (list == null) {
                list = new CosyEditorInlayList();
                list.setRequest(req);
            }
            if (this.firstResult.getAndSet(false)) {
                this.selectItemIndex.getAndSet(list.size());
                list.add(item);
            } else {
                list.replace(this.selectItemIndex.get(), item);
            }
            CosyCacheKeys.KEY_COMPLETION_INLAY_ITEMS.set((UserDataHolder)this.editor, (Object)list);
            CosyInlayManager.getInstance().disposeInlays(this.editor, InlayDisposeEventEnum.GENERATING);
            CosyInlayManager.getInstance().renderInlayCompletionItem(this.request, item);
        }
        if (this.isFinished(completionItem)) {
            LOGGER.debug(item.getRequestId() + "completion finished, cacheId:" + item.getCacheId());
            this.requestFinished.getAndSet(true);
            CosyStatusBarWidget.setStatusBarGenerating(this.editor.getProject(), false, false);
        }
    }

    private boolean isFinished(CompletionItem item) {
        if (item.getData() instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)item.getData();
            JsonElement finishedEl = jsonObject.get("finished");
            return finishedEl != null && finishedEl.getAsBoolean();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onComplete() {
        LOGGER.debug(this.request.getParams().getRequestId() + "flow onComplete");
        Key<CosyEditorInlayList> key = CosyCacheKeys.KEY_COMPLETION_INLAY_ITEMS;
        synchronized (key) {
            CosySetting setting;
            if (this.generateTrimLen > 0 && ((setting = CosyPersistentSetting.getInstance().getState()) == null || setting.isShowInlineAcceptTips() || setting.isShowInlineNextTips() && setting.isShowInlinePrevTips() || setting.isShowInlineTriggerTips()) && this.requestFinished.get()) {
                SwingUtilities.invokeLater(() -> {
                    if (this.editor.getProject() == null || this.editor.getProject().isDisposed() || this.editor.isDisposed()) {
                        return;
                    }
                    Point pos = EditorUtil.getEditorCaretPosition(this.editor);
                    LOGGER.debug("Inline hint position:" + pos);
                    InlayCompletionHintFactory.showHintAtCaret(this.editor);
                });
            }
        }
        boolean useDebounce = !this.requestFinished.get();
        CosyStatusBarWidget.setStatusBarGenerating(this.editor.getProject(), false, useDebounce);
    }
}

