/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.editor;

import com.alibabacloud.intellij.cosy.common.CosyCacheKeys;
import com.alibabacloud.intellij.cosy.concurrent.InlineEditActionProcessor;
import com.alibabacloud.intellij.cosy.core.Cosy;
import com.alibabacloud.intellij.cosy.core.lsp.LanguageWebSocketService;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.RewriteCodeAction;
import com.alibabacloud.intellij.cosy.editor.CosyInlineEditManager;
import com.alibabacloud.intellij.cosy.editor.action.InlineActionType;
import com.alibabacloud.intellij.cosy.editor.cache.InlineEditCache;
import com.alibabacloud.intellij.cosy.editor.inline.InlineEditUtil;
import com.alibabacloud.intellij.cosy.editor.model.DiffChangeModel;
import com.alibabacloud.intellij.cosy.editor.model.InlayDisposeEventEnum;
import com.alibabacloud.intellij.cosy.editor.model.InlineEditRequest;
import com.alibabacloud.intellij.cosy.editor.model.InlineEditSession;
import com.alibabacloud.intellij.cosy.editor.render.InsertedCodeInlayRenderer;
import com.alibabacloud.intellij.cosy.editor.request.InlineEditRequestBuilder;
import com.alibabacloud.intellij.cosy.search.enums.InlineTriggerModeEnum;
import com.alibabacloud.intellij.cosy.service.TelemetryService;
import com.alibabacloud.intellij.cosy.service.model.TextChangeContext;
import com.alibabacloud.intellij.cosy.util.EditorUtil;
import com.alibabacloud.intellij.cosy.util.LanguageUtil;
import com.alibabacloud.intellij.cosy.util.ThreadUtil;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.util.LineRange;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiFile;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class CosyInlineEditManagerImpl
implements CosyInlineEditManager {
    private static final Logger LOGGER = Logger.getInstance(CosyInlineEditManagerImpl.class);

    @Override
    public void inlineEdit(@NotNull Editor editor, InlineTriggerModeEnum triggerMode) {
        if (editor == null) {
            CosyInlineEditManagerImpl.$$$reportNull$$$0(0);
        }
        this.inlineEdit(editor, EditorUtil.getCaretOffset(editor), triggerMode);
    }

    @Override
    public void inlineEdit(@NotNull Editor editor, int cursorOffset, InlineTriggerModeEnum triggerMode) {
        if (editor == null) {
            CosyInlineEditManagerImpl.$$$reportNull$$$0(1);
        }
        this.inlineEdit(editor, cursorOffset, triggerMode, InlayDisposeEventEnum.TYPING);
    }

    @Override
    public void inlineEdit(@NotNull Editor editor, int cursorOffset, InlineTriggerModeEnum triggerMode, InlayDisposeEventEnum disposeEvent) {
        if (editor == null) {
            CosyInlineEditManagerImpl.$$$reportNull$$$0(2);
        }
        if (!InlineEditUtil.isEnableNES()) {
            return;
        }
        Project project = editor.getProject();
        if (!Cosy.INSTANCE.checkCosy(project, true)) {
            return;
        }
        InlineEditUtil.disposeAllInline(editor, disposeEvent);
        if (InlineEditCache.checkEscapeArea(editor, cursorOffset)) {
            LOGGER.info("Escape area, ignore inline edit at " + cursorOffset);
            return;
        }
        InlineEditRequestBuilder.build().generate(editor, cursorOffset, triggerMode);
    }

    @Override
    public boolean applyInlineEdit(@NotNull Editor editor) {
        if (editor == null) {
            CosyInlineEditManagerImpl.$$$reportNull$$$0(3);
        }
        if (editor.isDisposed()) {
            LOGGER.warn("Editor already disposed");
            InlineEditActionProcessor.INSTANCE.triggerNextConsumption(false);
            return false;
        }
        Project project = editor.getProject();
        if (project == null || project.isDisposed()) {
            LOGGER.warn("Project disposed or null: " + project);
            InlineEditActionProcessor.INSTANCE.triggerNextConsumption(false);
            return false;
        }
        InlineEditSession session = (InlineEditSession)CosyCacheKeys.KEY_INLINE_EDIT_SESSION.get((UserDataHolder)project);
        if (session == null) {
            InlineEditActionProcessor.INSTANCE.triggerNextConsumption(false);
            return false;
        }
        InlineEditRequest request = session.getCurrentRequest();
        if (request == null) {
            InlineEditActionProcessor.INSTANCE.triggerNextConsumption(false);
            return false;
        }
        RewriteCodeAction item = (RewriteCodeAction)request.getActionResult(InlineActionType.NEXT_EDIT.getActionType());
        if (item == null || item.getEditRange() == null) {
            LOGGER.warn("Invalid inline edit item: " + item);
            InlineEditActionProcessor.INSTANCE.triggerNextConsumption(false);
            return false;
        }
        if (request.isChangeActivated()) {
            this.disposeInlineEdits(editor, InlayDisposeEventEnum.ACCEPTED, null);
            this.applyEditChange(project, editor, request, item);
            InlineEditActionProcessor.INSTANCE.triggerNextConsumption(true);
        } else {
            this.activeToChangeLine(editor, request);
        }
        return true;
    }

    private void activeToChangeLine(@NotNull Editor editor, InlineEditRequest request) {
        if (editor == null) {
            CosyInlineEditManagerImpl.$$$reportNull$$$0(4);
        }
        int changeStartOffset = request.getRender().getDiffChangeModel().getLineStartOffsetBeforeChange(editor.getDocument());
        editor.getCaretModel().moveToOffset(changeStartOffset);
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        request.setRenderActive(true);
    }

    private void applyEditChange(@NotNull Project project, @NotNull Editor editor, InlineEditRequest request, RewriteCodeAction item) {
        if (project == null) {
            CosyInlineEditManagerImpl.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            CosyInlineEditManagerImpl.$$$reportNull$$$0(6);
        }
        DiffChangeModel diffChangeModel = request.getRender().getDiffChangeModel();
        String rewriteCode = diffChangeModel.getRewriteChangeCode();
        LineRange range = diffChangeModel.getOriginalChangeLineRange();
        Document document = editor.getDocument();
        WriteCommandAction.runWriteCommandAction((Project)project, (String)"Apply Tongyi Inline Edit", (String)"TONGYI", () -> {
            Object code = rewriteCode;
            if (document instanceof DocumentImpl && !((DocumentImpl)document).acceptsSlashR()) {
                code = StringUtils.remove((String)code, (char)'\r');
            }
            int startOffset = 0;
            startOffset = range.start >= document.getLineCount() ? document.getTextLength() : document.getLineStartOffset(range.start);
            if (range.start == range.end) {
                char lastChar;
                if (!((String)code).endsWith("\n")) {
                    code = (String)code + "\n";
                }
                if (range.start >= document.getLineCount() && document.getTextLength() > 0 && (lastChar = document.getText().charAt(document.getTextLength() - 1)) != '\n') {
                    code = "\n" + (String)code;
                }
                document.insertString(startOffset, (CharSequence)code);
            } else {
                String oldText;
                int endOffset = document.getLineEndOffset(range.end - 1) + 1;
                if (endOffset >= document.getTextLength() + 1) {
                    endOffset = document.getTextLength();
                }
                if ((oldText = document.getText(new TextRange(startOffset, endOffset))).endsWith("\n") && !"".equals(code) && !((String)code).endsWith("\n")) {
                    code = (String)code + "\n";
                }
                document.replaceString(startOffset, endOffset, (CharSequence)code);
            }
            int targetOffset = request.getRender().getDiffChangeModel().getEndOffsetAfterChange(document);
            if (targetOffset != -1) {
                editor.getCaretModel().moveToOffset(targetOffset);
            } else {
                editor.getCaretModel().moveToOffset(startOffset + ((String)code).length());
            }
            editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        }, (PsiFile[])new PsiFile[0]);
        ThreadUtil.execute(() -> {
            TelemetryService.getInstance().acceptInlineEdit(editor, request);
            String filePath = EditorUtil.getEditorFilePath(editor);
            String[] lines = item.getContent().split("\n", -1);
            for (LineFragment fragment : request.getRender().getDiffChangeModel().getDiffResult()) {
                if (fragment.getStartLine2() == fragment.getEndLine2()) continue;
                int lineNumber = fragment.getStartLine2() + item.getEditRange().getStart().getLine();
                CharSequence[] newLines = Arrays.copyOfRange(lines, fragment.getStartLine2(), fragment.getEndLine2());
                String content = String.join((CharSequence)"\n", newLines);
                TelemetryService.getInstance().telemetryTextChange(new TextChangeContext(editor.getProject(), filePath, content, lineNumber, true, LanguageUtil.getLanguageByFilePath(filePath), "nes"));
            }
        });
    }

    @Override
    public void disposeInlineEdits(@NotNull Editor editor, InlayDisposeEventEnum disposeAction, String commandName) {
        Project project;
        if (editor == null) {
            CosyInlineEditManagerImpl.$$$reportNull$$$0(7);
        }
        if (InlayDisposeEventEnum.ACCEPTED != disposeAction) {
            InlineEditActionProcessor.INSTANCE.triggerNextConsumption(false);
        }
        if ((project = editor.getProject()) == null || project.isDisposed()) {
            return;
        }
        boolean validDispose = false;
        List<Inlay<?>> inlays = EditorUtil.collectInlays(editor, 0, editor.getDocument().getTextLength());
        for (Inlay<?> inlay : inlays) {
            if (!(inlay.getRenderer() instanceof InsertedCodeInlayRenderer) || !inlay.isValid()) continue;
            ApplicationManager.getApplication().runReadAction(() -> Disposer.dispose((Disposable)inlay));
            validDispose = true;
        }
        InlineEditSession session = (InlineEditSession)CosyCacheKeys.KEY_INLINE_EDIT_SESSION.get((UserDataHolder)project);
        if (session == null) {
            return;
        }
        InlineEditRequest request = session.getCurrentRequest();
        if (request == null) {
            return;
        }
        boolean highlightDispose = this.clearInlineEditRender(project, editor, disposeAction, request);
        if (!InlayDisposeEventEnum.ACCEPTED.getName().equals(disposeAction.getName()) && (validDispose || highlightDispose)) {
            TelemetryService.getInstance().disposeInlineEdit(editor, request, disposeAction, commandName);
        }
    }

    private boolean clearInlineEditRender(@NotNull Project project, @NotNull Editor editor, @NotNull InlayDisposeEventEnum disposeAction, @NotNull InlineEditRequest request) {
        LanguageWebSocketService service;
        if (project == null) {
            CosyInlineEditManagerImpl.$$$reportNull$$$0(8);
        }
        if (editor == null) {
            CosyInlineEditManagerImpl.$$$reportNull$$$0(9);
        }
        if (disposeAction == null) {
            CosyInlineEditManagerImpl.$$$reportNull$$$0(10);
        }
        if (request == null) {
            CosyInlineEditManagerImpl.$$$reportNull$$$0(11);
        }
        if ((service = Cosy.INSTANCE.getLanguageService(project)) != null) {
            service.cancelInlayCompletion();
        }
        boolean hasShowingInlineEdit = request.getRender().hasShowingInlineEdit();
        if (InlayDisposeEventEnum.ACCEPTED == disposeAction) {
            request.onlyDisposeRender();
        } else {
            request.cancel();
        }
        if (InlayDisposeEventEnum.ESC_ACTION.getName().equals(disposeAction.getName())) {
            InlineEditCache.recordEscapeArea(editor, request);
        }
        return hasShowingInlineEdit;
    }

    @Override
    public boolean hasInlineEdits(@NotNull Editor editor) {
        Project project;
        if (editor == null) {
            CosyInlineEditManagerImpl.$$$reportNull$$$0(12);
        }
        if ((project = editor.getProject()) == null || project.isDisposed()) {
            return false;
        }
        InlineEditSession session = (InlineEditSession)CosyCacheKeys.KEY_INLINE_EDIT_SESSION.get((UserDataHolder)project);
        if (session == null) {
            return false;
        }
        InlineEditRequest request = session.getCurrentRequest();
        if (request == null) {
            return false;
        }
        return request.getRender().hasShowingInlineEdit();
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposeAction";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
        }
        objectArray2[1] = "com/alibabacloud/intellij/cosy/editor/CosyInlineEditManagerImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "inlineEdit";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "applyInlineEdit";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "activeToChangeLine";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "applyEditChange";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "disposeInlineEdits";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "clearInlineEditRender";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "hasInlineEdits";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

