/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.editor;

import com.alibabacloud.intellij.cosy.common.CosyConfig;
import com.alibabacloud.intellij.cosy.common.CosySetting;
import com.alibabacloud.intellij.cosy.editor.ChatHintSettings;
import com.alibabacloud.intellij.cosy.search.enums.MethodQuickSwitchEnum;
import com.alibabacloud.intellij.cosy.service.TelemetryService;
import com.alibabacloud.intellij.cosy.service.model.MethodHintPerformanceStat;
import com.alibabacloud.intellij.cosy.ui.config.CosyPersistentSetting;
import com.alibabacloud.intellij.cosy.ui.search.generate.ChatQuestionManager;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.util.IDEUtil;
import com.alibabacloud.intellij.cosy.util.LanguageUtil;
import com.alibabacloud.intellij.cosy.util.PsiUtils;
import com.alibabacloud.intellij.cosy.util.StopWatch;
import com.intellij.codeInsight.hints.ChangeListener;
import com.intellij.codeInsight.hints.FactoryInlayHintsCollector;
import com.intellij.codeInsight.hints.ImmediateConfigurable;
import com.intellij.codeInsight.hints.InlayHintsCollector;
import com.intellij.codeInsight.hints.InlayHintsProvider;
import com.intellij.codeInsight.hints.InlayHintsSink;
import com.intellij.codeInsight.hints.SettingsKey;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.codeInsight.hints.presentation.SequencePresentation;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.SmartList;
import icons.LingmaIcons;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseCosyEditorChatHintProvider
implements InlayHintsProvider<ChatHintSettings> {
    private static final Logger log = Logger.getInstance(BaseCosyEditorChatHintProvider.class);
    private static final String CODE_LENS_ID = "Lingma";
    private static final SettingsKey<ChatHintSettings> KEY = new SettingsKey("Lingma");

    @Nullable
    public InlayHintsCollector getCollectorFor(final @NotNull PsiFile file, @NotNull Editor editor, @NotNull ChatHintSettings settings, @NotNull InlayHintsSink __) {
        if (file == null) {
            BaseCosyEditorChatHintProvider.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            BaseCosyEditorChatHintProvider.$$$reportNull$$$0(1);
        }
        if (settings == null) {
            BaseCosyEditorChatHintProvider.$$$reportNull$$$0(2);
        }
        if (__ == null) {
            BaseCosyEditorChatHintProvider.$$$reportNull$$$0(3);
        }
        return new FactoryInlayHintsCollector(editor){

            public boolean collect(@NotNull PsiElement element, @NotNull Editor editor, @NotNull InlayHintsSink sink) {
                CosySetting setting;
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (editor == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (sink == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((setting = CosyPersistentSetting.getInstance().getState()) != null && setting.getMethodQuickSwitchEnum() != null && MethodQuickSwitchEnum.DISABLED.getType().equals(setting.getMethodQuickSwitchEnum().getType())) {
                    return true;
                }
                if (IDEUtil.ALL_IDE_WITH_METHOD_QUICK.stream().noneMatch(ide -> CosyConfig.IDE_NAME.toLowerCase(Locale.ROOT).contains((CharSequence)ide))) {
                    return true;
                }
                String language = LanguageUtil.getLanguageByFilePath(file.getName());
                StopWatch sw = new StopWatch();
                sw.start("checkPrevSibling");
                if (BaseCosyEditorChatHintProvider.this.checkPrevSibling(element.getPrevSibling())) {
                    BaseCosyEditorChatHintProvider.this.telemetryMethodHintMetric(editor, language, sw);
                    return true;
                }
                sw.stop();
                sw.start("checkPsiElementType");
                if (BaseCosyEditorChatHintProvider.this.checkPsiElementType(element)) {
                    BaseCosyEditorChatHintProvider.this.telemetryMethodHintMetric(editor, language, sw);
                    return true;
                }
                sw.stop();
                sw.start("checkIsInvalidMethod");
                if (BaseCosyEditorChatHintProvider.this.checkIsInvalidMethod(element)) {
                    BaseCosyEditorChatHintProvider.this.telemetryMethodHintMetric(editor, language, sw);
                    return true;
                }
                sw.stop();
                sw.start("addInlayPresentation");
                InlResult inlResult = new InlResult(){

                    @Override
                    public void onClick(final @NotNull Editor editor, final @NotNull PsiElement element, @NotNull MouseEvent event) {
                        if (editor == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (element == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (event == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        if (editor.getProject() == null) {
                            return;
                        }
                        List<ChatQuestionManager.ChatQuestion> popupActions = ChatQuestionManager.getMethodHintQuestions();
                        ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<ChatQuestionManager.ChatQuestion>("", popupActions){

                            @NotNull
                            public String getTextFor(ChatQuestionManager.ChatQuestion value) {
                                String string = value.getQuestion();
                                if (string == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                return string;
                            }

                            @Nullable
                            public PopupStep<?> onChosen(ChatQuestionManager.ChatQuestion selectedValue, boolean finalChoice) {
                                ActionManager actionManager = ActionManager.getInstance();
                                AnAction action = actionManager.getAction(selectedValue.getActionId());
                                BaseCosyEditorChatHintProvider.this.setSelectedRange(editor, element);
                                DataContext dataContext = DataManager.getInstance().getDataContext((Component)editor.getComponent());
                                AnActionEvent event = new AnActionEvent(null, dataContext, "MenuPopup", new Presentation(), actionManager, 0);
                                action.actionPerformed(event);
                                return FINAL_CHOICE;
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/alibabacloud/intellij/cosy/editor/BaseCosyEditorChatHintProvider$1$1$1", "getTextFor"));
                            }
                        });
                        popup.showInScreenCoordinates((Component)editor.getComponent(), event.getLocationOnScreen());
                    }

                    @Override
                    @NotNull
                    public String getRegularText() {
                        String string = CosyBundle.message("method.quick.ask.text", new Object[0]);
                        if (string == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        return string;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        RuntimeException runtimeException;
                        Object[] objectArray;
                        Object[] objectArray2;
                        int n2;
                        String string;
                        switch (n) {
                            default: {
                                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                break;
                            }
                            case 3: {
                                string = "@NotNull method %s.%s must not return null";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                n2 = 3;
                                break;
                            }
                            case 3: {
                                n2 = 2;
                                break;
                            }
                        }
                        Object[] objectArray3 = new Object[n2];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "editor";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "element";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "event";
                                break;
                            }
                            case 3: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/alibabacloud/intellij/cosy/editor/BaseCosyEditorChatHintProvider$1$1";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/alibabacloud/intellij/cosy/editor/BaseCosyEditorChatHintProvider$1$1";
                                break;
                            }
                            case 3: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getRegularText";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray;
                                objectArray[2] = "onClick";
                                break;
                            }
                            case 3: {
                                break;
                            }
                        }
                        String string2 = String.format(string, objectArray);
                        switch (n) {
                            default: {
                                runtimeException = new IllegalArgumentException(string2);
                                break;
                            }
                            case 3: {
                                runtimeException = new IllegalStateException(string2);
                                break;
                            }
                        }
                        throw runtimeException;
                    }
                };
                PresentationFactory factory = this.getFactory();
                Document document = editor.getDocument();
                int offset = BaseCosyEditorChatHintProvider.this.getAnchorOffset(element);
                int line = document.getLineNumber(offset);
                int startOffset = document.getLineStartOffset(line);
                String linePrefix = editor.getDocument().getText(new TextRange(startOffset, offset));
                int column = (offset += BaseCosyEditorChatHintProvider.this.findRealOffsetBySpace(editor, linePrefix)) - startOffset;
                SmartList presentations = new SmartList();
                presentations.add(factory.textSpacePlaceholder(column, true));
                presentations.add(factory.smallScaledIcon(LingmaIcons.QuickLogoIcon));
                presentations.add(factory.smallScaledIcon(AllIcons.Actions.FindAndShowNextMatchesSmall));
                presentations.add(factory.textSpacePlaceholder(1, true));
                SequencePresentation shiftedPresentation = new SequencePresentation((List)presentations);
                InlayPresentation finalPresentation = factory.referenceOnHover((InlayPresentation)shiftedPresentation, (event, translated) -> inlResult.onClick(editor, element, event));
                sink.addBlockElement(startOffset, true, true, 300, finalPresentation);
                BaseCosyEditorChatHintProvider.this.telemetryMethodHintMetric(editor, language, sw);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "editor";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "sink";
                        break;
                    }
                }
                objectArray[1] = "com/alibabacloud/intellij/cosy/editor/BaseCosyEditorChatHintProvider$1";
                objectArray[2] = "collect";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private void telemetryMethodHintMetric(@NotNull Editor editor, String language, StopWatch sw) {
        if (editor == null) {
            BaseCosyEditorChatHintProvider.$$$reportNull$$$0(4);
        }
        try {
            sw.stop();
            TelemetryService.getInstance().telemetryMethodHintPerformance(editor.getProject(), new MethodHintPerformanceStat(language, sw.getTimeMap()));
        }
        catch (Exception e) {
            log.warn("telemetryMethodHintMetric error", (Throwable)e);
        }
    }

    protected boolean checkPrevSibling(PsiElement prevSibling) {
        return prevSibling != null && (!(prevSibling instanceof PsiWhiteSpace) || !prevSibling.textContains('\n'));
    }

    protected boolean checkPsiElementType(PsiElement element) {
        return !PsiUtils.instanceOf((Object)element, this.getFunctionClassNames()) || PsiUtils.instanceOf((Object)element, "com.intellij.psi.PsiTypeParameter");
    }

    protected abstract String[] getFunctionClassNames();

    protected abstract boolean checkIsInvalidMethod(@NotNull PsiElement var1);

    private int findRealOffsetBySpace(@NotNull Editor editor, String linePrefix) {
        if (editor == null) {
            BaseCosyEditorChatHintProvider.$$$reportNull$$$0(5);
        }
        int tabWidth = editor.getSettings().getTabSize(editor.getProject());
        int totalOffset = 0;
        for (int i = 0; i < linePrefix.length(); ++i) {
            if (linePrefix.charAt(i) != '\t') continue;
            totalOffset += tabWidth;
        }
        return totalOffset;
    }

    protected int getAnchorOffset(@NotNull PsiElement element) {
        if (element == null) {
            BaseCosyEditorChatHintProvider.$$$reportNull$$$0(6);
        }
        return element.getTextRange().getStartOffset();
    }

    @NotNull
    public ChatHintSettings createSettings() {
        return new ChatHintSettings();
    }

    @NotNull
    public String getName() {
        String string = CosyBundle.message("cosy.plugin.name", new Object[0]);
        if (string == null) {
            BaseCosyEditorChatHintProvider.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public SettingsKey<ChatHintSettings> getKey() {
        SettingsKey<ChatHintSettings> settingsKey = KEY;
        if (settingsKey == null) {
            BaseCosyEditorChatHintProvider.$$$reportNull$$$0(8);
        }
        return settingsKey;
    }

    @NotNull
    public static SettingsKey<ChatHintSettings> getSettingsKey() {
        SettingsKey<ChatHintSettings> settingsKey = KEY;
        if (settingsKey == null) {
            BaseCosyEditorChatHintProvider.$$$reportNull$$$0(9);
        }
        return settingsKey;
    }

    public String getPreviewText() {
        return null;
    }

    @NotNull
    public ImmediateConfigurable createConfigurable(@NotNull ChatHintSettings settings) {
        if (settings == null) {
            BaseCosyEditorChatHintProvider.$$$reportNull$$$0(10);
        }
        return new ImmediateConfigurable(){

            @NotNull
            public JComponent createComponent(@NotNull ChangeListener listener) {
                if (listener == null) {
                    2.$$$reportNull$$$0(0);
                }
                JPanel panel = new JPanel();
                panel.setVisible(false);
                JPanel jPanel = panel;
                if (jPanel == null) {
                    2.$$$reportNull$$$0(1);
                }
                return jPanel;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "listener";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/alibabacloud/intellij/cosy/editor/BaseCosyEditorChatHintProvider$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/alibabacloud/intellij/cosy/editor/BaseCosyEditorChatHintProvider$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createComponent";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createComponent";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    public boolean isLanguageSupported(@NotNull Language language) {
        if (language == null) {
            BaseCosyEditorChatHintProvider.$$$reportNull$$$0(11);
        }
        return true;
    }

    public boolean isVisibleInSettings() {
        return true;
    }

    public void setSelectedRange(@NotNull Editor editor, @NotNull PsiElement element) {
        if (editor == null) {
            BaseCosyEditorChatHintProvider.$$$reportNull$$$0(12);
        }
        if (element == null) {
            BaseCosyEditorChatHintProvider.$$$reportNull$$$0(13);
        }
        TextRange range = element.getTextRange();
        editor.getSelectionModel().setSelection(range.getStartOffset(), range.getEndOffset());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "__";
                break;
            }
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/alibabacloud/intellij/cosy/editor/BaseCosyEditorChatHintProvider";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/alibabacloud/intellij/cosy/editor/BaseCosyEditorChatHintProvider";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettingsKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCollectorFor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "telemetryMethodHintMetric";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findRealOffsetBySpace";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAnchorOffset";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurable";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isLanguageSupported";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedRange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static interface InlResult {
        public void onClick(@NotNull Editor var1, @NotNull PsiElement var2, @NotNull MouseEvent var3);

        @NotNull
        public String getRegularText();
    }
}

