/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.core.websocket;

import com.alibabacloud.intellij.cosy.core.Cosy;
import com.alibabacloud.intellij.cosy.core.lsp.LanguageConnectClient;
import com.alibabacloud.intellij.cosy.core.lsp.model.LanguageServer;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.AuthStateEnum;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.AuthStatus;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.AuthWhitelistStatusEnum;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.PingResult;
import com.alibabacloud.intellij.cosy.util.LoginUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class CosyHeartbeatRunner
implements Runnable {
    private static final Logger log = Logger.getInstance(CosyHeartbeatRunner.class);
    private boolean isRunning = true;
    private long lastHeartbeat;
    private long lastGetState = System.currentTimeMillis();
    private static final long THREAD_LOOP_INTERVAL = TimeUnit.MINUTES.toMillis(1L);
    private static final long HEARTBEAT_INTERVAL = TimeUnit.MINUTES.toMillis(1L);
    private static final long GETSTATE_INTERVAL = TimeUnit.HOURS.toMillis(6L);
    private static final ByteBuffer pingBuffer = ByteBuffer.wrap("Ping".getBytes());
    private LanguageServer server;
    private Project project;
    private LanguageConnectClient languageConnectClient;

    public CosyHeartbeatRunner(Project project, LanguageConnectClient languageConnectClient, LanguageServer server) {
        this.languageConnectClient = languageConnectClient;
        this.server = server;
        this.project = project;
    }

    @Override
    public void run() {
        try {
            Thread.sleep(THREAD_LOOP_INTERVAL);
            while (this.isRunning) {
                if (!this.project.isOpen()) {
                    this.isRunning = false;
                    log.warn(this.getLogHeader() + "cosy project closed in heart beat check");
                    break;
                }
                long startTime = System.currentTimeMillis();
                if (startTime - this.lastGetState >= GETSTATE_INTERVAL) {
                    this.lastGetState = startTime;
                    if (!this.checkStatus()) break;
                }
                if (startTime - this.lastHeartbeat >= HEARTBEAT_INTERVAL) {
                    if (!this.checkPing()) break;
                    this.server.ping();
                    this.lastHeartbeat = startTime;
                }
                Thread.sleep(THREAD_LOOP_INTERVAL);
            }
        }
        catch (Exception e) {
            log.warn(this.getLogHeader() + "Heart beat exception:" + e.getMessage());
        }
    }

    private boolean checkStatus() {
        try {
            if (Cosy.INSTANCE.checkCosy(this.project)) {
                log.info(this.getLogHeader() + "cosy start get heart beat auth status");
                CompletableFuture<AuthStatus> future = this.server.getAuthService().status();
                AuthStatus status = future.get(3000L, TimeUnit.MILLISECONDS);
                if (status != null) {
                    log.info(this.getLogHeader() + "cosy get heart beat auth status " + status);
                    this.checkAuth(status);
                }
            }
        }
        catch (TimeoutException e) {
            log.warn(this.getLogHeader() + "cosy get auth status timeout in heartbeat");
        }
        catch (Exception e) {
            log.warn(this.getLogHeader() + "cosy get auth status in heartbeat error " + e.getMessage(), (Throwable)e);
        }
        if (!this.languageConnectClient.isSessionOpen()) {
            log.warn(this.getLogHeader() + "cosy session is closed. exit current thread");
            return false;
        }
        return true;
    }

    private boolean checkPing() {
        try {
            if (Cosy.INSTANCE.checkCosy(this.project)) {
                log.info(this.getLogHeader() + "cosy start ping heart beat");
                CompletableFuture<PingResult> future = this.server.ping();
                PingResult result = future.get(3000L, TimeUnit.MILLISECONDS);
                if (result != null && result.getSuccess().booleanValue()) {
                    log.info(this.getLogHeader() + "cosy ping heart beat succeed");
                } else {
                    log.warn(this.getLogHeader() + "cosy ping heart beat failed");
                }
            }
        }
        catch (TimeoutException e) {
            log.warn(this.getLogHeader() + "cosy ping timeout in heartbeat");
        }
        catch (Exception e) {
            log.warn(this.getLogHeader() + "cosy ping in heartbeat error " + e.getMessage(), (Throwable)e);
        }
        if (!this.languageConnectClient.isSessionOpen()) {
            log.warn(this.getLogHeader() + "cosy session is closed. exit current thread");
            return false;
        }
        return true;
    }

    private String getLogHeader() {
        return String.format("[%s] ", Thread.currentThread().getName());
    }

    private void checkAuth(AuthStatus status) {
        if (status.getStatus() == null) {
            status.setStatus(AuthStateEnum.NOT_LOGIN.getValue());
        }
        if (status.getWhitelist() == null) {
            status.setWhitelist(AuthWhitelistStatusEnum.UNKNOWN.getValue());
        }
        if (status.getStatus().intValue() == AuthStateEnum.ERROR.getValue() || status.getWhitelist().intValue() == AuthWhitelistStatusEnum.UNKNOWN.getValue()) {
            return;
        }
        LoginUtil.updateAuthStatus(this.project, status, true);
    }
}

