/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.core.pipe;

import com.alibabacloud.intellij.cosy.core.lsp.LanguageClientImpl;
import com.alibabacloud.intellij.cosy.core.lsp.LanguageConnectClient;
import com.alibabacloud.intellij.cosy.core.lsp.model.LanguageClient;
import com.alibabacloud.intellij.cosy.core.lsp.model.LanguageServer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.websocket.DeploymentException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.jetbrains.annotations.NotNull;

public class CosyStdioConnectClient
implements LanguageConnectClient {
    private static final Logger log = Logger.getInstance(CosyStdioConnectClient.class);
    private LanguageServer server;
    private final LanguageClient client;
    private final Project project;
    private final File homeDir;
    private final String workDir;
    private volatile Process process;
    private final String[] commands;

    public CosyStdioConnectClient(Project project, File homeDir, String workDir, String[] commands) {
        this.project = project;
        this.homeDir = homeDir;
        this.client = new LanguageClientImpl(project);
        this.commands = commands;
        this.workDir = workDir;
    }

    @Override
    public void connect() throws DeploymentException, IOException {
        long connectSt = System.currentTimeMillis();
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Process process;
            String[] extraPipeCommands = this.getExtraPipeCommands(this.project, this.homeDir, this.workDir);
            String[] fullCommands = this.buildFullCommands(extraPipeCommands);
            ProcessBuilder processBuilder = new ProcessBuilder(fullCommands);
            this.process = process = processBuilder.start();
            InputStream inputStream = process.getInputStream();
            OutputStream outputStream = process.getOutputStream();
            this.monitorLingmaProcessStdError(process.getErrorStream());
            Launcher launcher = Launcher.createLauncher((Object)this.client, LanguageServer.class, (InputStream)inputStream, (OutputStream)outputStream);
            launcher.startListening();
            this.server = (LanguageServer)launcher.getRemoteProxy();
            log.info(String.format("Cosy pipe startup succeed, cost %d ms", System.currentTimeMillis() - connectSt));
        }
        catch (Exception e) {
            log.error("Create Process encountered IO Exception", (Throwable)e);
            throw new IOException("Create Process encountered IO Exception");
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    private String @NotNull [] getExtraPipeCommands(Project project, File homeDir, String workDir) {
        String[] stringArray = new String[]{"--transportType", "stdio", "--workDir", workDir};
        if (stringArray == null) {
            CosyStdioConnectClient.$$$reportNull$$$0(0);
        }
        return stringArray;
    }

    private String[] buildFullCommands(String[] extraCommands) {
        ArrayList<String> commands = new ArrayList<String>();
        commands.addAll(Arrays.asList(this.commands));
        commands.addAll(Arrays.asList(extraCommands));
        return commands.toArray(new String[0]);
    }

    @Override
    public boolean isSessionOpen() {
        return this.process != null && this.process.isAlive();
    }

    @Override
    public void closeSession() {
        if (this.process != null) {
            this.process.destroy();
        }
    }

    @Override
    public LanguageServer getServer() {
        return this.server;
    }

    public LanguageClient getClient() {
        return this.client;
    }

    private void monitorLingmaProcessStdError(InputStream errorStream) {
        Thread t = new Thread(() -> {
            try {
                if (errorStream != null) {
                    List lines = IOUtils.readLines((InputStream)errorStream, (String)"utf-8");
                    String stderrMessage = StringUtils.join((Iterable)lines, (String)"\n");
                    if (StringUtils.isNotBlank((CharSequence)(stderrMessage = StringUtils.trimToEmpty((String)stderrMessage)))) {
                        log.error("read pipe client stderr output: " + stderrMessage);
                    }
                }
            }
            catch (IOException e) {
                log.error("read pipe client stderr output error", (Throwable)e);
            }
        });
        t.setDaemon(true);
        t.start();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/alibabacloud/intellij/cosy/core/pipe/CosyStdioConnectClient", "getExtraPipeCommands"));
    }
}

