/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.core.lsp.model.model;

import com.alibabacloud.intellij.cosy.chat.context.aidev.BaseAIDevFileContextProvider;
import com.alibabacloud.intellij.cosy.constants.LingmaUrls;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.ChatModelClassResult;
import com.alibabacloud.intellij.cosy.ui.search.component.PrettyListPopup;
import com.alibabacloud.intellij.cosy.ui.search.enums.ChatModelClassEnum;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.alibabacloud.intellij.cosy.util.SwingUtil;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.util.ui.JBUI;
import icons.LingmaIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Objects;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import lombok.Generated;

public class ChatModelClassItem
implements PrettyListPopup.PrettyBaseListItem {
    private final ChatModelClassEnum modelClass;
    private final ChatModelClassResult meta;
    private static JBPopup popup = null;

    public ChatModelClassItem(ChatModelClassEnum modelClass, ChatModelClassResult meta) {
        this.modelClass = modelClass;
        this.meta = meta;
    }

    @Override
    public String getDisplayName() {
        return this.modelClass == null ? this.meta.getName() : CosyBundle.message(this.modelClass.getDisplayNameKey(), new Object[0]);
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    public String getDescriptionText() {
        return this.modelClass == null ? this.meta.getName() : CosyBundle.message(this.modelClass.getTooltipKey(), new Object[0]);
    }

    public String getModelClassId() {
        return null == this.modelClass ? this.meta.getName() : this.modelClass.getId();
    }

    private String getCreditText() {
        return CosyBundle.message("chat.model.class.name.no.credit", LingmaUrls.PRICING.getRealUrl());
    }

    private String getVlText() {
        return CosyBundle.message("chat.model.class.name.no.image", new Object[0]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChatModelClassItem that = (ChatModelClassItem)o;
        return this.modelClass == that.modelClass;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.modelClass, this.meta});
    }

    @Override
    public boolean isEnabled() {
        return this.meta.getEnabled();
    }

    @Override
    public void hoverCallback(Point point, int hoveredIndex) {
        if (popup != null && popup.isVisible()) {
            popup.cancel();
        }
        ToolTipPanel toolTipPanel = new ToolTipPanel(this);
        popup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)toolTipPanel, null).setFocusable(false).setRequestFocus(false).setCancelOnClickOutside(true).setCancelOnMouseOutCallback(mouseEvent -> {
            Component component = mouseEvent.getComponent();
            if (component instanceof JBList) {
                return ((JBList)component).getSelectedIndex() != hoveredIndex;
            }
            return !SwingUtilities.isDescendingFrom(component, toolTipPanel);
        }).createPopup();
        Point location = MouseInfo.getPointerInfo().getLocation();
        RelativePoint relativePoint = new RelativePoint(new Point(point.x, location.y - 16));
        ReadAction.run(() -> popup.show(relativePoint));
    }

    @Generated
    public ChatModelClassEnum getModelClass() {
        return this.modelClass;
    }

    @Generated
    public ChatModelClassResult getMeta() {
        return this.meta;
    }

    public static class ToolTipPanel
    extends JPanel {
        public ToolTipPanel(ChatModelClassItem item) {
            this.setLayout((LayoutManager)new VerticalFlowLayout(0, 4));
            this.setBorder((Border)JBUI.Borders.empty((int)8, (int)12));
            JPanel titlePanel = new JPanel(new BorderLayout());
            JLabel titleLabel = new JLabel(item.getDisplayName());
            titleLabel.setForeground(ColorUtil.getTextForegroundColor());
            JLabel multiModalLabel = new JLabel(item.getVlText());
            multiModalLabel.setIcon(LingmaIcons.Warning16GreyIcon);
            multiModalLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
            multiModalLabel.setVisible(item.meta.getMultiModalSupported() == false);
            titlePanel.add((Component)titleLabel, "West");
            titlePanel.add((Component)multiModalLabel, "East");
            JLabel descriptionLabel = new JLabel(item.getDescriptionText());
            descriptionLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
            Box costBox = Box.createHorizontalBox();
            JLabel costLabel = new JLabel(CosyBundle.message("chat.model.class.name.cost", new Object[0]));
            costLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
            JLabel originRateLabel = new JLabel(CosyBundle.message("chat.model.class.name.credit.origin", item.meta.getOriginalPriceFactor()));
            originRateLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
            originRateLabel.setVisible(0.0 != item.meta.getOriginalPriceFactor());
            BaseAIDevFileContextProvider.applyStrikeThrough(originRateLabel);
            JLabel costRateLabel = new JLabel(CosyBundle.message("chat.model.class.name.credit", item.meta.getPriceFactor()));
            costRateLabel.setForeground(ColorUtil.getTextForegroundColor());
            costBox.add(costLabel);
            costBox.add(Box.createHorizontalStrut(16));
            if (originRateLabel.isVisible()) {
                costBox.add(originRateLabel);
                costBox.add(Box.createHorizontalStrut(4));
            }
            costBox.add(costRateLabel);
            JLabel creditLabel = new JLabel(item.getCreditText());
            creditLabel.setForeground(ColorUtil.getLinkForegroundColor());
            creditLabel.setVisible(item.meta.getEnabled() == false);
            creditLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    BrowserUtil.browse((String)LingmaUrls.PRICING.getRealUrl());
                }
            });
            this.add(titlePanel);
            this.add(descriptionLabel);
            this.add(costBox);
            this.add(creditLabel);
            SwingUtil.foreachChildComponent(this, cp -> cp.setBackground(ColorUtil.getToolWindowBackgroundColor()));
        }
    }
}

