/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.core.lsp;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibabacloud.intellij.cosy.chat.action.CosyCommitMessageGenerationAction;
import com.alibabacloud.intellij.cosy.chat.enums.aidev.AIDevFileChangedTypeEnum;
import com.alibabacloud.intellij.cosy.chat.model.ChatNoticeRequest;
import com.alibabacloud.intellij.cosy.chat.model.SessionTitleRequest;
import com.alibabacloud.intellij.cosy.chat.model.result.ChatCodeChangeApplyResult;
import com.alibabacloud.intellij.cosy.chat.processor.ChatAnswerProcessor;
import com.alibabacloud.intellij.cosy.chat.processor.ChatFilterTimeoutProcessor;
import com.alibabacloud.intellij.cosy.chat.processor.ChatFinishProcessor;
import com.alibabacloud.intellij.cosy.chat.processor.ChatNotificationProcessor;
import com.alibabacloud.intellij.cosy.chat.processor.ChatProcessStepCallbackParamsProcessor;
import com.alibabacloud.intellij.cosy.chat.processor.ChatThinkingProcessor;
import com.alibabacloud.intellij.cosy.chat.processor.ChatToolEventProcessor;
import com.alibabacloud.intellij.cosy.chat.processor.ToolInvokeProcessor;
import com.alibabacloud.intellij.cosy.common.CosyCacheKeys;
import com.alibabacloud.intellij.cosy.common.CosySetting;
import com.alibabacloud.intellij.cosy.concurrent.InlineEditActionProcessor;
import com.alibabacloud.intellij.cosy.constants.CosyKey;
import com.alibabacloud.intellij.cosy.core.Cosy;
import com.alibabacloud.intellij.cosy.core.lsp.exception.LspInputInvalidException;
import com.alibabacloud.intellij.cosy.core.lsp.model.LanguageClient;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.AuthStatus;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.ChatDeleteResult;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.ChatModelItem;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.CodeReferenceResult;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.GlobalConfig;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.GlobalEndpointConfig;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.InlineEditActionMessage;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.SnapshotSyncAllResult;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.WorkspaceFileSyncResult;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.CandidateAnalyzeParams;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.ChatAnswerParams;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.ChatFilterTimeoutParams;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.ChatFinishParams;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.ChatNotificationRequest;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.ChatProcessStepCallbackParams;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.ChatThinkingParams;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.CustomCommandGetResult;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.DoFilteringParams;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.GenerateCommitMsgAnswerParams;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.GenerateCommitMsgFinishParams;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.InheritClassAnalyzeParams;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.NetworkRecoverParams;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.NotificationErrorParams;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.PublishExperimentalParams;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.QueryReferenceParams;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.UpdateMessage;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.UploadImageCallBackResult;
import com.alibabacloud.intellij.cosy.core.lsp.model.testagent.JavaHomeResult;
import com.alibabacloud.intellij.cosy.core.lsp.model.testagent.MavenConfigResult;
import com.alibabacloud.intellij.cosy.core.lsp.model.testagent.TestAgentBuildProjectRequest;
import com.alibabacloud.intellij.cosy.core.lsp.model.testagent.TestAgentBuildProjectResponse;
import com.alibabacloud.intellij.cosy.core.lsp.model.testagent.TestAgentGetClassPathRequest;
import com.alibabacloud.intellij.cosy.core.lsp.model.testagent.TestAgentGetClassPathResponse;
import com.alibabacloud.intellij.cosy.core.lsp.model.testagent.TestAgentGetJavaHomeRequest;
import com.alibabacloud.intellij.cosy.core.lsp.model.testagent.TestAgentGetJavaHomeResponse;
import com.alibabacloud.intellij.cosy.core.lsp.model.testagent.TestAgentGetMavenConfigRequest;
import com.alibabacloud.intellij.cosy.core.lsp.model.testagent.TestAgentGetMavenConfigResponse;
import com.alibabacloud.intellij.cosy.core.lsp.model.testagent.TestAgentGetMavenProfileRequest;
import com.alibabacloud.intellij.cosy.core.lsp.model.testagent.TestAgentGetMavenProfileResponse;
import com.alibabacloud.intellij.cosy.core.lsp.model.tool.ToolCallSyncResult;
import com.alibabacloud.intellij.cosy.core.lsp.model.tool.ToolInvokeRequest;
import com.alibabacloud.intellij.cosy.core.lsp.model.tool.ToolInvokeResponse;
import com.alibabacloud.intellij.cosy.editor.cache.CompletionCacheManager;
import com.alibabacloud.intellij.cosy.editor.cache.CompletionRequestManager;
import com.alibabacloud.intellij.cosy.editor.model.InlayCompletionRequest;
import com.alibabacloud.intellij.cosy.linguist.model.CandidateWithPsi;
import com.alibabacloud.intellij.cosy.linguist.model.ItemBase;
import com.alibabacloud.intellij.cosy.linguist.processor.AvailableListProcessor;
import com.alibabacloud.intellij.cosy.linguist.processor.CandidateAnalyzeProcessor;
import com.alibabacloud.intellij.cosy.linguist.processor.IsInheritsProcessor;
import com.alibabacloud.intellij.cosy.linguist.processor.ListVariablesProcessor;
import com.alibabacloud.intellij.cosy.linguist.psi.model.resolved.CosyPsiVariable;
import com.alibabacloud.intellij.cosy.linguist.reference.ReferenceResolver;
import com.alibabacloud.intellij.cosy.service.FeatureService;
import com.alibabacloud.intellij.cosy.service.ModelService;
import com.alibabacloud.intellij.cosy.service.UserAuthService;
import com.alibabacloud.intellij.cosy.ui.config.CosyPersistentSetting;
import com.alibabacloud.intellij.cosy.ui.notifications.GrantAuthorNotification;
import com.alibabacloud.intellij.cosy.ui.notifications.IssueReportNotification;
import com.alibabacloud.intellij.cosy.ui.notifications.NotificationFactory;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.ui.search.topic.AuthLoginNotifier;
import com.alibabacloud.intellij.cosy.ui.search.topic.ChatCodeChangeApplyFinishNotifier;
import com.alibabacloud.intellij.cosy.ui.search.topic.ChatDeleteNotifier;
import com.alibabacloud.intellij.cosy.ui.search.topic.ChatModelListRefreshNotifier;
import com.alibabacloud.intellij.cosy.ui.search.topic.ChatPublishNotifier;
import com.alibabacloud.intellij.cosy.ui.search.topic.ExperimentalFeaturesRefreshNotifier;
import com.alibabacloud.intellij.cosy.ui.search.topic.GenerateStateUpdateNotifier;
import com.alibabacloud.intellij.cosy.ui.search.topic.SnapshotSyncNotifier;
import com.alibabacloud.intellij.cosy.ui.search.topic.WorkspaceFileAddedNotifier;
import com.alibabacloud.intellij.cosy.ui.search.topic.WorkspaceFileModifiedNotifier;
import com.alibabacloud.intellij.cosy.update.PluginDiskInstaller;
import com.alibabacloud.intellij.cosy.util.ActionUtil;
import com.alibabacloud.intellij.cosy.util.EditorUtil;
import com.alibabacloud.intellij.cosy.util.ImageUploadUtil;
import com.alibabacloud.intellij.cosy.util.LoginUtil;
import com.alibabacloud.intellij.cosy.util.MavenConfigUtils;
import com.alibabacloud.intellij.cosy.util.ProjectUtils;
import com.alibabacloud.intellij.cosy.util.SuggestPromptUtil;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.task.ProjectTaskManager;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.SwingUtilities;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.MessageActionItem;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.ShowMessageRequestParams;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.jetbrains.concurrency.Promise;

public class LanguageClientImpl
implements LanguageClient {
    private static final Logger log = Logger.getInstance(LanguageClientImpl.class);
    private static ConcurrentLinkedQueue<String> invalidRequestQueue = new ConcurrentLinkedQueue();
    private static CodeReferenceResult DEFAULT_REFERENCE_FAIL_RESULT = new CodeReferenceResult(new ArrayList<CodeReferenceResult.CodeReferenceItem>(), false);
    private static CodeReferenceResult DEFAULT_REFERENCE_SUCCESS_RESULT = new CodeReferenceResult(new ArrayList<CodeReferenceResult.CodeReferenceItem>(), false);
    private static final int MAX_INVALID_SIZE = 20;
    private static final String EXPIRE_ORG_NAME_KEY = "expireOrganizationName";
    Project project;

    public LanguageClientImpl(Project project) {
        this.project = project;
    }

    @Override
    public void telemetryEvent(Object object) {
    }

    @Override
    public void publishDiagnostics(PublishDiagnosticsParams diagnostics) {
    }

    @Override
    public void showMessage(MessageParams messageParams) {
        log.info(messageParams.getMessage());
    }

    @Override
    public CompletableFuture<MessageActionItem> showMessageRequest(ShowMessageRequestParams requestParams) {
        return null;
    }

    @Override
    public void logMessage(MessageParams message) {
        log.info(message.getMessage());
    }

    @Override
    public CompletableFuture<List<ItemBase>> showAvailableList(TextDocumentPositionParams params) {
        if (params == null || params.getTextDocument().getUri() == null || params.getPosition() == null) {
            return LanguageClientImpl.failed(new LspInputInvalidException(String.format("Get available list input params %s invalid", params.toString())));
        }
        AvailableListProcessor availableListProcessor = new AvailableListProcessor(params.getTextDocument().getUri(), params.getPosition());
        return CompletableFuture.supplyAsync(() -> availableListProcessor.getAvailableList());
    }

    @Override
    public CompletableFuture<List<CandidateWithPsi>> analyzeCandidate(CandidateAnalyzeParams params) {
        if (params == null || CollectionUtils.isEmpty(params.getCandidates()) || params.getTextDocument().getUri() == null || params.getPosition() == null) {
            return LanguageClientImpl.failed(new LspInputInvalidException(String.format("Candidate analyze params %s invalid", params.toString())));
        }
        CandidateAnalyzeProcessor candidateAnalyzeProcessor = new CandidateAnalyzeProcessor(params.getCandidates(), params.getTextDocument().getUri(), params.getPosition());
        return CompletableFuture.supplyAsync(() -> candidateAnalyzeProcessor.analyze());
    }

    @Override
    public CompletableFuture<List<CosyPsiVariable>> listVariables(TextDocumentPositionParams params) {
        if (params == null || params.getTextDocument().getUri() == null || params.getPosition() == null) {
            return LanguageClientImpl.failed(new LspInputInvalidException(String.format("List variables params %s invalid", params.toString())));
        }
        ListVariablesProcessor listVariablesProcessor = new ListVariablesProcessor(params.getTextDocument().getUri(), params.getPosition());
        return CompletableFuture.supplyAsync(() -> listVariablesProcessor.list());
    }

    @Override
    public CompletableFuture<List<Boolean>> isInherits(InheritClassAnalyzeParams params) {
        if (params == null || params.getTextDocument().getUri() == null || params.getPosition() == null || params.getClassPairs() == null) {
            return LanguageClientImpl.failed(new LspInputInvalidException(String.format("Is inherits params %s invalid", params.toString())));
        }
        IsInheritsProcessor isInheritsProcessor = new IsInheritsProcessor(params.getClassPairs(), params.getTextDocument().getUri(), params.getPosition());
        return CompletableFuture.supplyAsync(() -> isInheritsProcessor.check());
    }

    @Override
    public CompletableFuture<Boolean> answer(ChatAnswerParams chatAnswerParams) {
        if (chatAnswerParams == null) {
            return LanguageClientImpl.failed(new Exception("chatAnswerParams is null."));
        }
        ChatAnswerProcessor chatAnswerProcessor = new ChatAnswerProcessor(chatAnswerParams);
        log.debug("Answering. sessionId=" + chatAnswerParams.getSessionId() + ", requestId=" + chatAnswerParams.getRequestId());
        return CompletableFuture.supplyAsync(chatAnswerProcessor::updateAnswer);
    }

    @Override
    public CompletableFuture<Boolean> chatThinking(ChatThinkingParams chatThinkingParams) {
        if (chatThinkingParams == null) {
            return LanguageClientImpl.failed(new Exception("chatThinkingParams is null."));
        }
        ChatThinkingProcessor ChatThinkingProcessor2 = new ChatThinkingProcessor(chatThinkingParams);
        log.debug("Thinking. sessionId=" + chatThinkingParams.getSessionId() + ", requestId=" + chatThinkingParams.getRequestId() + " step:" + chatThinkingParams.getStep());
        return CompletableFuture.supplyAsync(ChatThinkingProcessor2::updateThinking);
    }

    @Override
    public CompletableFuture<Boolean> processStepCallback(ChatProcessStepCallbackParams chatProcessStepCallbackParams) {
        log.info("processStepCallback: " + JSON.toJSONString((Object)chatProcessStepCallbackParams));
        if (chatProcessStepCallbackParams == null) {
            return LanguageClientImpl.failed(new Exception("chatProcessStepCallbackParams is null."));
        }
        ChatProcessStepCallbackParamsProcessor chatProcessStepCallbackParamsProcessor = new ChatProcessStepCallbackParamsProcessor(chatProcessStepCallbackParams);
        log.debug("Process step callback. sessionId=" + chatProcessStepCallbackParams.getSessionId() + ", requestId=" + chatProcessStepCallbackParams.getRequestId());
        return CompletableFuture.supplyAsync(chatProcessStepCallbackParamsProcessor::updateProcessStep);
    }

    @Override
    public CompletableFuture<Boolean> finish(ChatFinishParams chatFinishParams) {
        if (chatFinishParams == null) {
            return LanguageClientImpl.failed(new Exception("chatAnswerParams is null."));
        }
        log.info("Ask finish. sessionId=" + chatFinishParams.getSessionId() + " requestId=" + chatFinishParams.getRequestId());
        ChatToolEventProcessor.INSTANCE.offerRequestFinishEvent(chatFinishParams.getRequestId());
        ChatFinishProcessor chatFinishProcessor = new ChatFinishProcessor(chatFinishParams);
        return CompletableFuture.supplyAsync(chatFinishProcessor::finish);
    }

    @Override
    public CompletableFuture<Boolean> filterTimeout(ChatFilterTimeoutParams chatFilterTimeoutParams) {
        if (chatFilterTimeoutParams == null) {
            return LanguageClientImpl.failed(new Exception("chatFilterTimeoutParams is null."));
        }
        log.info("Filter timeout. sessionId=" + chatFilterTimeoutParams.getSessionId() + "requestId=" + chatFilterTimeoutParams.getRequestId());
        ChatFilterTimeoutProcessor chatFilterTimeoutProcessor = new ChatFilterTimeoutProcessor(chatFilterTimeoutParams);
        return CompletableFuture.supplyAsync(chatFilterTimeoutProcessor::timeout);
    }

    public static <R> CompletableFuture<R> failed(Throwable error) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(error);
        return future;
    }

    @Override
    public CompletableFuture<Boolean> collectCompletionResult(CompletionItem completionItem) {
        String requestId = null;
        String cacheRequestId = null;
        if (completionItem.getData() instanceof JsonObject) {
            JsonElement finishedEl;
            JsonElement cacheIdEl;
            JsonObject jsonObject = (JsonObject)completionItem.getData();
            JsonElement el = jsonObject.get("RequestId");
            if (el != null) {
                requestId = el.getAsString();
            }
            if ((cacheIdEl = jsonObject.get("CacheId")) != null) {
                cacheRequestId = cacheIdEl.getAsString();
            }
            if ((finishedEl = jsonObject.get("finished")) != null && finishedEl.getAsBoolean() && StringUtils.isNotBlank((CharSequence)requestId)) {
                this.recordCompletionCache(requestId, completionItem);
            }
            log.info("receive request result " + requestId + " cacheId:" + cacheRequestId);
            if (StringUtils.isNotBlank((CharSequence)requestId)) {
                for (String id : invalidRequestQueue) {
                    if (!id.equals(requestId)) continue;
                    log.info("ignore invalid request " + requestId);
                    return CompletableFuture.completedFuture(true);
                }
            }
        }
        String finalRequestId = requestId;
        SwingUtilities.invokeLater(() -> {
            log.debug("run swing request result " + finalRequestId);
            InlayCompletionRequest req = this.getInlayCompletionRequest();
            if (req == null) {
                log.warn("invalid request in editor");
                invalidRequestQueue.offer(finalRequestId);
                if (invalidRequestQueue.size() > 20) {
                    invalidRequestQueue.poll();
                }
                return;
            }
            if (req.isCanceled()) {
                log.warn(req.getParams().getRequestId() + " request has canceled");
                return;
            }
            if (finalRequestId != null && !req.getParams().getRequestId().equals(finalRequestId)) {
                log.debug("ignore request id:" + finalRequestId);
                invalidRequestQueue.offer(finalRequestId);
                if (invalidRequestQueue.size() > 20) {
                    invalidRequestQueue.poll();
                }
                return;
            }
            req.getCollector().onCollect(completionItem);
            req.getCollector().onComplete();
        });
        return CompletableFuture.completedFuture(false);
    }

    private void recordCompletionCache(String requestId, CompletionItem completionItem) {
        InlayCompletionRequest req = CompletionRequestManager.getInstance().getRequest(requestId);
        if (req != null) {
            log.debug("add completion cache result for request " + requestId);
            CompletionCacheManager.getInstance().add(req, completionItem);
        }
    }

    private InlayCompletionRequest getInlayCompletionRequest() {
        InlayCompletionRequest req = null;
        Editor editor = EditorUtil.getActiveEditor();
        if (editor == null) {
            log.warn("Cannot get active editor, try get by project");
            Project project = ProjectUtils.getActiveProject();
            if (project != null) {
                req = (InlayCompletionRequest)CosyCacheKeys.KEY_COMPLETION_LATEST_PROJECT_REQUEST.get((UserDataHolder)project);
            }
        } else {
            req = (InlayCompletionRequest)CosyCacheKeys.KEY_COMPLETION_LATEST_REQUEST.get((UserDataHolder)editor);
        }
        return req;
    }

    @Override
    public CompletableFuture<Void> authReport(AuthStatus authStatus) {
        log.info("consuming auth report:" + authStatus);
        LoginUtil.setLoginResult(authStatus);
        LoginUtil.notifyAuthLogin();
        return CompletableFuture.runAsync(() -> SwingUtilities.invokeLater(() -> UserAuthService.getInstance().authReport(authStatus)));
    }

    @Override
    public CompletableFuture<Void> changeEndpointConfig(GlobalEndpointConfig endpointConfig) {
        boolean emptyConfig = null == endpointConfig;
        log.info("JetBrains changeEndpointConfig:" + (emptyConfig ? "null" : endpointConfig.getEndpoint()));
        return CompletableFuture.runAsync(() -> SwingUtilities.invokeLater(() -> {
            Project activeProject = ProjectUtils.getActiveProject();
            if (activeProject != null) {
                CosySetting cosySetting = CosyPersistentSetting.getInstance().getState();
                if (cosySetting != null) {
                    cosySetting.setDedicatedDomainUrl(emptyConfig ? "" : endpointConfig.getEndpoint());
                }
                CosyCacheKeys.KEY_ENDPOINT_CONFIG.set((UserDataHolder)activeProject, (Object)endpointConfig);
            }
        }));
    }

    @Override
    public CompletableFuture<Void> changeGlobalConfig(GlobalConfig globalConfig) {
        return CompletableFuture.runAsync(() -> SwingUtilities.invokeLater(() -> {
            Project activeProject = ProjectUtils.getActiveProject();
            if (activeProject != null) {
                CosyCacheKeys.KEY_GLOBAL_CONFIG.set((UserDataHolder)activeProject, (Object)globalConfig);
            }
        }));
    }

    @Override
    public void publishExperimental(PublishExperimentalParams experimental) {
        if (experimental != null && experimental.getFeatures() != null) {
            FeatureService.getInstance().updateFeatures(experimental.getFeatures());
            SwingUtilities.invokeLater(() -> {
                Project project = ProjectUtils.getActiveProject();
                if (null == project) {
                    log.warn("invalid active project for publishExperimental");
                } else {
                    ((ExperimentalFeaturesRefreshNotifier)project.getMessageBus().syncPublisher(ExperimentalFeaturesRefreshNotifier.CHAT_MODE_DEFAULT_REFRESH_NOTIFICATION)).refresh();
                }
            });
        }
    }

    @Override
    public CompletableFuture<Void> updateReady(UpdateMessage updateMessage) {
        log.info("consuming update ready:" + updateMessage);
        return CompletableFuture.runAsync(() -> {
            File file = new File(updateMessage.getFilePath());
            if (!file.exists()) {
                log.warn("update file not exist:" + updateMessage.getFilePath());
                return;
            }
            SwingUtilities.invokeLater(() -> {
                Project activeProject = ProjectUtils.getActiveProject();
                if (activeProject != null) {
                    PluginDiskInstaller.installFromDisk(activeProject, file);
                } else {
                    log.warn("invalid active project");
                }
            });
        });
    }

    @Override
    public CompletableFuture<Boolean> commitMsgAnswer(GenerateCommitMsgAnswerParams generateCommitMsgAnswerParams) {
        CosyCommitMessageGenerationAction commitMessageGenerationAction = (CosyCommitMessageGenerationAction)ActionManager.getInstance().getAction(ActionUtil.getActionId("TriggerCosyCommitMessageGenerationAction"));
        log.debug("commitMsgAnswer answering. requestId=" + generateCommitMsgAnswerParams.getRequestId());
        return CompletableFuture.supplyAsync(() -> commitMessageGenerationAction.updateAnswer(generateCommitMsgAnswerParams));
    }

    @Override
    public CompletableFuture<Boolean> commitMsgFinish(GenerateCommitMsgFinishParams generateCommitMsgFinishParams) {
        CosyCommitMessageGenerationAction commitMessageGenerationAction = (CosyCommitMessageGenerationAction)ActionManager.getInstance().getAction(ActionUtil.getActionId("TriggerCosyCommitMessageGenerationAction"));
        return CompletableFuture.supplyAsync(() -> commitMessageGenerationAction.finishAnswer(generateCommitMsgFinishParams));
    }

    @Override
    public CompletableFuture<Boolean> notificationError(NotificationErrorParams notificationErrorParams) {
        if (notificationErrorParams != null) {
            ApplicationManager.getApplication().invokeLater(() -> {
                Project project = ProjectUtils.getActiveProject();
                if (project == null) {
                    return;
                }
                String message = null;
                if ("110".equals(notificationErrorParams.getCode())) {
                    message = CosyBundle.message("message.inlay.completion.reach.limit.error", new Object[0]);
                } else if ("111".equals(notificationErrorParams.getCode())) {
                    AuthStatus status = LoginUtil.getAuthStatus(project);
                    if (status == null) {
                        return;
                    }
                    message = String.format(CosyBundle.message("message.chat.answer.org.order.expired", new Object[0]), status.getName(), status.getOrgName());
                } else {
                    if ("601".equals(notificationErrorParams.getCode())) {
                        AuthStatus status = LoginUtil.getAuthStatus(project);
                        if (status == null) {
                            return;
                        }
                        String expiredOrgName = "";
                        Map<String, Object> extra = notificationErrorParams.getExtra();
                        if (extra != null && extra.containsKey(EXPIRE_ORG_NAME_KEY)) {
                            expiredOrgName = extra.get(EXPIRE_ORG_NAME_KEY) == null ? "" : (String)extra.get(EXPIRE_ORG_NAME_KEY);
                        }
                        message = String.format(CosyBundle.message("message.switch.identity.hint", new Object[0]), status.getName(), expiredOrgName);
                        GrantAuthorNotification.notifySwitchIdentityDirectly(project, message);
                        return;
                    }
                    if ("pop_data_policy_sign".equals(notificationErrorParams.getCode())) {
                        GrantAuthorNotification.notifyNeedSignImprovementDirectly(project);
                        return;
                    }
                    if ("apply_unknown_error".equals(notificationErrorParams.getCode())) {
                        message = CosyBundle.message("message.error.workspace.file.apply.unknown", new Object[0]);
                    } else if ("generating_timeout_error".equals(notificationErrorParams.getCode())) {
                        message = CosyBundle.message("message.error.workspace.file.generate.timeout", new Object[0]);
                    } else if ("apply_timeout_error".equals(notificationErrorParams.getCode())) {
                        message = CosyBundle.message("message.error.workspace.file.apply.timeout", new Object[0]);
                    } else if ("apply_unsupported_error".equals(notificationErrorParams.getCode())) {
                        message = CosyBundle.message("message.error.workspace.file.apply.unsupported", new Object[0]);
                    } else if ("pop_report_crash".equals(notificationErrorParams.getCode())) {
                        IssueReportNotification.notify(project);
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)message)) {
                    NotificationFactory.showWarnNotification(project, message);
                }
            });
        }
        return CompletableFuture.completedFuture(true);
    }

    @Override
    public CompletableFuture<CodeReferenceResult> queryReference(QueryReferenceParams params) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                Project project = ProjectUtils.getProjectByPath(params.getWorkspace());
                if (project == null) {
                    log.warn("invalid project for querying reference");
                    return DEFAULT_REFERENCE_FAIL_RESULT;
                }
                if (DumbService.isDumb((Project)project)) {
                    return DEFAULT_REFERENCE_FAIL_RESULT;
                }
                Editor editor = EditorUtil.getSelectedEditorSafely(project);
                if (editor == null) {
                    log.warn("invalid editor for querying reference");
                    return DEFAULT_REFERENCE_FAIL_RESULT;
                }
                long startTime = System.currentTimeMillis();
                CodeReferenceResult result = ReferenceResolver.resolveDeclaration(editor, params);
                log.debug("query reference cost:" + (System.currentTimeMillis() - startTime));
                return result;
            }
            catch (Throwable e) {
                log.warn("query reference error", e);
                return DEFAULT_REFERENCE_SUCCESS_RESULT;
            }
        });
    }

    @Override
    public CompletableFuture<Boolean> pushCustomCommand(CustomCommandGetResult customCommandGetResult) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                log.debug("extension/register param is " + customCommandGetResult);
                if (customCommandGetResult == null) {
                    log.warn("get custom command result is null");
                    return false;
                }
                SwingUtilities.invokeLater(() -> SuggestPromptUtil.updateCustomSuggestPrompt((Project)ReadAction.compute(ProjectUtils::getActiveProject), customCommandGetResult));
            }
            catch (Exception e) {
                log.warn("get custom command result error", (Throwable)e);
            }
            return true;
        });
    }

    @Override
    public CompletableFuture<Void> networkRecover(NetworkRecoverParams params) {
        return CompletableFuture.supplyAsync(() -> {
            SwingUtilities.invokeLater(() -> {
                Project project = ProjectUtils.getActiveProject();
                if (project == null) {
                    log.warn("networkRecover invalid active project");
                    return;
                }
                try {
                    AuthStatus authStatus = Cosy.INSTANCE.getLanguageService(project).authStatus(10000L);
                    CosyCacheKeys.KEY_AUTH_STATUS.set((UserDataHolder)ApplicationManager.getApplication(), (Object)authStatus);
                    ((AuthLoginNotifier)project.getMessageBus().syncPublisher(AuthLoginNotifier.AUTH_LOGIN_NOTIFICATION)).notifyLoginAuth(authStatus);
                }
                catch (Exception e) {
                    log.warn("fail to send message. " + e.getMessage(), (Throwable)e);
                }
            });
            return null;
        });
    }

    @Override
    public CompletableFuture<Void> doFiltering(DoFilteringParams params) {
        return CompletableFuture.supplyAsync(() -> {
            SwingUtilities.invokeLater(() -> {
                Project project = ProjectUtils.getActiveProject();
                if (project == null) {
                    log.warn("doFiltering invalid active project");
                    return;
                }
                ((GenerateStateUpdateNotifier)project.getMessageBus().syncPublisher(GenerateStateUpdateNotifier.GENERATE_STATE_UPDATE_NOTIFICATION)).updateGenerateState(CosyBundle.message("chat.answer.btn.filtering", new Object[0]));
            });
            return null;
        });
    }

    @Override
    public CompletableFuture<Void> uploadResultNotification(UploadImageCallBackResult result) {
        log.debug("uploadResultNotification result=" + JSON.toJSONString((Object)result));
        return CompletableFuture.supplyAsync(() -> {
            if (result == null) {
                log.debug("uploadResultNotification result is null");
                return null;
            }
            String requestId = UploadImageCallBackResult.getRequestId(result);
            if (StringUtils.isBlank((CharSequence)requestId)) {
                log.debug("uploadResultNotification result.requestId is blank");
                return null;
            }
            log.debug("uploadResultNotification requestId=" + requestId + ",result=" + JSON.toJSONString((Object)result));
            ImageUploadUtil.setImageUploadResult(requestId, result);
            ImageUploadUtil.notifyImageUpload(requestId);
            return null;
        });
    }

    @Override
    public CompletableFuture<TestAgentBuildProjectResponse> buildProject(TestAgentBuildProjectRequest buildRequest) {
        return CompletableFuture.supplyAsync(() -> {
            Project activeProject = (Project)Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_PROJECT)).get(buildRequest.getRequestId());
            TestAgentBuildProjectResponse response = new TestAgentBuildProjectResponse();
            response.setSessionId(buildRequest.getSessionId());
            if (activeProject == null) {
                log.warn("Build invalid active project.");
                return null;
            }
            Promise buildResult = ProjectTaskManager.getInstance((Project)activeProject).buildAllModules();
            AtomicReference<Boolean> retBuildResult = new AtomicReference<Boolean>(false);
            CountDownLatch countDownLatch = new CountDownLatch(1);
            buildResult.onSuccess(result -> {
                if (result.isAborted() || result.hasErrors() || activeProject.isDisposed()) {
                    retBuildResult.set(false);
                } else {
                    retBuildResult.set(true);
                }
                countDownLatch.countDown();
            }).onError(result -> {
                retBuildResult.set(false);
                countDownLatch.countDown();
            });
            try {
                countDownLatch.await(5L, TimeUnit.MINUTES);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            response.setSuccessful(retBuildResult.get());
            return response;
        });
    }

    @Override
    public CompletableFuture<Void> syncAllSnapshots(SnapshotSyncAllResult result) {
        return CompletableFuture.supplyAsync(() -> {
            SwingUtilities.invokeLater(() -> {
                if (null == result || null == result.getProjectPath()) {
                    log.warn("Invalid syncAllSnapshots: " + result);
                    return;
                }
                Project project = ProjectUtils.getProjectByPath(result.getProjectPath());
                if (project == null) {
                    log.warn("syncAllSnapshots project is null, projectPath=" + result.getProjectPath());
                    return;
                }
                try {
                    ((SnapshotSyncNotifier)project.getMessageBus().syncPublisher(SnapshotSyncNotifier.SNAPSHOT_SYNC_NOTIFICATION)).syncSnapshot(result);
                }
                catch (Exception e) {
                    log.warn("fail to send message. " + e.getMessage(), (Throwable)e);
                }
            });
            return null;
        });
    }

    @Override
    public CompletableFuture<Void> syncWorkspaceFile(WorkspaceFileSyncResult response) {
        return CompletableFuture.supplyAsync(() -> {
            SwingUtilities.invokeLater(() -> {
                if (null == response || null == response.getWorkingSpaceFile() || null == response.getProjectPath()) {
                    log.warn("Invalid WorkspaceFileSyncResult: " + response);
                    return;
                }
                Project project = ProjectUtils.getProjectByPath(response.getProjectPath());
                if (project == null) {
                    log.warn("syncWorkspaceFile project is null,projectPath=" + response.getProjectPath());
                    return;
                }
                log.info("syncWorkspaceFile:  type: " + response.getType() + ". id: " + response.getWorkingSpaceFile().getId() + ". fileId: " + response.getWorkingSpaceFile().getFileId() + ". snapShotId: " + response.getWorkingSpaceFile().getSnapshotId() + ". status: " + response.getWorkingSpaceFile().getStatus() + ". message: " + response.getWorkingSpaceFile().getMessage());
                try {
                    if (AIDevFileChangedTypeEnum.ADD.getId().equals(response.getType())) {
                        ((WorkspaceFileAddedNotifier)project.getMessageBus().syncPublisher(WorkspaceFileAddedNotifier.WORKSPACE_FILE_ADDED_NOTIFICATION)).syncWorkspaceFileAdded(response);
                    } else if (AIDevFileChangedTypeEnum.MODIFIED.getId().equals(response.getType())) {
                        ((WorkspaceFileModifiedNotifier)project.getMessageBus().syncPublisher(WorkspaceFileModifiedNotifier.WORKSPACE_FILE_MODIFIED_NOTIFICATION)).syncWorkspaceFileModified(response);
                    } else if ("FRUSH".equals(response.getType())) {
                        ApplicationManager.getApplication().invokeLaterOnWriteThread(() -> {
                            LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
                            VirtualFile targetFile = localFileSystem.refreshAndFindFileByPath(response.getWorkingSpaceFile().getFileId());
                            if (null != targetFile && targetFile.isValid()) {
                                VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)false, (VirtualFile[])new VirtualFile[]{targetFile});
                            }
                        });
                    }
                }
                catch (Exception e) {
                    log.warn("fail to send message. " + e.getMessage(), (Throwable)e);
                }
            });
            return null;
        });
    }

    @Override
    public CompletableFuture<Void> chatDeleteNotification(ChatDeleteResult result) {
        return CompletableFuture.supplyAsync(() -> {
            SwingUtilities.invokeLater(() -> {
                if (null == result || StringUtils.isBlank((CharSequence)result.getRequestId()) || StringUtils.isBlank((CharSequence)result.getSessionId())) {
                    log.warn("Invalid chatDeleteNotification: " + result);
                    return;
                }
                Project project = ProjectUtils.getActiveProject();
                if (project == null) {
                    log.warn("chatDeleteNotification invalid active project" + result);
                    return;
                }
                try {
                    ((ChatDeleteNotifier)project.getMessageBus().syncPublisher(ChatDeleteNotifier.CHAT_DELETE_NOTIFICATION)).deleteChat(result);
                }
                catch (Exception e) {
                    log.warn("chatDeleteNotification fail to send message. " + e.getMessage(), (Throwable)e);
                }
            });
            return null;
        });
    }

    @Override
    public CompletableFuture<TestAgentGetMavenConfigResponse> getMavenConfig(TestAgentGetMavenConfigRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            Project activeProject = (Project)Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_PROJECT)).get(request.getRequestId());
            TestAgentGetMavenConfigResponse response = new TestAgentGetMavenConfigResponse();
            response.setRequestId(request.getRequestId());
            response.setSessionId(request.getSessionId());
            if (activeProject != null) {
                MavenConfigResult result = MavenConfigUtils.getProjectMavenConfig(activeProject);
                response.setResult(result);
            }
            log.info("getMavenConfig: " + JSON.toJSONString((Object)response));
            return response;
        });
    }

    @Override
    public CompletableFuture<TestAgentGetJavaHomeResponse> getJavaHome(TestAgentGetJavaHomeRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            ProjectRootManager projectRootManager;
            Sdk projectSdk;
            Project activeProject = (Project)Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_PROJECT)).get(request.getRequestId());
            TestAgentGetJavaHomeResponse testAgentGetJavaHomeResponse = new TestAgentGetJavaHomeResponse();
            testAgentGetJavaHomeResponse.setRequestId(request.getRequestId());
            testAgentGetJavaHomeResponse.setSessionId(request.getSessionId());
            if (activeProject != null && (projectSdk = (projectRootManager = ProjectRootManager.getInstance((Project)activeProject)).getProjectSdk()) != null && projectSdk.getSdkType() instanceof JavaSdk) {
                JavaHomeResult javaHomeResult = new JavaHomeResult();
                javaHomeResult.setJavaHome(projectSdk.getHomePath());
                testAgentGetJavaHomeResponse.setResult(javaHomeResult);
            }
            log.info("testAgentGetJavaHomeResponse" + testAgentGetJavaHomeResponse);
            return testAgentGetJavaHomeResponse;
        });
    }

    @Override
    public CompletableFuture<TestAgentGetClassPathResponse> getJavaClassPath(TestAgentGetClassPathRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            Project activeProject = (Project)Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_PROJECT)).get(request.getRequestId());
            TestAgentGetClassPathResponse testAgentClassPathResponse = new TestAgentGetClassPathResponse();
            if (Objects.isNull(activeProject)) {
                log.warn("test agent getClassPath invalid active project.");
                return null;
            }
            String modulesClassPath = this.getModulesClassPath(activeProject);
            Map<String, String> moduleClasspath = this.getModuleClassPathMap(activeProject);
            testAgentClassPathResponse.setClassPath(modulesClassPath);
            testAgentClassPathResponse.setModuleClassPath(moduleClasspath);
            return testAgentClassPathResponse;
        });
    }

    @Override
    public CompletableFuture<TestAgentGetMavenProfileResponse> getMavenProfiles(TestAgentGetMavenProfileRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            Project activeProject = (Project)Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_PROJECT)).get(request.getRequestId());
            TestAgentGetMavenProfileResponse response = new TestAgentGetMavenProfileResponse();
            if (Objects.isNull(activeProject)) {
                log.warn("test agent getMavenProfiles invalid active project.");
                return null;
            }
            response.setActiveProfiles(MavenConfigUtils.getMavenActiveProfiles(activeProject));
            return response;
        });
    }

    private String getModulesClassPath(Project project) {
        return (String)ReadAction.compute(() -> {
            Module[] modules;
            StringBuilder classpath = new StringBuilder();
            for (Module module : modules = ModuleManager.getInstance((Project)project).getModules()) {
                VirtualFile outputPath;
                CompilerModuleExtension extension = CompilerModuleExtension.getInstance((Module)module);
                if (extension == null || (outputPath = extension.getCompilerOutputPath()) == null) continue;
                if (classpath.length() > 0) {
                    classpath.append(File.pathSeparator);
                }
                classpath.append(outputPath.getPath());
            }
            OrderEnumerator.orderEntries((Project)project).recursively().forEachLibrary(lib -> {
                VirtualFile[] files;
                for (VirtualFile file : files = lib.getFiles(OrderRootType.CLASSES)) {
                    String path;
                    if (classpath.length() > 0) {
                        classpath.append(File.pathSeparator);
                    }
                    if ((path = file.getPath()).endsWith("!/")) {
                        path = path.substring(0, path.length() - 2);
                    }
                    classpath.append(path);
                }
                return true;
            });
            return classpath.toString();
        });
    }

    private Map<String, String> getModuleClassPathMap(Project project) {
        return (Map)ReadAction.compute(() -> {
            Module[] modules = ModuleManager.getInstance((Project)project).getModules();
            HashMap<String, String> moduleClasspath = new HashMap<String, String>(modules.length);
            for (Module module : modules) {
                VirtualFile[] roots;
                StringBuilder classpath = new StringBuilder();
                for (VirtualFile root : roots = ModuleRootManager.getInstance((Module)module).orderEntries().classes().getRoots()) {
                    String path;
                    if (classpath.length() > 0) {
                        classpath.append(File.pathSeparator);
                    }
                    if ((path = root.getCanonicalPath()).endsWith("!/")) {
                        path = path.substring(0, path.length() - 2);
                    }
                    classpath.append(path);
                }
                VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
                if (contentRoots.length <= 0) continue;
                moduleClasspath.put(contentRoots[0].getCanonicalPath(), classpath.toString());
            }
            return moduleClasspath;
        });
    }

    @Override
    public CompletableFuture<Void> refreshModels(Map<String, List<ChatModelItem>> modelList) {
        return CompletableFuture.supplyAsync(() -> {
            ModelService.getInstance().refreshModel(modelList);
            SwingUtilities.invokeLater(() -> {
                Project[] projects;
                for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
                    if (!project.isOpen()) continue;
                    log.info("refresh model list for project:" + project.getName());
                    ((ChatModelListRefreshNotifier)project.getMessageBus().syncPublisher(ChatModelListRefreshNotifier.CHAT_MODEL_LIST_REFRESH_NOTIFICATION)).refreshModel(modelList);
                }
            });
            return null;
        });
    }

    @Override
    public CompletableFuture<Void> nextEditAction(InlineEditActionMessage message) {
        log.debug("nextEditAction message=" + message);
        return CompletableFuture.supplyAsync(() -> {
            message.setProject(this.project);
            InlineEditActionProcessor.INSTANCE.offerMessage(message);
            return null;
        });
    }

    @Override
    public CompletableFuture<ToolInvokeResponse> toolInvoke(ToolInvokeRequest request) {
        Project activeProject;
        if (request == null) {
            return LanguageClientImpl.failed(new Exception("toolInvokeRequest is null."));
        }
        log.debug("toolInvoke request=" + JSONObject.toJSONString((Object)request));
        Map map = (Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_PROJECT);
        if (map != null && (activeProject = (Project)map.get(request.getRequestId())) != null) {
            request.setProject(activeProject);
        }
        if (request.getProject() == null) {
            ApplicationManager.getApplication().invokeAndWait(() -> {
                log.warn("toolInvoke requestId=" + request.getRequestId() + " active project is null.");
                Project activeProject = ProjectUtils.getActiveProject();
                if (activeProject != null) {
                    request.setProject(activeProject);
                }
            });
        }
        if (request.getProject() == null) {
            return CompletableFuture.completedFuture(ToolInvokeResponse.failed(request.getToolCallId(), request.getName(), "get project by requestId is null"));
        }
        ToolInvokeProcessor toolInvokeProcessor = new ToolInvokeProcessor(request.getProject(), request);
        return CompletableFuture.supplyAsync(toolInvokeProcessor::invokeTool);
    }

    @Override
    public CompletableFuture<Void> toolCallSync(ToolCallSyncResult result) {
        return CompletableFuture.supplyAsync(() -> {
            SwingUtilities.invokeLater(() -> {
                if (null == result || null == result.getProjectPath()) {
                    log.warn("Invalid toolCallSync: " + result);
                    return;
                }
                log.debug("toolCallSync result=" + JSONObject.toJSONString((Object)result));
                Project project = ProjectUtils.getProjectByPath(result.getProjectPath());
                if (project == null) {
                    log.warn("toolCallSync project is null, projectPath=" + result.getProjectPath());
                    return;
                }
                try {
                    ChatToolEventProcessor.INSTANCE.offerEvent(result);
                }
                catch (Exception e) {
                    log.warn("fail to send tool call message. " + e.getMessage(), (Throwable)e);
                }
            });
            return null;
        });
    }

    @Override
    public CompletableFuture<Void> chatCodeChangeApplyFinished(ChatCodeChangeApplyResult result) {
        return CompletableFuture.supplyAsync(() -> {
            if (null == result || null == result.getProjectPath()) {
                log.warn("Invalid code change apply result: " + result);
                return null;
            }
            log.debug("chatCodeChangeApplyFinished result=" + JSONObject.toJSONString((Object)result));
            Project project = ProjectUtils.getProjectByPath(result.getProjectPath());
            if (project == null) {
                log.warn("chatCodeChangeApplyFinished project is null, projectPath=" + result.getProjectPath());
                return null;
            }
            try {
                ((ChatCodeChangeApplyFinishNotifier)project.getMessageBus().syncPublisher(ChatCodeChangeApplyFinishNotifier.CHAT_CODE_CHANGE_APPLY_NOTIFICATION)).applyFinishNotify(result);
            }
            catch (Exception e) {
                log.warn("chatCodeChangeApplyFinishedNotification fail to send message. " + e.getMessage(), (Throwable)e);
            }
            return null;
        });
    }

    @Override
    public CompletableFuture<Void> chatPublishNotice(ChatNoticeRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            if (null == request) {
                log.warn("Invalid chat notice request: null");
                return null;
            }
            log.debug("chatPublishNotice request=" + JSONObject.toJSONString((Object)request));
            try {
                ((ChatPublishNotifier)this.project.getMessageBus().syncPublisher(ChatPublishNotifier.CHAT_PUBLISH_NOTIFIER_NOTIFICATION)).publishNotice(request);
            }
            catch (Exception e) {
                log.warn("ChatPublishNotifier fail to send message. " + e.getMessage(), (Throwable)e);
            }
            return null;
        });
    }

    @Override
    public CompletableFuture<Void> sessionTitleUpdate(SessionTitleRequest request) {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> chatNotification(ChatNotificationRequest request) {
        if (request == null) {
            return LanguageClientImpl.failed(new Exception("chatNotification is null."));
        }
        return CompletableFuture.supplyAsync(() -> ChatNotificationProcessor.INSTANCE.processNotification(request));
    }
}

