/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.core;

import com.alibabacloud.intellij.cosy.common.CosyConfig;
import com.alibabacloud.intellij.cosy.common.CosySetting;
import com.alibabacloud.intellij.cosy.constants.Constants;
import com.alibabacloud.intellij.cosy.constants.CosyKey;
import com.alibabacloud.intellij.cosy.core.BinaryManager;
import com.alibabacloud.intellij.cosy.core.BinaryRunner;
import com.alibabacloud.intellij.cosy.core.CosyStartupListener;
import com.alibabacloud.intellij.cosy.core.lsp.LanguageWebSocketService;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.AuthStatus;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.ChatModelItem;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.GlobalConfig;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.IdeSeriesType;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.InitializeResultExt;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.ChangeUserSettingParams;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.InitializeParamsWithConfig;
import com.alibabacloud.intellij.cosy.core.websocket.CosyHeartbeatRunner;
import com.alibabacloud.intellij.cosy.search.enums.CodeCompletionCandidateEnum;
import com.alibabacloud.intellij.cosy.search.enums.CodeCompletionModeEnum;
import com.alibabacloud.intellij.cosy.service.FeatureService;
import com.alibabacloud.intellij.cosy.service.ModelService;
import com.alibabacloud.intellij.cosy.ui.config.CosyConfigurable;
import com.alibabacloud.intellij.cosy.ui.config.CosyPersistentSetting;
import com.alibabacloud.intellij.cosy.ui.notifications.GrantAuthorNotification;
import com.alibabacloud.intellij.cosy.ui.notifications.StartupNotification;
import com.alibabacloud.intellij.cosy.ui.search.enums.TransportTypeEnum;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.ui.search.topic.ChatModelListRefreshNotifier;
import com.alibabacloud.intellij.cosy.util.ApplicationUtil;
import com.alibabacloud.intellij.cosy.util.JsonUtil;
import com.alibabacloud.intellij.cosy.util.LoginUtil;
import com.alibabacloud.intellij.cosy.util.ProcessUtils;
import com.alibabacloud.intellij.cosy.util.ProjectUtils;
import com.alibabacloud.intellij.cosy.util.SlideWindowStatQps;
import com.alibabacloud.intellij.cosy.util.StringUtils;
import com.alibabacloud.intellij.cosy.util.TerminalUtils;
import com.alibabacloud.intellij.cosy.util.ThreadUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.eclipse.lsp4j.WorkspaceFolder;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class Cosy {
    private static final Logger log = Logger.getInstance(Cosy.class);
    private static final long STARTUP_TIMEOUT = 10000L;
    public static final Cosy INSTANCE = new Cosy();
    public static final int DEFAULT_LINGMA_PORT = CosyConfig.isQoderEnabled() ? 57010 : 37010;
    public Map<String, Boolean> readyMap;
    private Map<String, LanguageWebSocketService> languageServiceMap;
    private BinaryRunner binaryRunner;
    public int cosyStartRetryTimes = 0;
    public static final String COSY_INFO_FILE_NAME = ".info";
    public static final int MAX_COSY_START_RETRY_TIMES = 3;
    public static final int INFO_BEFORE_FILE_EXISTS_WAIT_TIME_MS = 200;
    public static final int BEFORE_CONNECT_WAIT_TIME_MS = 200;
    public static final int INFO_FILE_EXISTS_WAIT_TIME_MS = 1000;
    public static final int MAX_INFO_FILE_RETRY_TIMES = 60;
    public static final int INFO_FILE_LINE_COUNT = 2;
    private SlideWindowStatQps statQps;
    private Map<String, Lock> startLockMap = new ConcurrentHashMap<String, Lock>();
    private Map<String, AtomicBoolean> startingStateMap = new ConcurrentHashMap<String, AtomicBoolean>();

    @Contract(pure=true)
    private Cosy() {
        this.readyMap = new ConcurrentHashMap<String, Boolean>();
        this.languageServiceMap = new ConcurrentHashMap<String, LanguageWebSocketService>();
        this.statQps = new SlideWindowStatQps();
    }

    public void start(Project project) {
        this.start(project, Collections.emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Project project, List<CosyStartupListener> listeners) {
        if (project == null || project.getBasePath() == null) {
            log.warn("Project is not defined when Cosy is starting");
            listeners.forEach(CosyStartupListener::onCancelled);
            return;
        }
        AtomicBoolean startingState = this.startingStateMap.computeIfAbsent(project.getName(), e -> new AtomicBoolean(false));
        if (startingState.get()) {
            log.warn("Project " + project.getName() + " is starting cosy, ignore repeat starting");
            listeners.forEach(CosyStartupListener::onCancelled);
            return;
        }
        AtomicBoolean atomicBoolean = startingState;
        synchronized (atomicBoolean) {
            if (startingState.get()) {
                log.warn("Project " + project.getName() + " is starting cosy, ignore repeat starting");
                listeners.forEach(CosyStartupListener::onCancelled);
                return;
            }
            startingState.getAndSet(true);
            ThreadUtil.execute(() -> this.doStart(project, listeners, startingState));
        }
        ThreadUtil.execute(() -> CosyKey.PROJECT_SHELL_PATH_MAP.put(project.getBasePath(), TerminalUtils.getTerminalShellPath(project)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStart(Project project, List<CosyStartupListener> listeners, AtomicBoolean startingState) {
        ArrayList<WorkspaceFolder> workspaceFolders = new ArrayList<WorkspaceFolder>();
        WorkspaceFolder folder = new WorkspaceFolder();
        folder.setName(project.getName());
        folder.setUri(ProjectUtils.getProjectBaseDir(project));
        workspaceFolders.add(folder);
        InitializeParamsWithConfig params = new InitializeParamsWithConfig();
        params.setWorkspaceFolders(workspaceFolders);
        Lock startLock = this.startLockMap.computeIfAbsent(project.getName(), e -> new ReentrantLock());
        if (!startLock.tryLock()) {
            log.warn("Cannot get start lock for project:" + project.getName());
            listeners.forEach(CosyStartupListener::onCancelled);
            return;
        }
        try {
            log.info(CosyBundle.message("check.cosy.version.state", new Object[0]));
            BinaryManager.INSTANCE.checkBinary(false);
            log.info("starting to startup cosy");
            log.info(CosyBundle.message("start.cosy.process.state", new Object[0]));
            if (INSTANCE.startup(project, params, listeners, false)) {
                log.info("succeed to startup cosy");
                GrantAuthorNotification.notifyNeedLogin(project, false);
                this.cosyStartRetryTimes = 0;
            } else {
                log.info("failed to startup cosy");
                StartupNotification.notifyStartupError(project);
                listeners.forEach(CosyStartupListener::onFailed);
            }
        }
        finally {
            startingState.getAndSet(false);
            startLock.unlock();
        }
    }

    private File getCosyHomeDir() {
        File homeDir = CosyConfig.getHomeDirectory().toFile();
        log.info("cosy home dir " + homeDir);
        if (!homeDir.exists() && !homeDir.mkdirs()) {
            log.error("fail to create directory " + homeDir);
            return null;
        }
        return homeDir;
    }

    public boolean startup(Project project, InitializeParamsWithConfig params, boolean debugMode) {
        return this.startup(project, params, Collections.emptyList(), debugMode);
    }

    public boolean startup(Project project, InitializeParamsWithConfig params, List<CosyStartupListener> listeners, boolean debugMode) {
        try {
            AuthStatus status;
            File homeDir = this.getCosyHomeDir();
            if (homeDir == null) {
                log.warn("Invalid binary directory");
                return false;
            }
            if (this.binaryRunner == null) {
                this.binaryRunner = new BinaryRunner(homeDir);
            }
            if (this.cosyStartRetryTimes == 3) {
                log.warn(String.format("Init Cosy language service error, reached maximum retry times (%d)", this.cosyStartRetryTimes));
                return false;
            }
            boolean isInitSuccess = this.initCosyLanguageService(project, homeDir, debugMode);
            if (!isInitSuccess) {
                log.warn("Cosy init failed");
                return true;
            }
            log.info("Cosy process connected succeed");
            LanguageWebSocketService languageService = this.languageServiceMap.get(project.getLocationHash());
            if (languageService == null || languageService.getServer() == null) {
                log.warn("The server of language service is null");
                return false;
            }
            this.readyMap.put(project.getLocationHash(), Boolean.TRUE);
            this.addConfigToInitializeParams(params, project);
            log.info("Cosy send initialize message");
            CompletableFuture<InitializeResultExt> future = languageService.getServer().initialize(params);
            InitializeResultExt latestInitializeResult = future.get(10000L, TimeUnit.MILLISECONDS);
            log.info("Cosy initialize receive InitializeResultExt");
            if (latestInitializeResult != null) {
                if (log.isDebugEnabled()) {
                    log.debug("get cosy initialize result" + JsonUtil.toJson((Object)latestInitializeResult));
                }
                FeatureService.getInstance().updateFeatures(latestInitializeResult.getExperimental());
            }
            if ((status = languageService.authStatus(3000L)) != null) {
                log.info("get login status:" + status.getStatus());
                LoginUtil.updateAuthStatus(project, status, false);
            }
            this.asyncActionAfterCosyStart(project, languageService);
            listeners.forEach(CosyStartupListener::onStartup);
            return true;
        }
        catch (TimeoutException e) {
            log.warn("startup cosy timeout");
            listeners.forEach(CosyStartupListener::onTimeout);
            return true;
        }
        catch (Exception e) {
            log.error("startup cosy failed.", (Throwable)e);
            return false;
        }
    }

    private void asyncActionAfterCosyStart(Project project, LanguageWebSocketService languageService) {
        ThreadUtil.execute(() -> {
            languageService.refreshCustomCommands(project, 10000L);
            Map<String, List<ChatModelItem>> modelList = ModelService.getInstance().fetchModel(project);
            if (modelList != null && !modelList.isEmpty()) {
                log.info(project.getName() + " sync model list when cosy startup");
                SwingUtilities.invokeLater(() -> {
                    if (!project.isDisposed()) {
                        ((ChatModelListRefreshNotifier)project.getMessageBus().syncPublisher(ChatModelListRefreshNotifier.CHAT_MODEL_LIST_REFRESH_NOTIFICATION)).refreshModel(modelList);
                    }
                });
            }
        });
    }

    public boolean checkCosyProcess() {
        File homeDir = this.getCosyHomeDir();
        if (homeDir == null) {
            return false;
        }
        File infoFile = new File(homeDir, COSY_INFO_FILE_NAME);
        if (!infoFile.exists()) {
            return false;
        }
        Pair<Integer, Long> infoPair = this.checkInfoFile(infoFile);
        if (infoPair != null) {
            Integer port = (Integer)infoPair.first;
            Long pid = (Long)infoPair.second;
            if (pid != null && port != null && ProcessUtils.isProcessAlive(pid)) {
                log.info("check process pid:" + pid + " port:" + port + " valid");
                return true;
            }
        }
        return false;
    }

    private void addConfigToInitializeParams(InitializeParamsWithConfig params, Project project) {
        GlobalConfig config;
        params.setIdeSeries(IdeSeriesType.JETBRAINS.getName());
        params.setIdePlatform(ApplicationUtil.getApplicationPlatform());
        params.setPluginVersion(Constants.getPluginVersion());
        params.setIdeVersion(ApplicationUtil.getApplicationVersion());
        params.setPluginPublisher(Constants.TELEMETRY_PLUGIN_PUBLISHER);
        params.setPluginName(Constants.TELEMETRY_PLUGIN_NAME);
        CosySetting setting = CosyPersistentSetting.getInstance().getState();
        boolean isAllowStatistics = setting != null && setting.isAllowReportUsage();
        params.setAllowStatistics(isAllowStatistics);
        String inferenceModeChanged = setting == null || setting.getParameter() == null ? CodeCompletionModeEnum.AUTO.mode : setting.getParameter().getLocal().getInferenceMode();
        params.setInferenceMode(inferenceModeChanged);
        int maxCandidateNumChanged = setting == null || setting.getParameter() == null ? CodeCompletionCandidateEnum.DEFAULT.num : setting.getParameter().getLocal().getMaxCandidateNum();
        params.setMaxCandidateNum(maxCandidateNumChanged);
        if (null != setting) {
            params.setPreferredLanguage(setting.getChatLanguage());
        }
        if (null != (config = CosyConfigurable.getGlobalConfig(project))) {
            params.setIsEnableAutoMemory(config.getIsEnableAutoMemory());
        }
    }

    private boolean initCosyLanguageService(Project project, File homeDir, boolean debugMode) throws IOException {
        CosySetting setting = CosyPersistentSetting.getInstance().getState();
        if (setting == null || Objects.equals(setting.getTransportType(), TransportTypeEnum.WEBSOCKET.getTransportType())) {
            log.info("init cosy language service with channel type: websocket");
            File infoFile = new File(homeDir, COSY_INFO_FILE_NAME);
            Pair<Integer, Long> infoPair = this.checkInfoFile(infoFile);
            if (infoPair != null) {
                log.info(".info exists, start to connect Cosy server");
                return this.connectCosyServerWithWebSocket(project, homeDir, debugMode);
            }
            log.info(".info not exist, start to create Cosy process");
            return this.startCosyBinaryAndConnectWebsocket(project, homeDir, debugMode);
        }
        log.info("init cosy language service with channel type: stdio");
        return this.connectCosyServerWithPipe(project, homeDir, debugMode);
    }

    private boolean startCosyBinaryAndConnectWebsocket(Project project, File homeDir, boolean debugMode) throws IOException {
        ++this.cosyStartRetryTimes;
        if (this.cosyStartRetryTimes >= 3) {
            return false;
        }
        if (this.binaryRunner == null) {
            this.binaryRunner = new BinaryRunner(homeDir);
        }
        if (!this.binaryRunner.run()) {
            log.warn("Cosy binary run failed");
            return false;
        }
        if (SystemInfo.isWindows) {
            ThreadUtil.sleep(3000L);
        } else {
            ThreadUtil.sleep(1000L);
        }
        return this.connectCosyServerWithWebSocket(project, homeDir, debugMode);
    }

    private boolean connectCosyServerWithPipe(Project project, File homeDir, boolean debugMode) throws IOException {
        String workDir = Cosy.buildProjectWorkDir(project, homeDir.getAbsolutePath());
        Pair<Integer, Long> infoPair = this.readCosyInfoFile(new File(workDir), 1, false);
        if (infoPair != null) {
            Integer port = (Integer)infoPair.first;
            Long pid = (Long)infoPair.second;
            if (pid != null && pid > 0L) {
                INSTANCE.killProcessAndDeleteInfoFile(pid);
            }
        }
        try {
            ThreadUtil.sleep(1000L);
            if (this.binaryRunner == null) {
                this.binaryRunner = new BinaryRunner(homeDir);
            }
            List<String> commands = this.binaryRunner.buildStartCommands();
            LanguageWebSocketService languageService = LanguageWebSocketService.createServiceWithPipe(project, homeDir, workDir, commands);
            languageService.connect();
            this.languageServiceMap.put(project.getLocationHash(), languageService);
            Thread heartBeat = new Thread(new CosyHeartbeatRunner(project, languageService.getLanguageClient(), languageService.getServer()));
            heartBeat.start();
        }
        catch (Exception e) {
            log.warn("Connect to Cosy server error, try to kill process and restart", (Throwable)e);
            infoPair = this.readCosyInfoFile(new File(workDir), 1, false);
            if (infoPair != null) {
                Integer port = (Integer)infoPair.first;
                Long pid = (Long)infoPair.second;
                if (pid != null && pid > 0L) {
                    INSTANCE.killProcessAndDeleteInfoFile(pid);
                }
            }
            if (SystemInfo.isWindows) {
                ThreadUtil.sleep(3000L);
            } else {
                ThreadUtil.sleep(1000L);
            }
            return this.connectCosyServerWithPipe(project, homeDir, debugMode);
        }
        return true;
    }

    private boolean connectCosyServerWithWebSocket(Project project, File homeDir, boolean debugMode) throws IOException {
        Pair<Integer, Long> infoPair = this.readCosyInfoFile(60, true);
        if (infoPair == null) {
            log.warn("Cannot read from .info, connect to Cosy server failed");
            return false;
        }
        Integer port = (Integer)infoPair.first;
        Long pid = (Long)infoPair.second;
        if (port == null || port.longValue() <= 0L || pid == null) {
            log.warn("Cannot get port and pid from .info file, connect failed");
            return false;
        }
        try {
            ThreadUtil.sleep(200L);
            log.info("Connecting port " + port + " pid:" + pid);
            LanguageWebSocketService languageService = LanguageWebSocketService.createService(project, port);
            languageService.connect();
            this.languageServiceMap.put(project.getLocationHash(), languageService);
            Thread heartBeat = new Thread(new CosyHeartbeatRunner(project, languageService.getLanguageClient(), languageService.getServer()));
            heartBeat.start();
        }
        catch (Exception e) {
            log.warn("Connect to Cosy server error, try to kill process and restart", (Throwable)e);
            INSTANCE.killProcessAndDeleteInfoFile(pid);
            return this.startCosyBinaryAndConnectWebsocket(project, homeDir, debugMode);
        }
        return true;
    }

    public void killProcessAndDeleteInfoFile(Long pid) {
        if (pid > 0L && ProcessUtils.isProcessAlive(pid)) {
            log.info(String.format("%d is alive, try to kill", pid));
            ProcessUtils.killProcess(pid);
        }
        this.deleteInfoFile();
    }

    public void deleteInfoFile() {
        File homeDir = this.getCosyHomeDir();
        if (homeDir == null) {
            return;
        }
        File infoFile = new File(homeDir, COSY_INFO_FILE_NAME);
        if (infoFile.exists()) {
            try {
                infoFile.delete();
                log.info("Delete .info file success.");
            }
            catch (Exception deleteException) {
                log.warn("Delete .info file encountered exception", (Throwable)deleteException);
            }
        }
    }

    public Pair<Integer, Long> readCosyInfoFile(File homeDir, int maxRetryTimes, boolean includeWithProcessName) {
        File infoFile = new File(homeDir, COSY_INFO_FILE_NAME);
        Integer port = null;
        Long pid = null;
        boolean delay = false;
        int i = 0;
        while (i < maxRetryTimes) {
            Pair<Integer, Long> infoPair = this.checkInfoFile(infoFile);
            if (infoPair != null) {
                port = (Integer)infoPair.first;
                pid = (Long)infoPair.second;
                break;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                log.warn("Thread sleep is interrupted when waiting for .info file");
            }
            log.info(String.format("Retry for fetching .info for %d times, %d times left", ++i, maxRetryTimes - i));
            if (delay || !SystemInfo.isWindows || i != maxRetryTimes) continue;
            delay = true;
            List<Long> cosyPidList = ProcessUtils.findCosyPidList();
            if (!CollectionUtils.isNotEmpty(cosyPidList)) continue;
            String pidListStr = org.apache.commons.lang3.StringUtils.join(cosyPidList, (String)",");
            log.info(String.format("Found lingma pid list: %s, delay max retry times", pidListStr == null ? "null" : pidListStr));
            maxRetryTimes *= 3;
        }
        if (port != null && pid != null) {
            return new Pair(port, pid);
        }
        if (includeWithProcessName) {
            return this.findProcessAndPortByName();
        }
        return null;
    }

    public Pair<Integer, Long> readCosyInfoFile(int maxRetryTimes, boolean includeWithProcessName) {
        File homeDir = this.getCosyHomeDir();
        if (homeDir == null) {
            return null;
        }
        return this.readCosyInfoFile(homeDir, maxRetryTimes, includeWithProcessName);
    }

    private Pair<Integer, Long> findProcessAndPortByName() {
        log.info("try find process and port by name");
        List<Long> cosyPidList = ProcessUtils.findCosyPidList();
        String pidListStr = org.apache.commons.lang3.StringUtils.join(cosyPidList, (String)",");
        log.info(String.format("Found cosy pid list: %s", pidListStr == null ? "null" : pidListStr));
        if (CollectionUtils.isNotEmpty(cosyPidList)) {
            return new Pair((Object)DEFAULT_LINGMA_PORT, (Object)cosyPidList.get(0));
        }
        if (ProcessUtils.isWindowsPlatform()) {
            return new Pair((Object)DEFAULT_LINGMA_PORT, (Object)0L);
        }
        return null;
    }

    private Pair<Integer, Long> checkInfoFile(@NotNull File infoFile) {
        if (infoFile == null) {
            Cosy.$$$reportNull$$$0(0);
        }
        if (!infoFile.exists()) {
            log.info(".info file not exist, wait 100ms and retry");
        } else {
            try {
                String rawText = FileUtils.readFileToString((File)infoFile, (Charset)StandardCharsets.UTF_8);
                if (rawText == null || rawText.isEmpty()) {
                    log.warn(".info file is empty, check failed");
                    return null;
                }
                String[] lines = rawText.split("\r\n|\n");
                if (lines.length != 2) {
                    log.warn(".info file is empty or has more or less than 2 lines:" + rawText);
                    return null;
                }
                Long port = StringUtils.getNumberFromString(lines[0]);
                Long pid = StringUtils.getNumberFromString(lines[1]);
                log.info("Read.info file get port:" + port + ", pid:" + pid);
                if (port == null || pid == null) {
                    log.warn("Cannot get port and pid from.info file, check failed");
                    return null;
                }
                return new Pair((Object)port.intValue(), (Object)pid);
            }
            catch (IOException e) {
                log.warn("Parsing .info file encountered Exception", (Throwable)e);
            }
            catch (Throwable throwable) {
                log.warn("Check info file encountered Throwable", throwable);
            }
        }
        return null;
    }

    public void close(Project project) {
        if (project == null) {
            return;
        }
        String key = project.getLocationHash();
        if (this.languageServiceMap.containsKey(key) && this.languageServiceMap.get(key) != null) {
            this.languageServiceMap.get(key).closeSession();
            this.languageServiceMap.remove(key);
        }
        if (this.readyMap.containsKey(key) && this.readyMap.get(key) != null) {
            this.readyMap.remove(key);
        }
        if (this.readyMap.size() == 0 && this.languageServiceMap.size() == 0) {
            this.binaryRunner = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart(Project project, List<CosyStartupListener> listeners) {
        AtomicBoolean startingState = this.startingStateMap.computeIfAbsent(project.getName(), e -> new AtomicBoolean(false));
        if (startingState.get()) {
            log.warn("Project " + project.getName() + " is restarting cosy, ignore repeat restarting");
            return;
        }
        AtomicBoolean atomicBoolean = startingState;
        synchronized (atomicBoolean) {
            if (startingState.get()) {
                log.warn("Project " + project.getName() + " is restarting cosy, ignore repeat restarting");
                return;
            }
            this.close(project);
        }
        if (listeners == null) {
            listeners = Collections.emptyList();
        }
        this.start(project, listeners);
    }

    private boolean isReady(Project project) {
        if (this.readyMap == null || project == null) {
            return false;
        }
        return this.readyMap.containsKey(project.getLocationHash()) && Boolean.TRUE.equals(this.readyMap.get(project.getLocationHash()));
    }

    public boolean checkCosy(Project project) {
        return this.checkCosy(project, true);
    }

    public boolean checkCosy(Project project, boolean autoRestart) {
        return this.checkCosy(project, autoRestart, Collections.emptyList());
    }

    public boolean checkCosy(Project project, boolean autoRestart, List<CosyStartupListener> listeners) {
        LanguageWebSocketService languageWebSocketService = INSTANCE.getLanguageService(project);
        boolean isReady = this.isReady(project);
        if (!isReady || languageWebSocketService == null || !languageWebSocketService.isSessionOpen()) {
            if (autoRestart) {
                this.restart(project, listeners);
            }
            return false;
        }
        return true;
    }

    public boolean checkAndWaitCosyState(ProgressIndicator progressIndicator, @NotNull Project project) {
        if (project == null) {
            Cosy.$$$reportNull$$$0(1);
        }
        return this.checkAndWaitCosyState(progressIndicator, project, TimeUnit.SECONDS.toMillis(20L));
    }

    /*
     * Exception decompiling
     */
    public boolean checkAndWaitCosyState(ProgressIndicator progressIndicator, @NotNull Project project, long maxTime) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 4[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public LanguageWebSocketService getLanguageService(Project project) {
        if (project == null) {
            return null;
        }
        if (this.languageServiceMap.containsKey(project.getLocationHash()) && this.languageServiceMap.get(project.getLocationHash()) != null) {
            return this.languageServiceMap.get(project.getLocationHash());
        }
        return null;
    }

    private List<LanguageWebSocketService> getAllLanguageServices() {
        return this.languageServiceMap.values().stream().filter(languageService -> languageService != null).collect(Collectors.toList());
    }

    public void updateConfig(ChangeUserSettingParams params) {
        INSTANCE.getAllLanguageServices().forEach(languageService -> languageService.changeUsageStatisticsSetting(params));
    }

    public static String buildProjectWorkDir(Project project, String lingmaHome) {
        String workspaceTempDir;
        File workspaceTempDirPath;
        File workspacePath = new File(lingmaHome, "workspace");
        if (!workspacePath.exists()) {
            workspacePath.mkdirs();
        }
        if (!(workspaceTempDirPath = new File(workspacePath, workspaceTempDir = project.getName() + "-" + Cosy.generateProjectHash(project))).exists()) {
            workspaceTempDirPath.mkdirs();
        }
        return workspaceTempDirPath.getAbsolutePath();
    }

    private static String generateProjectHash(Project project) {
        String independentPath = org.apache.commons.lang3.StringUtils.replace((String)project.getBasePath(), (String)File.separator, (String)"/");
        return Integer.toHexString(independentPath.hashCode());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infoFile";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/alibabacloud/intellij/cosy/core/Cosy";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkInfoFile";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkAndWaitCosyState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

