/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.core;

import com.alibabacloud.intellij.cosy.core.BinaryManager;
import com.alibabacloud.intellij.cosy.util.ProcessReader;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public final class BinaryUpdater {
    private static final Logger log = Logger.getInstance(BinaryUpdater.class);
    private static final long UPDATE_TIMEOUT = 600L;

    public static void checkUpdate(File workDirectory) {
        try {
            String binaryPath = BinaryManager.INSTANCE.getBinaryPath(workDirectory);
            if (binaryPath == null) {
                return;
            }
            List<String> commands = BinaryUpdater.createCommand(binaryPath, workDirectory);
            ProcessBuilder builder = new ProcessBuilder(commands);
            builder.directory(workDirectory);
            Process process = builder.start();
            ProcessReader reader = new ProcessReader(process);
            reader.start();
            log.info("wait for updating");
            process.waitFor(600L, TimeUnit.SECONDS);
            log.info("process output:" + reader.getOutput());
            reader.interrupt();
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException e) {
            log.error("check update interrupted." + e.getMessage());
        }
    }

    private static List<String> createCommand(@NotNull String binaryPath, @NotNull File workDirectory) {
        if (binaryPath == null) {
            BinaryUpdater.$$$reportNull$$$0(0);
        }
        if (workDirectory == null) {
            BinaryUpdater.$$$reportNull$$$0(1);
        }
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(binaryPath);
        commands.add("update");
        return commands;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "binaryPath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "workDirectory";
                break;
            }
        }
        objectArray[1] = "com/alibabacloud/intellij/cosy/core/BinaryUpdater";
        objectArray[2] = "createCommand";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

