/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.constants;

import com.alibabacloud.intellij.cosy.common.CosyConfig;
import com.alibabacloud.intellij.cosy.core.ConfigManager;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.CloudType;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.ConfigInfo;
import com.alibabacloud.intellij.cosy.util.LoginUtil;
import com.alibabacloud.intellij.cosy.util.ProjectUtils;
import com.intellij.openapi.project.Project;
import lombok.Generated;

public enum LingmaUrls {
    OPEN_FEEDBACK_URL("feedbackUrl", "url_config.feedback", "https://survey.aliyun.com/apps/zhiliao/gLgsYL8mB", "https://survey.alibabacloud.com/uone/sg/survey/2LLXIh8Vh"),
    MESSAGE_FEEDBACK_URL("feedbackUrl", "url_config.feedback", "https://survey.aliyun.com/apps/zhiliao/gLgsYL8mB", "https://survey.alibabacloud.com/uone/sg/survey/2LLXIh8Vh"),
    SURVEY_URL("surveyUrl", "url_config.survey_feedback", "https://survey.aliyun.com/apps/zhiliao/gLgsYL8mB", "https://survey.alibabacloud.com/uone/sg/survey/2LLXIh8Vh"),
    HELP_DOCUMENT_URL("helpDocumentUrl", "url_config.help", "https://help.aliyun.com/zh/lingma/", "https://www.alibabacloud.com/help/en/lingma/", "https://docs.qoder.com/"),
    DEVELOPER_HELP_DOCUMENT_URL("developerHelpDocumentUrl", "url_config.url_developer_config", "https://help.aliyun.com/zh/lingma/", "https://www.alibabacloud.com/help/en/lingma/user-guide/ai-developer-guidlines"),
    TEAM_DOCS_URL("teamDocsUrl", "url_config.team_docs", "https://help.aliyun.com/document_detail/2796751.html", "https://www.alibabacloud.com/help/en/lingma/user-guide/enterprise-knowledge-base-q-a"),
    HOMEPAGE_URL("homepageUrl", "url_config.homepage", "https://lingma.aliyun.com", "https://lingma.aliyun.com", "https://docs.qoder.com/"),
    EXPR_APPLY_URL("exprApplyUrl", "url_config.join", "https://tongyi.aliyun.com/lingma"),
    NETWORK_ERROR_URL("networkErrorUrl", "url_config.network_error", "https://help.aliyun.com/document_detail/2671485.html", "https://help.aliyun.com/document_detail/2671485.html", "https://docs.qoder.com/user-guide/configure-network-proxy"),
    FAQ_URL("faqUrl", "url_config.faq", "https://help.aliyun.com/zh/lingma/support/troubleshooting-guide", "https://help.aliyun.com/zh/lingma/support/troubleshooting-guide", "https://docs.qoder.com/troubleshooting/troubleshooting-guide"),
    GET_ACCESS_KEY_URL("accessKeyUrl", "url_config.access_key", "https://help.aliyun.com/zh/ram/user-guide/create-an-accesskey-pair"),
    GET_ACCESS_TOKEN_URL("accessTokenUrl", "url_config.access_token", "https://account-devops.aliyun.com/settings/personalAccessToken"),
    SYSTEM_RULE_EXAMPLE_URL("systemRuleExampleUrl", "url_config.system_rule_example", "https://help.aliyun.com/document_detail/2872908.html"),
    TERMS_OF_USE("termsOfUseUrl", "url_config.terms_of_use", "https://terms.alicdn.com/legal-agreement/terms/c_platform_service_agreement/20231023213402278/20231023213402278.html", "https://www.alibabacloud.com/help/zh/legal/latest/alibaba-cloud-international-website-product-terms-of-service", "https://qoder.com/product-service"),
    PRIVACY_POLICY("privacyPolicyUrl", "url_config.privacy_policy", "https://terms.alicdn.com/legal-agreement/terms/privacy_policy_full/20231023213159724/20231023213159724.html", "https://www.alibabacloud.com/help/legal/latest/alibaba-cloud-international-website-privacy-policy", "https://qoder.com/privacy-policy"),
    TROUBLESHOOTING_ACCOUNT_MANAGEMENT("troubleshootingAccountManagementUrl", "url_config.troubleshootingAccountManagementUrl", "", "", "https://docs.qoder.com/troubleshooting/common-issue#account-management"),
    PRICING("pricingUrl", "url_config.pricing", "", "", "https://qoder.com/pricing");

    final String refId;
    final String key;
    final String defaultUrl;
    final String cnDefaultUrl;
    final String intlDefaultUrl;
    final String qoderDefaultUrl;

    private LingmaUrls(String refId, String key, String defaultUrl) {
        this.refId = refId;
        this.key = key;
        this.defaultUrl = defaultUrl;
        this.cnDefaultUrl = defaultUrl;
        this.intlDefaultUrl = defaultUrl;
        this.qoderDefaultUrl = defaultUrl;
    }

    private LingmaUrls(String refId, String key, String cnDefaultUrl, String intlDefaultUrl) {
        this.refId = refId;
        this.key = key;
        this.cnDefaultUrl = cnDefaultUrl;
        this.intlDefaultUrl = intlDefaultUrl;
        this.defaultUrl = cnDefaultUrl;
        this.qoderDefaultUrl = cnDefaultUrl;
    }

    private LingmaUrls(String refId, String key, String cnDefaultUrl, String intlDefaultUrl, String qoderDefaultUrl) {
        this.refId = refId;
        this.key = key;
        this.cnDefaultUrl = cnDefaultUrl;
        this.intlDefaultUrl = intlDefaultUrl;
        this.defaultUrl = cnDefaultUrl;
        this.qoderDefaultUrl = qoderDefaultUrl;
    }

    public String getEnvironmentUrl(CloudType env) {
        if (!this.cnDefaultUrl.equals(this.intlDefaultUrl)) {
            switch (env) {
                case CLOUD: 
                case VIP: {
                    return this.cnDefaultUrl;
                }
                case INDIVIDUAL_INTL: 
                case DEDICATED_INTL: {
                    return this.intlDefaultUrl;
                }
            }
            return this.defaultUrl;
        }
        return this.defaultUrl;
    }

    public String getRealUrl() {
        ConfigInfo info = ConfigManager.INSTANCE.getConfig();
        if (CosyConfig.isQoderEnabled()) {
            return info.getStringByPath(this.key, this.qoderDefaultUrl);
        }
        Project project = ProjectUtils.getActiveProject();
        String cloudType = LoginUtil.getAuthStatus(project).getCloudType();
        CloudType env = CloudType.getById(cloudType);
        return null == info || !CloudType.VPC.equals((Object)env) ? this.getEnvironmentUrl(env) : info.getStringByPath(this.key, this.getEnvironmentUrl(env));
    }

    public static LingmaUrls fromRefId(String refId) {
        for (LingmaUrls url : LingmaUrls.values()) {
            if (!url.refId.equalsIgnoreCase(refId)) continue;
            return url;
        }
        return null;
    }

    @Generated
    public String getRefId() {
        return this.refId;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public String getDefaultUrl() {
        return this.defaultUrl;
    }

    @Generated
    public String getCnDefaultUrl() {
        return this.cnDefaultUrl;
    }

    @Generated
    public String getIntlDefaultUrl() {
        return this.intlDefaultUrl;
    }

    @Generated
    public String getQoderDefaultUrl() {
        return this.qoderDefaultUrl;
    }

    public static enum Environment {
        CN,
        INTL;

    }
}

